<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <link rel="shortcut icon" href="<?php echo e(asset('assets/favicon.svg')); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.title')); ?></title>

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Font Awesome -->
    <script src="https://kit.fontawesome.com/ee244dc737.js" crossorigin="anonymous"></script>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.min.js"></script>
  
    <!-- Select2 CSS & JS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

</head>

<body class="bg-gray-100">

    <!-- Sidebar Included Here -->
    <div id="sidebar-container">
        <?php echo $__env->make('schoolLayout.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <!-- Navbar Included Here -->
    <div id="navbar-container">
        <?php echo $__env->make('schoolLayout.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>


    
    <div id="main-content" class="ml-64 mt-20 px-3">
        <?php echo $__env->yieldContent('content'); ?>
    </div>

</body>
<?php echo $__env->yieldContent('script'); ?>
<script>
    function toggleDropdown(button) {
        document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
            if (dropdown !== button.nextElementSibling) {
                dropdown.classList.add("hidden");
            }
        });

        button.nextElementSibling.classList.toggle("hidden");
    }
</script>

</html>
<?php /**PATH C:\xamp\htdocs\REMS\resources\views/schoolLayout/app.blade.php ENDPATH**/ ?>