<?php if($paginator->hasPages()): ?>
    <nav role="navigation" aria-label="Pagination Navigation" class="mt-6 px-4">
        <!-- Showing X to Y of Z results -->
        <div class="flex justify-between items-center mb-4">
            <p class="text-sm text-gray-700">
                Showing
                <span class="font-medium"><?php echo e($paginator->firstItem()); ?></span>
                to
                <span class="font-medium"><?php echo e($paginator->lastItem()); ?></span>
                of
                <span class="font-medium"><?php echo e($paginator->total()); ?></span>
                results
            </p>

            <!-- Pagination Links -->
            <div class="flex gap-2">
                <!-- Previous Button -->
                <?php if($paginator->onFirstPage()): ?>
                    <span class="px-3 py-1 border border-gray-300 rounded-lg text-gray-400 cursor-not-allowed">
                        Previous
                    </span>
                <?php else: ?>
                    <a href="<?php echo e($paginator->previousPageUrl()); ?>" class="px-3 py-1 border border-gray-300 rounded-lg hover:bg-gray-100">
                        Previous
                    </a>
                <?php endif; ?>

                <!-- Page Numbers -->
                <?php $__currentLoopData = $paginator->getUrlRange(1, $paginator->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($page == $paginator->currentPage()): ?>
                        <span class="px-3 py-1 border border-gray-300 bg-blue-700 text-white rounded-lg">
                            <?php echo e($page); ?>

                        </span>
                    <?php else: ?>
                        <a href="<?php echo e($url); ?>" class="px-3 py-1 border border-gray-300 rounded-lg hover:bg-gray-100">
                            <?php echo e($page); ?>

                        </a>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <!-- Next Button -->
                <?php if($paginator->hasMorePages()): ?>
                    <a href="<?php echo e($paginator->nextPageUrl()); ?>" class="px-3 py-1 border border-gray-300 rounded-lg hover:bg-gray-100">
                        Next
                    </a>
                <?php else: ?>
                    <span class="px-3 py-1 border border-gray-300 rounded-lg text-gray-400 cursor-not-allowed">
                        Next
                    </span>
                <?php endif; ?>
            </div>
        </div>
    </nav>
<?php endif; ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/vendor/pagination/custom-pagination.blade.php ENDPATH**/ ?>