<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Student Fee Structure PDF</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 13px;
            color: #333;
            margin: 30px;
        }

        h2 {
            text-align: center;
            font-size: 20px;
            margin-bottom: 25px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 25px;
        }

        th, td {
            border: 1px solid #bbb;
            padding: 8px;
            text-align: center;
        }

        th {
            background-color: #f0f0f0;
            font-weight: bold;
        }

        .class-header {
            background-color: #d1e7dd;
            font-weight: bold;
            text-align: left;
            padding-left: 10px;
        }

        .footer {
            text-align: center;
            font-size: 12px;
            margin-top: 40px;
            color: #666;
        }
    </style>
</head>
<body>
    <h2>Student Fee Structure</h2>

    <table>
        <thead>
            <tr>
                <th>Class</th>
                <th>Admission</th>
                <th>Promotion</th>
                <th>Tuition</th>
                <th>Lab</th>
                <th>Exam</th>
                <th>Board</th>
                <th>Entertainment</th>
                <th>Other</th>
                <th>Books</th>
                <th>Annual</th>
                <th>Second Time</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $structures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $fees = $amounts->where('class_id', $structure->class_id)->keyBy('fee_type');
                ?>
                <tr>
                    <td><?php echo e($structure->class->name ?? 'N/A'); ?></td>
                    <td>Rs. <?php echo e($fees['admission_fee']->amount ?? 0); ?></td>
                    <td>Rs. <?php echo e($fees['promotion_fee']->amount ?? 0); ?></td>
                    <td>Rs. <?php echo e($fees['tuition_fee']->amount ?? 0); ?></td>
                    <td>Rs. <?php echo e($fees['lab_fee']->amount ?? 0); ?></td>
                    <td>Rs. <?php echo e($fees['exam_fee']->amount ?? 0); ?></td>
                    <td>Rs. <?php echo e($fees['board_fee']->amount ?? 0); ?></td>
                    <td>Rs. <?php echo e($fees['entertainment_fee']->amount ?? 0); ?></td>
                    <td>Rs. <?php echo e($fees['other_fee']->amount ?? 0); ?></td>
                    <td>Rs. <?php echo e($fees['books_charges']->amount ?? 0); ?></td>
                    <td>Rs. <?php echo e($fees['annual_charges']->amount ?? 0); ?></td>
                    <td>Rs. <?php echo e($fees['second_time_fee']->amount ?? 0); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer">
        Printed on <?php echo e(\Carbon\Carbon::now()->format('d M Y h:i A')); ?>

    </div>
</body>
</html>
<?php /**PATH C:\xamp\htdocs\REMS\resources\views/stdFeeMgt/pdfStudentFeeStructure.blade.php ENDPATH**/ ?>