<table class="w-full border-collapse">
    <thead>
        <tr class="text-gray-700 bg-gray-50 text-sm">
            <th class="p-3 text-left font-semibold">Employee</th>
            <th class="p-3 text-left font-semibold">Job Category</th>
            <th class="p-3 text-left font-semibold">Qualification</th>
            <th class="p-3 text-left font-semibold">Status</th>
            <th class="p-3 text-center font-semibold">Actions</th>
        </tr>
    </thead>
    <tbody class="bg-white rounded-lg shadow">
        <?php $__currentLoopData = $staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="border-b hover:bg-blue-50 transition">
                <!-- Employee Name & Email -->
                <td class="p-3 flex items-center gap-3">
                    <img src="<?php echo e($member && $member->profile_photo ? url('/staff-members/' . $member->profile_photo) : asset('assets/sidebar/student.png')); ?>"
                        alt="Staff Member photo" class="w-10 h-10 rounded-full border border-gray-200 shadow-sm" />
                    <div>
                        <div class="font-semibold text-gray-800"><?php echo e($member->full_name); ?></div>
                        <div class="text-xs text-gray-500"><?php echo e($member->email); ?></div>
                        <div class="text-xs text-gray-500"><?php echo e($member->cnic); ?></div>
                         <div class="text-xs text-gray-500"><?php echo e($member->registration_no); ?></div>
                    </div>
                </td>
                <!-- Job Category -->
                <td class="p-3 text-gray-700"><?php echo e(Str::ucfirst($member->job_position->category)); ?></td>
                <!-- Qualification -->
                <td class="p-3 text-gray-700"><?php echo e($member->qualifications); ?></td>
                <!-- Status -->
                <td class="p-3">
                    <?php if($member->status == 'active'): ?>
                        <span
                            class="bg-green-100 text-green-700 px-3 py-1 rounded-2xl text-xs font-semibold">Active</span>
                    <?php elseif($member->status == 'resigned'): ?>
                        <span
                            class="bg-yellow-100 text-yellow-700 px-3 py-1 rounded-2xl text-xs font-semibold">Resigned</span>
                    <?php else: ?>
                        <span
                            class="bg-gray-100 text-gray-700 px-3 py-1 rounded-2xl text-xs font-semibold"><?php echo e(ucfirst($member->status)); ?></span>
                    <?php endif; ?>
                </td>
                <!-- Actions -->
                <td class="p-3 text-center relative">
                    <button onclick="toggleDropdown(this)"
                        class="action-btn px-2 py-1 rounded hover:bg-gray-100 focus:outline-none" title="Actions">
                        <img src="<?php echo e(asset('assets/actions.png')); ?>" alt="icons" class="w-5 h-5" />
                    </button>
                    <div
                        class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 shadow-lg rounded-lg border">
                        <a href="<?php echo e(route('staff.profile', $member->id)); ?>"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm">
                            <i class="fa-solid fa-eye text-blue-600"></i> View Profile
                        </a>
                        <a href="<?php echo e(route('staff.edit', $member->id)); ?>"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm">
                            <i class="fa-solid fa-pen-to-square text-green-600"></i> Edit Profile
                        </a>
                        <a href="#"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm"
                            onclick="updateStatus(<?php echo e($member->id); ?>, this); return false;">
                            <i class="fa-solid fa-key text-yellow-600"></i> Update Status
                        </a>
                    </div>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php /**PATH C:\xamp\htdocs\REMS\resources\views/staff/staffSearch.blade.php ENDPATH**/ ?>