<?php $__env->startSection('content'); ?>

    <?php if(session('error')): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error:</strong>
            <span class="block sm:inline"><?php echo e(session('error')); ?></span>
        </div>
    <?php endif; ?>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Success:</strong>
            <span class="block sm:inline"><?php echo e(session('success')); ?></span>
        </div>
    <?php endif; ?>

    <div class="bg-[#f9fafc] min-h-screen px-8 py-4">
        <!-- Top Section: Tabs & Button -->
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <div class="flex space-x-2 w-[50%]">
                
                <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                    onclick=" window.location.href = '<?php echo e(route('school-sessions')); ?>'">
                    Sessions
                </button>
                <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                    onclick="window.location.href = '<?php echo e(route('sections')); ?>'">
                    Sections
                </button>
                <button class="tab-btn px-8 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500"
                    >
                    Classes
                </button>
                <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                    onclick="window.location.href = '<?php echo e(route('subjects')); ?>'">
                    Subjects
                </button>
            </div>
            <a href="<?php echo e(route('class.list.pdf')); ?>" target="_blank"
                class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                Class PDF
            </a>
            <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-md" id="openModal">
                <i class="fa-solid fa-plus"></i>
                <span>Add New Class</span>
            </button>
        </div>

        <div class="border p-3 bg-white border-gray-200 rounded-lg my-4">

            <div class="relative bg-white">
                <table class="w-full border-collapse">
                    <thead class="bg-[#f9fafc]">
                        <tr class="text-gray-600">
                            <th class="p-3 text-left text-gray-500 font-medium">ID</th>
                            
                            <th class="p-3 text-left text-gray-500 font-medium">Class Name</th>
                            <th class="p-3 text-left text-gray-500 font-medium">Class Code</th>
                            
                            
                            <th class="p-3 text-left text-gray-500 font-medium">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white py-3 rounded-lg">
                        <?php if($classes): ?>
                            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="border-b">
                                    <td class="p-3 flex items-center ">
                                        <?php echo e($index + 1); ?>

                                    </td>
                                    
                                    <td class="p-3 text-gray-700"><?php echo e($class->name); ?></td>
                                    <td class="p-3 text-gray-700"><?php echo e($class->code); ?></td>
                                    
                                    
                                    <td class="p-3  flex  items-center gap-x-4">
                                        <i class="fa-solid fa-pen-to-square text-blue-500 cursor-pointer"
                                            onclick="openEditModal({
                              id: '<?php echo e($class->id); ?>',
                              name: '<?php echo e($class->name); ?>',
                              code: '<?php echo e($class->code); ?>'
                          })"></i>
                                        
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>


                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- Modal Background (Initially Hidden) -->
    <div id="modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <!-- Modal Content -->
        <div class="bg-white w-full max-w-lg rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <!-- Modal Header -->
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Create New Class</h2>
                <button type="button" id="closeModal" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <!-- Modal Body -->
            <form class="bg-white px-6 py-3" action="<?php echo e(route('store.class')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <!-- Class Name -->
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Class Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" placeholder="Grade 5, 8th, 10th" name="name"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                        required />
                </div>

                <!-- Class Code -->
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Class Code
                    </label>
                    <input type="text" placeholder="CL-202" name="code"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" />
                </div>

                <!-- Modal Footer -->
                <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button id="closeModalBtn" type="button"
                        class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Create Class
                    </button>
                </div>
            </form>
        </div>
    </div>


    <div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <div class="bg-white w-full max-w-lg rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Edit Class</h2>
                <button onclick="closeModal()" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <form id="editClassForm" method="POST" class="bg-white px-6 py-3">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="_method" value="PUT">
                <input type="hidden" id="editClassId" name="id">

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Class Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="editClassName" name="name"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                        required>
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Class Code
                    </label>
                    <input type="text" id="editClassCode" name="code"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button type="button" onclick="closeModal()"
                        class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Update Class
                    </button>
                </div>
            </form>
        </div>
    </div>




    <script>
        // Modal functionality
        const modal = document.getElementById("modal");
        const openModalBtn = document.getElementById("openModal");
        const closeModalBtns = [
            document.getElementById("closeModal"),
            document.getElementById("closeModalBtn"),
        ];

        openModalBtn.addEventListener("click", () => {
            modal.classList.remove("hidden");
        });

        closeModalBtns.forEach((btn) => {
            btn.addEventListener("click", () => {
                modal.classList.add("hidden");
            });
        });


        function openEditModal(classData) {
            document.getElementById('editClassId').value = classData.id;
            document.getElementById('editClassName').value = classData.name;
            document.getElementById('editClassCode').value = classData.code;
            document.getElementById('editClassForm').action = `/class/update/${classData.id}`;
            document.getElementById('editModal').classList.remove('hidden');
        }

        function closeModal() {
            document.getElementById('editModal').classList.add('hidden');
        }

        /*  function deleteClass(element) {
                  if (confirm('Are you sure you want to delete this class?')) {
                      const form = document.createElement('form');
                      form.method = 'get';
                      form.action = `/class/delete/${element.dataset.id}`;
                      form.innerHTML = `
          <?php echo csrf_field(); ?>
          <input type="hidden" name="_method" value="DELETE">
      `;
                      document.body.appendChild(form);
                      form.submit();
                  }
              }*/

        // Close modal when clicking outside
        document.addEventListener('DOMContentLoaded', function() {
            window.onclick = function(event) {
                const modal = document.getElementById('editModal');
                if (event.target === modal) {
                    closeModal();
                }
            }
        });
    </script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('schoolLayout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/class/classes.blade.php ENDPATH**/ ?>