<?php $__env->startSection('content'); ?>
   <?php if(session('success')): ?>
    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
        <strong class="font-bold">Success!</strong>
        <span class="block sm:inline"><?php echo e(session('success')); ?></span>
    </div>
   <?php endif; ?>
   <?php if(session('error')): ?>
    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
        <strong class="font-bold">Error!</strong>
        <span class="block sm:inline"><?php echo e(session('error')); ?></span>
    </div>
   <?php endif; ?>
<!-- Form Container -->
      <h1 class="text-3xl font-bold mb-6 text-gray-800 pt-4">Add Exam Marks</h1>

    <form name="frmexam" id="frmexam" action="<?php echo e(route('dmc.stuents')); ?>" method="post" class="bg-white p-6 rounded-sm shadow-md w-full space-y-6">
      <!-- Row 1 -->
       <?php echo csrf_field(); ?>
      <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div>
          <label class="block text-md font-medium text-gray-700">Class</label>
          <select name="class" required class="mt-1 px-2 outline-none py-2 block border border-gray-300 w-full">
            <option value="">Select</option>
            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($class->id); ?>" 
                    <?php echo e((isset($selectedClass) && $selectedClass == $class->id) || old('class') == $class->id ? 'selected' : ''); ?>>
                    <?php echo e($class->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>


        </div>
        <div>
          <label class="block text-md font-medium text-gray-700">Section</label>
          <select name="section" required class="mt-1 px-2 outline-none py-2 block border border-gray-300 w-full">
                <option value="">Select</option>
                  <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($section->id); ?>" 
                    <?php echo e((isset($selectedSection) && $selectedSection == $section->id) || old('section') == $section->id ? 'selected' : ''); ?>>
                    <?php echo e($section->name); ?>

                </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

             </select>
        </div>
        <div>
          <label class="block text-md font-medium text-gray-700">Subject</label>
          <select id="subject" name="subject" required class="mt-1 px-2 outline-none py-2 block border border-gray-300 w-full">
          <option value="">Select</option>
          <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($subject->id); ?>" 
                  <?php echo e((isset($selectedSubject) && $selectedSubject == $subject->id) || old('subject') == $subject->id ? 'selected' : ''); ?>>
                  <?php echo e($subject->name); ?>

              </option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>

        </div>
        <!-- <div>
          <label class="block text-md font-medium text-gray-700"
            >Subject type</label
          >
          <input
            placeholder="Final Term"
            type="text"
            class="mt-1 px-2 outline-none py-2 block w-full border border-gray-300"
          />
        </div> -->
      </div>

      <!-- Row 2 -->
      <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <div>
          <label class="block text-md font-medium text-gray-700">Exam</label>
           <select name="exam" required class="mt-1 px-2 outline-none py-2 block border border-gray-300 w-full">
            <option value="">Select</option>
            <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($exam->id); ?>" 
                    <?php echo e((isset($selectedExam) && $selectedExam == $exam->id) || old('exam') == $exam->id ? 'selected' : ''); ?>>
                    <?php echo e($exam->title); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        </div>
        <div>
          <label class="block text-md font-medium text-gray-700">Session</label>
          <select name="school_session" required
            class="mt-1 px-2 outline-none py-2 block border border-gray-300 w-full">
            <option value="">Select</option>
            <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sess): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($sess->id); ?>" 
                    <?php echo e((isset($selectedSession) && $selectedSession == $sess->id) || old('school_session') == $sess->id ? 'selected' : ''); ?>>
                    <?php echo e($sess->session_year); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

          </select>
        </div>
        <div class="pt-[26px]">
          <button
            type="submit"
            class="w-full bg-[#1B9AF5] text-white py-2 px-4 rounded-sm transition"
          >
            Get Records
          </button>
        </div>
      </div>
    </form>
    <div class="bg-white mt-6 shadow-xl rounded-lg">
      <!-- First row fields (Total Marks, Passing Marks) -->
      <div class="flex gap-6 p-6  md:w-1/2 w-full">
        <div class="flex flex-col w-1/2">
          <label for="totalMarks" class="mb-2 font-semibold text-gray-700"
            >Total Marks</label
          >
          <input
            id="totalMarks"
            type="number"
            name="total_marks"
            readonly
            class="rounded px-3 py-2 outline-none border border-gray-300"
            placeholder="Enter total marks"
          />
        </div>
        <div class="flex flex-col w-1/2">
          <label for="passingMarks" class="mb-2 font-semibold text-gray-700"
            >Passing Marks</label
          >
          <input
            id="passingMarks"
            type="number"
            readonly
            class="rounded px-3 py-2 outline-none border border-gray-300"
            placeholder="Enter passing marks"
          />
        </div>
      </div>

      <!-- Table -->
      <table
        class="border-separate w-full table-fixed px-4"
        style="border-spacing: 0 0.75rem"
      >
        <thead class="bg-[#fafafa] text-gray-600">
          <tr>
            <th class="px-4 text-gray-500 py-2 text-left w-20">Sr No</th>
            <th class="px-4 text-gray-500 py-2 text-left w-40">Registration No</th>
            <th class="px-4 text-gray-500 py-2 text-left w-40">Student Name</th>
            <th class="px-4 text-gray-500 py-2 text-left w-40">Father Name</th>
            <th class="px-4 text-gray-500 py-2 text-left w-24">Exam</th>
            <th class="w-full"></th>
            <th class="px-4 text-gray-500 py-2 text-right w-56">  Obtained Marks</th>
          </tr>
        </thead>
        <tbody >
          <form id="frmDMC" action="<?php echo e(route('dmc.store')); ?>" method="post">
          <?php echo csrf_field(); ?>
          <input type="hidden" name="class" value="<?php echo e(request('class')); ?>">
          <input type="hidden" name="section" value="<?php echo e(request('section')); ?>">
          <input type="hidden" name="subject" value="<?php echo e(request('subject')); ?>">
          <input type="hidden" name="exam" value="<?php echo e(request('exam')); ?>">
          <input type="hidden" name="school_session" value="<?php echo e(request('school_session')); ?>">
          <?php if($students): ?>
          <?php $i = 1; ?>
          <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td class="px-4 py-2 font-semibold"><?php echo e($i); ?></td>
            <td class="px-4 py-2 font-semibold"><?php echo e($student->reg_no); ?></td>
            <td class="px-4 py-2"><?php echo e($student->student_name); ?></td>
            <td class="px-4 py-2"><?php echo e($student->father_name); ?></td>
            <td class="px-4 py-2">Final Exam with session</td>
            <td></td>
            <td class="px-4 py-2 border border-gray-300 text-center mr-3">
              <input name="marks[]"  type="text" value="0" class="w-full text-center border-none focus:outline-none" />
              <input type="hidden" name="student_id[]" value="<?php echo e($student->id); ?>" />

            </td>
          </tr>
          <?php $i++; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php else: ?>
          <tr>
            <td colspan="7" class="px-4 py-2 text-center text-gray-500">No records found</td>
          </tr>
          <?php endif; ?>  
          </form>
          
          <tr>
            <td colspan="6" class="px-4 py-2 text-right font-semibold">  
              <button type="submit" form="frmDMC" class="bg-[#1B9AF5] text-white py-2 px-4 rounded-sm transition mt-4">Submit</button>
            </td>
          </tr>
          <!-- more rows -->
        </tbody>
      </table>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const subjectSelect = document.getElementById('subject');

    function fetchExamData(subjectId) {
        if (!subjectId) return; // Don't fetch if no subject is selected

        fetch(`/dmc/subject?subject_id=${subjectId}`)
            .then(response => response.json())
            .then(data => {
                console.log(data);
                document.getElementById('totalMarks').value = data.total_marks;
                document.getElementById('passingMarks').value = data.passing_marks;
            })
            .catch(error => console.error('Error fetching exams:', error));
    }

    // On subject change
    subjectSelect.addEventListener('change', function () {
        fetchExamData(this.value);
    });

    // On page load (if subject is already selected)
    fetchExamData(subjectSelect.value);
});

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('schoolLayout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/dmc/index.blade.php ENDPATH**/ ?>