<table class="w-full border-collapse">
    <thead>
        <tr class="text-gray-700 bg-gray-50 text-sm">
            <th class="p-3 text-center font-medium"><input type="checkbox" id="all_check" /></th>
            <th class="p-3 text-left font-semibold">Student</th>
            <th class="p-3 text-left font-semibold">Roll Number</th>
            <th class="p-3 text-left font-semibold">Class</th>
            <th class="p-3 text-left font-semibold">Section</th>
            <th class="p-3 text-left font-semibold">Phone</th>
            <th class="p-3 text-left font-semibold">Status</th>
            <th class="p-3 text-center font-semibold">Actions</th>
        </tr>
    </thead>
    <tbody class="bg-white rounded-lg shadow">
        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="border-b hover:bg-blue-50 transition">
                <!-- Checkbox -->
                <td class="p-3 text-center">
                    <input type="checkbox" class="select_student" name="students[]" value="<?php echo e($student->id); ?>" />
                </td>
                <!-- Student Name & Email -->
                <td class="p-3 flex items-center gap-3">
                    <img src="<?php echo e($student->documents && $student->documents->photo ? url('/student-image/' . $student->documents->photo) : asset('assets/sidebar/student.png')); ?>"
                        alt="Student photo" class="w-10 h-10 rounded-full border border-gray-200 shadow-sm" />
                    <div>
                        <div class="font-semibold text-gray-800"><?php echo e($student->student_name); ?></div>
                        <div class="text-xs text-gray-500"><?php echo e($student->email); ?></div>
                    </div>
                </td>
                <!-- Roll Number -->
                <td class="p-3 text-gray-700"><?php echo e($student->id); ?></td>
                <!-- Class -->
                <td class="p-3 text-gray-700">
                    <span><?php echo e($student->latestAdmission->class->name ?? 'N/A'); ?></span>
                </td>
                <!-- Section -->
                <td class="p-3 text-gray-700">
                    <?php $__currentLoopData = $student->sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span
                            class="inline-block bg-gray-100 text-gray-700 px-2 py-0.5 rounded text-xs mr-1"><?php echo e($section->name); ?></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
                <!-- Phone -->
                <td class="p-3 text-gray-700"><?php echo e($student->guardian->guardian_contact ?? 'N/A'); ?></td>
                <!-- Status -->
                <td class="p-3">
                    <span class="bg-green-100 text-green-700 px-3 py-1 rounded-2xl text-xs font-semibold">Present</span>
                </td>
                <!-- Actions -->
                <td class="p-3 text-center relative">
                    <button onclick="event.preventDefault();toggleDropdown(this)"
                        class="action-btn px-2 py-1 rounded hover:bg-gray-100 focus:outline-none" title="Actions">
                        <img src="<?php echo e(asset('assets/actions.png')); ?>" alt="icons" class="w-5 h-5" />
                    </button>
                    <div
                        class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 shadow-lg rounded-lg border">
                        <a href="<?php echo e(route('student.edit', $student->id)); ?>"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm">
                            <i class="fa-solid fa-pen-to-square text-blue-600"></i> Edit
                        </a>
                        <a href="#"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm">
                            <i class="fa-solid fa-id-card text-gray-500"></i> Print ID Card
                        </a>
                        <a href="<?php echo e(route('student.profile', $student->id)); ?>"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm">
                            <i class="fa-solid fa-eye text-green-600"></i> View Details
                        </a>
                        <a onclick="openStudentModal(<?php echo e(json_encode([
                            'student_name' => $student->student_name,
                            'id' => $student->id,
                            'class' => $student->classes->first()->name ?? 'N/A',
                            'section' => $student->sections->first()->name ?? 'N/A',
                            'admission' => $student->latestAdmission->admission_no,
                            'phone' => $student->guardian->guardian_contact ?? 'N/A',
                            'email' => $student->email,
                            'guardian_name' => $student->guardian->guardian_name ?? 'N/A',
                        ])); ?>)"
                            href="#"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm">
                            <i class="fa-solid fa-print text-indigo-600"></i> Print Admission Letter
                        </a>
                        <a href="<?php echo e(route('mark.as.alumni.single', $student->id)); ?>"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm">
                            <i class="fa-solid fa-graduation-cap text-yellow-600"></i> Mark as Alumni student
                        </a>
                    </div>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php /**PATH C:\xamp\htdocs\REMS\resources\views/student/current-student-search-results.blade.php ENDPATH**/ ?>