<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ClassController;
use App\Http\Controllers\StaffController;
use App\Http\Controllers\FeeMgtController;
use App\Http\Controllers\IncomeController;
use App\Http\Controllers\JobAppController;
use App\Http\Controllers\StudentDuesController;
use App\Http\Controllers\SchoolController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\SectionController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\SubjectController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\AdmissionController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\FeeReciptController;
use App\Http\Controllers\GenSalaryController;
use App\Http\Controllers\PaySalaryController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\IncomeCatgController;
use App\Http\Controllers\StudentAppController;
use App\Http\Controllers\ExpenseCatgController;
use App\Http\Controllers\FeeGenerateController;
use App\Http\Controllers\JobPositionController;
use App\Http\Controllers\StaffLedgerController;
use App\Http\Controllers\StudentCardController;
use App\Http\Controllers\FeeStructureController;
use App\Http\Controllers\SalaryStructController;
use App\Http\Controllers\StudentLedgerController;
use App\Http\Controllers\TeacherTimeTableController;
use App\Http\Controllers\ExamController;
use App\Http\Controllers\StaffPayableController;
use App\Http\Controllers\DocumentController;
use App\Http\Controllers\EditStudentAssignFeeController;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\DmcController;

Route::get('/student-image/{path}', [DocumentController::class, 'show'])->where('path', '.*');
Route::get('/school-logo/{filename}', [DocumentController::class, 'show_logo'])->where('filename', '.*');
Route::get('/staff-members/{path}', [DocumentController::class, 'staff_images'])->where('path', '.*');
Route::get('/student-qr-codes/{filename}', [DocumentController::class, 'qr_codes'])->where('filename', '.*');


Route::get('/download/student-photo/{filename}', function ($filename) {
    $path = storage_path('app/public/student_documents/' . $filename);

    if (!file_exists($path)) {
        abort(404, 'File not found');
    }

    return response()->download($path);
})->where('filename', '.*');

Route::get('/download/staff-photo/{filename}', function ($filename) {
    $path = storage_path('app/public/staff_members/' . $filename);

    if (!file_exists($path)) {
        abort(404, 'File not found');
    }

    return response()->download($path);
})->where('filename', '.*');



//landing page or Home page
Route::get('/', function () {
    $school = DB::table('school_settings')->where('setting_key', 'school_logo')->first();

    return view('home', compact('school'));
})->name('home');


//Accounts sections
Route::get('/fee-mgt/fee-categories', function () {
    return view('stdFeeMgt.fee-categories');
});
Route::get('/fee-mgt/fee-history', function () {
    return view('stdFeeMgt.fee-history');
});
Route::get('/fee-mgt/fee-invoices', function () {
    return view('stdFeeMgt.fee-invoices');
});
Route::get('/fee-mgt/fee-reminders', function () {
    return view('stdFeeMgt.fee-reminders');
});
Route::get('/fee-mgt/fee-refund-payments', function () {
    return view('stdFeeMgt.refund-pymnt');
});
Route::get('/fee-mgt/std-fee-history', function () {
    return view('stdFeeMgt.fee-history');
});
Route::get('/fee-mgt/std-fee', function () {
    return view('stdFeeMgt.std-fee');
});
Route::get('/fee-mgt/view-invoice', function () {
    return view('stdFeeMgt.view-invoice');
});

Route::middleware('auth')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->middleware(['auth', 'verified', 'role:super_admin,admin'])->name('dashboard');
    Route::get('/pdf/dashboard', [DashboardController::class, 'pdfDashboard'])->name('pdf.dashboard');

    /* Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy'); */
});


Route::get('/salary/struct/{head_code}', [SalaryStructController::class, 'getStruct'])->name('salary.struct.get');
Route::post('/salary/struct/update', [SalaryStructController::class, 'update'])->name('salary.struct.update');
Route::post('/salary/row/update', [SalaryStructController::class, 'updateSalaryRow'])->name('salary.row.update');
Route::get('/salary/single/{head_code}', [GenSalaryController::class, 'getSingle'])->name('salary.single.get');
Route::post('/salary/gn/store', [GenSalaryController::class, 'salaryStore'])->name('salary.gn.store');
Route::get('/staff/salary/list', [GenSalaryController::class, 'index'])->name('staff.salary');
Route::get('/staff/active/pdf', [StaffController::class, 'exportActiveStaffPDF'])->name('staff.active.pdf');
Route::get('/staff/resigned/pdf', [StaffController::class, 'exportPastStaffPDF'])->name('staff.past.pdf');
Route::get('/pdf/salary/list', [GenSalaryController::class, 'pdfSalaryList'])->name('pdf.salary.list');


Route::get('/salary/pay/list', [PaySalaryController::class, 'index'])->name('salary.pay.list');
Route::post('/salary/pay/store', [PaySalaryController::class, 'store'])->name('salary.pay.store');


Route::get('/staff', [StaffController::class, 'staff'])->name('staff');
Route::get('/staff/past', [StaffController::class, 'staffPast'])->name('staff.past');
Route::get('/staff/create', [StaffController::class, 'create'])->name('staff.create');
Route::post('/staff/store', [StaffController::class, 'store'])->name('staff.store');
Route::get('/staff/profile/{id}', [StaffController::class, 'profile'])->name('staff.profile');
Route::get('/staff/edit/{id}', [StaffController::class, 'edit'])->name('staff.edit');
Route::post('/staff/edit/{id}', [StaffController::class, 'update'])->name('staff.update');
Route::post('/staff/update-status/{id}', [StaffController::class, 'updateStatus'])->name('staff.updateStatus');
Route::get('/staff/ledger', [StaffLedgerController::class, 'staffLedger'])->name('staff.ledger');
Route::get('/staff/ledger/pdf', [StaffLedgerController::class, 'pdfStaffLedger'])->name('pdf.staff.ledger');
Route::get('/staff/ledger/get', [StaffLedgerController::class, 'getLedger'])->name('staff.ledger.get');



Route::get('/job/posit/create', [JobPositionController::class, 'create'])->name('job-positions-create');
Route::post('/job/posit/store', [JobPositionController::class, 'store'])->name('job-positions-store');
Route::get('/job/posit', [JobPositionController::class, 'index'])->name('job-positions');
Route::post('/job/posit/edit', [JobPositionController::class, 'edit'])->name('job_position.update');
Route::get('/job/posit/delete/{id}', [JobPositionController::class, 'delete'])->name('job_position.delete');
Route::get('/job/open/positions', [JobPositionController::class, 'indexOpen'])->name('job.open.positions');
Route::get('/job/close/positions', [JobPositionController::class, 'indexClose'])->name('job.close.positions');
Route::get('all/job/positions/pdf', [JobPositionController::class, 'pdfAllJobsPosition'])->name('all.job.positions.pdf');
Route::get('open/job/positions/pdf', [JobPositionController::class, 'pdfOpenJobsPosition'])->name('open.job.positions.pdf');
Route::get('close/job/positions/pdf', [JobPositionController::class, 'pdfCloseJobsPosition'])->name('close.job.positions.pdf');



Route::get('/job/app/create', [JobAppController::class, 'create'])->name('job_application_create');
Route::get('/job/app/{id?}', [JobAppController::class, 'index'])->name('job_application');
Route::post('/job/app/store', [JobAppController::class, 'store'])->name('job_application_store');
Route::get('/job/app/{id}/status/{status}', [JobAppController::class, 'status'])->name('job_application_status');
Route::get('/job/accepted/app', [JobAppController::class, 'indexAccepted'])->name('job.accepted.app');
Route::get('/job/rejected/app', [JobAppController::class, 'indexRejected'])->name('job.rejected.app');
Route::get('/job/pending/app', [JobAppController::class, 'indexPending'])->name('job.pending.app');
Route::get('/job/All/app/pdf', [JobAppController::class, 'pdfAllJobApp'])->name('pdf.all.job.app');
Route::get('/job/pending/app/pdf', [JobAppController::class, 'pdfPendingJobApp'])->name('pdf.pending.job.app');
Route::get('/job/rejected/app/pdf', [JobAppController::class, 'pdfRejectedJobApp'])->name('pdf.rejected.job.app');
Route::get('/job/accepted/app/pdf', [JobAppController::class, 'pdfAcceptedJobApp'])->name('pdf.accepted.job.app');



Route::get('/class', [ClassController::class, 'show'])->name('classes');
Route::get('/class/list/pdf', [ClassController::class, 'pdfClassList'])->name('class.list.pdf');
Route::post('/class/store', [ClassController::class, 'store'])->name('store.class');
Route::put('/class/update/{id}', [ClassController::class, 'update'])->name('update.class');
Route::get('/class/delete/{id}', [ClassController::class, 'delete'])->name('delete.class');

Route::get('/section', [SectionController::class, 'show'])->name('sections');
Route::get('/section/list/pdf', [SectionController::class, 'pdfSectionList'])->name('pdf.section.list');
Route::post('/section/store', [SectionController::class, 'store'])->name('store.sections');
Route::put('/section/update/{id}', [SectionController::class, 'update'])->name('update.section');
Route::get('/section/delete/{id}', [SectionController::class, 'delete'])->name('delete.section');

Route::get('/subject', [SubjectController::class, 'show'])->name('subjects');
Route::get('/subjects/list/pdf', [SubjectController::class, 'pdfSubjectList'])->name('pdf.subject.list');
Route::post('/subject/store', [SubjectController::class, 'store'])->name('store.subjects');
Route::put('/subject/update/{id}', [SubjectController::class, 'update'])->name('update.subject');
Route::get('/subject/delete/{id}', [SubjectController::class, 'delete'])->name('delete.subject');

Route::get('/school/sessions', [SchoolController::class, 'index'])->name('school-sessions');
Route::get('/school/sessions/{id}', [SchoolController::class, 'get_school_session_data'])->name('school-sessions.edit');
Route::put('/school/sessions/update', [SchoolController::class, 'update'])->name('school-sessions.update');
Route::post('/school/sessions/store', [SchoolController::class, 'store'])->name('school-sessions-store');
Route::get('/school/sessions/delete/{id}', [SchoolController::class, 'delete'])->name('school.sessions.delete');

Route::get('/teacher/timetable', [TeacherTimeTableController::class, 'timetable'])->name('teacher.timetable');
Route::get('/teacher/timetable/pdf', [TeacherTimeTableController::class, 'pdfTeacherTimetable'])->name('teacher.timetable.pdf');
Route::post('/teacher/timetable/store', [TeacherTimeTableController::class, 'store'])->name('store.teacher.timetable');


Route::get('/student/ledger', [StudentLedgerController::class, 'stdLedger'])->name('student.ledger');
Route::get('/student/ledger/get', [StudentLedgerController::class, 'getLedger'])->name('student.ledger.get');
Route::get('/student/ledger/pdf', [StudentLedgerController::class, 'pdfStudentLedger'])->name('pdf.student.ledger');


Route::get('/std/app/pass/{id}', [StudentAppController::class, 'passData'])->name('std.app.pass');
Route::post('/std/app/status/{id}', [StudentAppController::class, 'updateStatus'])->name('std.app.status');
Route::get('/std/app/profile/{id}', [StudentAppController::class, 'profile'])->name('std.app.profile');
Route::get('std/app', [StudentAppController::class, 'index'])->name('student.application');

Route::get('/student/application/all/pdf', [StudentAppController::class, 'pdfStudentApplicationAll'])->name('pdf.student.application.all');
Route::get('/student/application/pending/pdf', [StudentAppController::class, 'pdfStudentApplicationPending'])->name('pdf.student.application.Pending');
Route::get('/student/application/accepting/pdf', [StudentAppController::class, 'pdfStudentApplicationAccepting'])->name('pdf.student.application.Accepting');
Route::get('/student/application/rejecting/pdf', [StudentAppController::class, 'pdfStudentApplicationRejecting'])->name('pdf.student.application.Rejecting');

Route::get('/std/app/new', [StudentAppController::class, 'form'])->name('student.application.form');
Route::post('/std/app/store', [StudentAppController::class, 'store'])->name('submit.application');

Route::get('/std/adm', [AdmissionController::class, 'show'])->name('student.admission');
Route::post('/std/adm/store', [AdmissionController::class, 'store'])->name('student.register');
Route::get('/std/adm/letter', [AdmissionController::class, 'letter'])->name('student.admissionLetters');

Route::get('/std/current', [StudentController::class, 'currentStudent'])->name('student.currentStudent');
Route::get('/current/students/pdf', [StudentController::class, 'pdfCurrentStudent'])->name('pdf.current.student');
Route::post('/std/mark-alumini', [StudentController::class, 'mark_alumni'])->name('mark.as.alumni');
Route::post('/std/mark-current', [StudentController::class, 'mark_current'])->name('mark.as.current');
Route::get('/std/mark-alumini-single/{id}', [StudentController::class, 'mark_alumni_single'])->name('mark.as.alumni.single');
Route::get('/std/mark-current-single/{id}', [StudentController::class, 'mark_current_single'])->name('mark.as.current.single');

Route::get('/std/current-student-grid', [StudentController::class, 'currentStudentGrid'])->name('student.currentStudentGrid');
Route::get('/std/student-alumni', [StudentController::class, 'studentAlumni'])->name('student.studentAlumni');
Route::get('/alumni/student/pdf', [StudentController::class, 'pdfAlumniStudent'])->name('pdf.alumni.student');
Route::get('/std/reports-screens', [StudentController::class, 'reports_screens'])->name('student.reportsScreens');


Route::get('/std/card/custm/{temp_name}', [StudentCardController::class, 'cardCustomize'])->name('student.card-customize');
Route::post('/std/card/custm/store/{temp_name}', [StudentCardController::class, 'cardCustomizeStore'])->name('student.card-customize.store');

Route::get('/std/profile/{id}', [StudentController::class, 'profile'])->name('student.profile');
Route::get('/std/edit/{id}', [StudentController::class, 'edit'])->name('student.edit');
Route::post('/std/update/{id}', [StudentController::class, 'update'])->name('student.update');

Route::get('/std/profile/attendance/{id}/month/{month?}', [StudentController::class, 'stdAttendance'])->name('student.profile.attendance');

Route::get('/std/profile/academic/{id}', [StudentController::class, 'stdAcademic'])->name('student.profile.academic');
Route::get('/std/profile/documents/{id}', [StudentController::class, 'stdDocuments'])->name('student.profile.documents');
Route::get('/std/profile/promote/{id}', [StudentController::class, 'stdPromote'])->name('student.profile.promote');
Route::post('/std/profile/promote/store', [StudentController::class, 'stdPromoteStore'])->name('student.profile.promote.store');
Route::get('/std/promote/class', [StudentController::class, 'promoteClassForm'])->name('student.profile.promote.class');
Route::post('/std/promote-class', [StudentController::class, 'promoteClass'])->name('promotions.bulk');

// fee structure
Route::get('/account/fee-structure', [FeeStructureController::class, 'show'])->name('show.fee.structure');
Route::get('/pdf/student/fee/structure', [FeeStructureController::class, 'pdfStudentFeeStructure'])->name('pdf.student.fee.structure');
Route::post('/account/store-fee-structure', [FeeStructureController::class, 'store'])->name('store.fee.structure');
Route::get('/fee-structure/{classId}/edit', [FeeStructureController::class, 'edit'])->name('fee-structure.edit');
Route::post('/fee-structure/update', [FeeStructureController::class, 'update'])->name('update.fee.structure');

Route::get('/account/fee-management', [FeeMgtController::class, 'show_fee_management'])->name('show.fee.management');
Route::get('/fee-structure/fee/bulk', [FeeMgtController::class, 'fetch_fee_structure_fee_bulk'])->name('fetch-fee-structure-fee-bulk');
Route::get('/fee-structure/promote/bulk', [FeeMgtController::class, 'fetch_fee_structure_promote_bulk'])->name('fetch-fee-structure-promote-bulk');
Route::get('/fee-structure/promote/single', [FeeMgtController::class, 'fetch_fee_structure'])->name('fetch-fee-structure');
Route::get('/fee-structure/fetch-fee-by-student', [FeeMgtController::class, 'fetch_student_fee_assign'])->name('fetch-fee-by-student');
Route::get('/student/assign/fee/edit', [EditStudentAssignFeeController::class, 'index'])->name('student.assign.fee.edit');;
Route::post('/student/assign/fee/update', [EditStudentAssignFeeController::class, 'update'])->name('student.fee.update');
Route::get('/student/assign/fee/pdf', [EditStudentAssignFeeController::class, 'pdfEditStudentAssignFee'])->name('student.assign.fee.pdf');


Route::post('/fee-structure/generate-student-fee', [FeeGenerateController::class, 'generate_student_fee'])->name('generate-fee-structure');

Route::get('/fee/recipt/show', [FeeReciptController::class, 'show'])->name('fee_recipt_form');
Route::post('fee/recipt/search', [FeeReciptController::class, 'search'])->name('fee_recipt_form.search');
Route::post('fee/recipt/store', [FeeReciptController::class, 'store'])->name('fee_recipt_form.store');


Route::get('/std/search/{reg}', [FeeMgtController::class, 'searchStudents'])->name('search.students');

Route::get('/exp', [ExpenseController::class, 'show'])->name('show.expenses');
Route::get('/exp/create', [ExpenseController::class, 'create'])->name('add.expenses');
Route::post('/exp/store', [ExpenseController::class, 'store'])->name('expenses.store');
Route::put('/exp/update/{id}', [ExpenseController::class, 'update'])->name('expenses.update');
Route::get('/exp/delete/{id}', [ExpenseController::class, 'delete'])->name('expenses.delete');

//Expense Category
Route::get('/exp/catg', [ExpenseCatgController::class, 'show'])->name('show.expense.categories');
Route::post('/exp/catg/store', [ExpenseCatgController::class, 'store'])->name('expense.categories.store');
Route::put('/exp/catg/update/{id}', [ExpenseCatgController::class, 'update'])->name('expense.categories.update');
Route::get('/exp/catg/delete/{id}', [ExpenseCatgController::class, 'delete'])->name('expense.categories.delete');

// income 
Route::get('/income', [IncomeController::class, 'show'])->name('show.income');
Route::post('/income/store', [IncomeController::class, 'store'])->name('income.store');
Route::get('/income/pdf', [IncomeController::class, 'pdfIncome'])->name('income.pdf');


//income category
Route::get('/income/catg', [IncomeCatgController::class, 'show'])->name('show.income.catg');
Route::post('/income/catg/store', [IncomeCatgController::class, 'store'])->name('income.catg.store');

//Attendance section
Route::get('/attend', [AttendanceController::class, 'index'])->name('show.attendance');
Route::post('/attend/store', [AttendanceController::class, 'store'])->name('submit.attendance');
Route::get('/attend/{id}', [AttendanceController::class, 'show'])->where('id', '[0-9]+')->name('attendance.show');
Route::get('/attend/report', [AttendanceController::class, 'report'])->name('attendance.report');
Route::get('/staff/attend', [AttendanceController::class, 'staffAttend'])->name('staff.attend.get');
Route::get('/staff/attend/{id}', [AttendanceController::class, 'staffAttendShow'])->where('id', '[0-9]+')->name('staff.attend.show');
Route::post('/staff/attend/store', [AttendanceController::class, 'staffAttendStore'])->name('staff.attend.store');
//settings
Route::get('/sett', [SettingsController::class, 'index'])->name('settings.index');
Route::post('/sett/update', [SettingsController::class, 'update'])->name('settings.update');
Route::get('/sett/role-permissions', [SettingsController::class, 'role_permissions'])->name('settings.role-permissions');
Route::put('/sett/update-role-permissions', [SettingsController::class, 'updateRolePermissions'])->name('settings.update-role-permissions');
Route::post('/sett/create-role', [SettingsController::class, 'store_role'])->name('settings.create-role');
// Exam Controller
Route::get('/exam', [ExamController::class, 'exam'])->name('exam');
Route::post('/exam/store', [ExamController::class, 'store'])->name('exam.store');
Route::get('/exam/edit/{id}', [ExamController::class, 'edit_exam'])->name('exam.edit');
Route::put('/exam/update/{id}', [ExamController::class, 'update_exam'])->name('exam.update');
Route::get('/exam/delete/{id}', [ExamController::class, 'delete_exam'])->name('exam.delete');
//Exam Hall Controller
Route::get('/exam/hall', [ExamController::class, 'exam_halls'])->name('exam.hall');
Route::post('/exam/hall/store', [ExamController::class, 'store_exam_hall'])->name('exam.hall.store');
Route::get('/exam/hall/edit/{id}', [ExamController::class, 'edit_exam_hall'])->name('exam.hall.edit');
Route::put('/exam/hall/update/{id}', [ExamController::class, 'update_exam_hall'])->name('exam.hall.update');
Route::get('/exam/hall/delete/{id}', [ExamController::class, 'delete_exam_hall'])->name('exam.hall.delete');

//Exam Time Table
Route::get('/exam/timetable', [ExamController::class, 'exam_timetable'])->name('exam.timetable');
Route::get('/exam/timetable/new', [ExamController::class, 'exam_create_timetable'])->name('exam.timetable.create');
Route::post('/exam/timetable/store', [ExamController::class, 'store_exam_timetable'])->name('exam.timetable.store');
Route::get('/exam-timetable-details/{examId}', [ExamController::class, 'getExamTimetableDetails']);
Route::get('/exam-timetable-pdf/{examId}', [ExamController::class, 'downloadExamTimetablePdf']);

Route::get('/exam/timetable/edit/{id}', [ExamController::class, 'edit_exam_timetable'])->name('exam.timetable.edit');
Route::put('/exam/timetable/update/{id}', [ExamController::class, 'update_exam_timetable'])->name('exam.timetable.update');
/*Route::get('/exam/timetable/delete/{id}', [ExamController::class, 'delete_exam_timetable'])->name('exam.timetable.delete');
Route::get('/exam/timetable/print/{id}', [ExamController::class, 'print_exam_timetable'])->name('exam.timetable.print');
Route::get('/exam/timetable/print-single/{id}', [ExamController::class, 'print_single_exam_timetable'])->name('exam.timetable.print-single');
 */

//  Dmc Generation
Route::get('/dmc', [App\Http\Controllers\DmcController::class, 'index'])->name('dmc.index');
Route::get('/dmc/subject/', [App\Http\Controllers\DmcController::class, 'getSubject'])->name('dmc.subject');
Route::post('/dmc/students/', [App\Http\Controllers\DmcController::class, 'getStudents'])->name('dmc.stuents');
Route::post('/dmc/store', [App\Http\Controllers\DmcController::class, 'store'])->name('dmc.store');

/* Route::get('/dmc/show/{id}', [App\Http\Controllers\DmcController::class, 'show'])->name('dmc.show');
Route::get('/dmc/download/{id}', [App\Http\Controllers\DmcController::class, 'download'])->name('dmc.download');
Route::get('/dmc/print/{id}', [App\Http\Controllers\DmcController::class, 'print'])->name('dmc.print');
Route::get('/dmc/search', [App\Http\Controllers\DmcController::class, 'search'])->name('dmc.search');
Route::get('/dmc/create', [App\Http\Controllers\DmcController::class, 'create'])->name('dmc.create');
Route::post('/dmc/store', [App\Http\Controllers\DmcController::class, 'store'])->name('dmc.store');
Route::get('/dmc/edit/{id}', [App\Http\Controllers\DmcController::class, 'edit'])->name('dmc.edit');
Route::put('/dmc/update/{id}', [App\Http\Controllers\DmcController::class, 'update'])->name('dmc.update');
Route::get('/dmc/delete/{id}', [App\Http\Controllers\DmcController::class, 'delete'])->name('dmc.delete');
Route::get('/dmc/print-single/{id}', [App\Http\Controllers\DmcController::class, 'print_single'])->name('dmc.print-single');*/
Route::get('/dmc/generate', [App\Http\Controllers\DmcController::class, 'generate'])->name('dmc.generate');
Route::post('/dmc/generate_bulk', [App\Http\Controllers\DmcController::class, 'generateDmc'])->name('dmc.bulk_generate');


Route::get('/fee/gen/index', [FeeGenerateController::class, 'index'])->name('fee.gen.index');
Route::get('/fee/generated/report/pdf', [FeeGenerateController::class, 'feeGeneratedReportPdf'])->name('fee.gen.report.pdf');
Route::get('/fee/recipt/index', [FeeReciptController::class, 'index'])->name('fee.recipt.index');
Route::get('/std/dues/index', [StudentDuesController::class, 'index'])->name('std.dues.index');
Route::get('/student/dues/pdf', [StudentDuesController::class, 'pdfStudentDues'])->name('student.dues.pdf');
Route::get('/fee/recipt/report/pdf', [FeeReciptController::class, 'pdfFeeReciptReport'])->name('fee.recipt.report.pdf');



Route::get('/staff/payable/index', [StaffPayableController::class, 'index'])->name('staff.payable.index');
Route::get('/staff/pay/indexR', [PaySalaryController::class, 'indexReport'])->name('staff.pay.indexR');
Route::get('/staff/gen/indexR', [GenSalaryController::class, 'indexReport'])->name('staff.gen.indexR');
Route::get('/pdf/salary/generate/report', [GenSalaryController::class, 'pdfSalaryGenerateReport'])->name('pdf.salary.generate.report');
Route::get('/pdf/staff/payable', [StaffPayableController::class, 'pdfStaffPayable'])->name('pdf.staff.payable');
Route::get('/pdf/staff/salary/pay/report', [PaySalaryController::class, 'pdfStaffSalaryPayReport'])->name('pdf.staff.salary.pay.report');


//Document Management
Route::get('/docs/download/student', [App\Http\Controllers\DocumentController::class, 'downloadStudentView'])->name('doc.download.student');
Route::get('/docs/download/staff', [App\Http\Controllers\DocumentController::class, 'downloadStaffView'])->name('doc.download.staff');
Route::get('/docs/students/{id}/documents', [DocumentController::class, 'showStudentDocuments'])->name('doc.students.documents');

Route::get('/docs/students/{studentId}/exams', [DocumentController::class, 'showStudentExams'])->name('doc.students.exams');
Route::get('/docs/students/{studentId}/exam/dmc/{examId}', [DocumentController::class, 'generateDMC'])->name('docs.students.exam.dmc');




require __DIR__ . '/auth.php';
