<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Teacher Timetable PDF</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; }
        th { background-color: #f2f2f2; text-align: left; }
    </style>
</head>
<body>

<h2 style="text-align:center;">Teacher Timetable</h2>

@foreach ($timetables as $timetable)
    @if ($timetable->teacher_timetables->isEmpty())
        @continue
    @endif

    <h4>{{ $timetable->full_name }}</h4>
    <table>
        <thead>
            <tr>
                <th>Time</th>
                <th>Subject</th>
                <th>Class</th>
                <th>Section</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($timetable->teacher_timetables as $time)
                <tr>
                    <td>{{ $time->start_time }} - {{ $time->end_time }}</td>
                    <td>{{ $time->subjects->name }}</td>
                    <td>{{ $time->classes->name }}</td>
                    <td>{{ $time->sections->name }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endforeach

</body>
</html>
