@extends('schoolLayout.app')
@section('content')
    @include('successError')
    <div class="bg-[#f9fafc] min-h-screen px-8 py-4">
        <!-- Top Section: Tabs & Button -->
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <div class="flex space-x-2 w-[50%]">
                <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                    onclick=" window.location.href = '{{ route('school-sessions') }}'">
                    Sessions
                </button>
                <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                    onclick="window.location.href = '{{ route('sections') }}'">
                    Sections
                </button>
                <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                    onclick="window.location.href = '{{ route('classes') }}'">
                    Classes
                </button>
                <button class="tab-btn px-8 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500"
                    {{-- onclick="window.location.href = '{{ route('subjects') }}'" --}}>
                    Subjects
                </button>
            </div>
            <a href="{{ route('pdf.subject.list') }}" target="_blank"
                class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">
                Subject PDF
            </a>

            <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-md" id="openModal">
                <i class="fa-solid fa-plus"></i>
                <span>Add New Subjects</span>
            </button>
        </div>

        <div class="border p-3 bg-white border-gray-200 rounded-lg my-4">
            <div class="relative bg-white">
                <table class="w-full border-collapse">
                    <thead class="bg-[#f9fafc]">
                        <tr class="text-gray-600">
                            <th class="p-3 text-left text-gray-500 font-medium">Subject Code</th>
                            <th class="p-3 text-left text-gray-500 font-medium">Subject Name</th>
                            <th class="p-3 text-left text-gray-500 font-medium">Total Marks</th>
                            <th class="p-3 text-left text-gray-500 font-medium">Passing Marks</th>
                            <th class="p-3 text-left text-gray-500 font-medium">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white py-3 rounded-lg">
                        @if ($subjects)
                            @foreach ($subjects as $subject)
                                <tr class="border-b">
                                    <td class="p-3 flex items-center">{{ $subject->code }}</td>
                                    <td class="p-3 text-gray-700">{{ $subject->name }}</td>
                                    <td class="p-3 text-gray-700">{{ $subject->total_marks }}</td>
                                    <td class="p-3 text-gray-700">{{ $subject->passing_marks }}</td>
                                    <td class="p-3 flex items-center gap-x-4">
                                        <i class="fa-solid fa-pen-to-square text-blue-500 cursor-pointer"
                                            onclick="openEditModal({
                             id: '{{ $subject->id }}',
                             code: '{{ $subject->code }}',
                             name: '{{ $subject->name }}',
                             total_marks: '{{ $subject->total_marks }}',
                             passing_marks: '{{ $subject->passing_marks }}'
                         })"></i>
                                        {{-- <i class="fa-solid fa-trash text-red-500 cursor-pointer"
                                            onclick="deleteSubject('{{ $subject->id }}')"></i> --}}
                                    </td>
                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add Subject Modal -->
    <div id="modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <div class="bg-white w-full max-w-lg rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Create New Subject</h2>
                <button id="closeModal" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <form action="{{ route('store.subjects') }}" method="POST" class="bg-white px-6 py-3">
                @csrf
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Subject Code <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="code" placeholder="ENG101, SCI202" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Subject Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="name" placeholder="Mathematics, History, Science" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Total Marks <span class="text-red-500">*</span>
                    </label>
                    <input type="number" name="total_marks" placeholder="100" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Passing Marks <span class="text-red-500">*</span>
                    </label>
                    <input type="number" name="passing_marks" placeholder="40" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button type="button" id="closeModalBtn"
                        class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Create Subject
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Edit Subject Modal -->
    <div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <div class="bg-white w-full max-w-lg rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Edit Subject</h2>
                <button onclick="closeEditModal()" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <form id="editSubjectForm" method="POST" class="bg-white px-6 py-3">
                @csrf
                @method('PUT')
                <input type="hidden" id="editSubjectId" name="id">

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Subject Code <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="editSubjectCode" name="code" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Subject Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="editSubjectName" name="name" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Total Marks <span class="text-red-500">*</span>
                    </label>
                    <input type="number" id="editSubjectTotalMarks" name="total_marks" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Passing Marks <span class="text-red-500">*</span>
                    </label>
                    <input type="number" id="editSubjectPassingMarks" name="passing_marks" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button type="button" onclick="closeEditModal()"
                        class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Update Subject
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Add Subject Modal functionality
        const modal = document.getElementById("modal");
        const openModalBtn = document.getElementById("openModal");
        const closeModalBtns = [
            document.getElementById("closeModal"),
            document.getElementById("closeModalBtn"),
        ];

        openModalBtn.addEventListener("click", () => {
            modal.classList.remove("hidden");
        });

        closeModalBtns.forEach((btn) => {
            btn.addEventListener("click", () => {
                modal.classList.add("hidden");
            });
        });

        // Edit Subject Modal functionality
        function openEditModal(subject) {
            document.getElementById('editSubjectId').value = subject.id;
            document.getElementById('editSubjectCode').value = subject.code;
            document.getElementById('editSubjectName').value = subject.name;
            document.getElementById('editSubjectTotalMarks').value = subject.total_marks;
            document.getElementById('editSubjectPassingMarks').value = subject.passing_marks;
            document.getElementById('editSubjectForm').action = `/subject/update/${subject.id}`;
            document.getElementById('editModal').classList.remove('hidden');
        }

        function closeEditModal() {
            document.getElementById('editModal').classList.add('hidden');
        }

        /*   function deleteSubject(subjectId) {
               if (confirm('Are you sure you want to delete this subject?')) {
                   window.location.href = `/subjects/delete/${subjectId}`;
               }
           }*/

        // Close modal when clicking outside
        window.onclick = function(event) {
            if (event.target === modal) {
                modal.classList.add('hidden');
            }
            if (event.target === document.getElementById('editModal')) {
                closeEditModal();
            }
        }
    </script>
@endsection
