@extends('schoolLayout.app')

@section('content')
    <div class="px-6 py-6 bg-[#f9fafc] min-h-screen">
        @include('student.stdProfilePartials')

        <!-- Tabs Section -->
        <div class="flex justify-between mt-4 w-full px-4 bg-white pt-2 border-b border-gray-200 items-center">
            <div class="flex space-x-4 bg-white">
                <button class="tab-btn px-4 pb-4 bg-white pt-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Admission & Personal Details
                </button>
                <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold"
                    onclick="window.location.href='{{ route('student.profile.academic', $student->id) }}'">
                    Academic Information
                </button>
                <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold"
                    onclick="window.location.href='{{ route('student.profile.attendance', $student->id) }}'">
                    Attendance Records
                </button>
                <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold"
                    onclick="location.href='{{ route('student.profile.documents', $student->id) }}'">
                    Documents & Certificates
                </button>
                <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold"
                    onclick="location.href='{{ route('student.profile.promote', $student->id) }}'">
                    Promote Student
                </button>
            </div>
        </div>

        <!-- Information Cards -->
        <div class="grid grid-cols-1 mt-4 rounded-lg bg-[#f9fafc] md:grid-cols-2 gap-6 w-full">
            <!-- Admission Information Card -->
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-lg font-semibold mb-4">Admission Information</h2>
                <div class="space-y-2">
                    <div class="flex justify-between">
                        <span class="text-gray-500">Admission Number</span>
                        <span class="text-black font-semibold">{{ $student->latestAdmission->admission_no ?? 'N/A' }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Admission Date</span>
                        <span class="text-black font-semibold">
                            {{ \Carbon\Carbon::parse($student->latestAdmission->admission_date ?? 'N/A')->format('d F, Y') }}
                        </span>
                    </div>
                    @php
                        $admission = $student->admissions->first();
                    @endphp
                    <div class="flex justify-between">
                        <span class="text-gray-500">Class & Section</span>
                        <span class="text-black font-semibold">{{ $admission->class->name ?? 'N/A' }}   -
                            Section
                            {{ $admission->section->name ?? 'N/A' }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Student Type</span>
                        <span class="text-black font-semibold"> {{ $student->latestAdmission->admission_status ?? 'N/A' }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Personal Information Card -->
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-lg font-semibold mb-4">Personal Information</h2>
                <div class="space-y-2">
                    <div class="flex justify-between">
                        <span class="text-gray-500">Date of Birth</span>
                        <span
                            class="text-black font-semibold">{{ \Carbon\Carbon::parse($student->date_of_birth ?? 'N/A')->format('d F, Y') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Gender</span>
                        <span class="text-black font-semibold">{{ $student->gender ?? 'N/A' }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Nationality</span>
                        <span class="text-black font-semibold">Pakistani</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Religion</span>
                        <span class="text-black font-semibold">{{ $student->religion ?? 'N/A' }}</span>
                    </div>
                </div>
            </div>

            <!-- Guardian & Emergency Contact Card -->
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-lg font-semibold mb-4">
                    Guardian & Emergency Contact
                </h2>
                <div class="space-y-2">
                    <div class="flex justify-between">
                        <span class="text-gray-500">Guardian Name</span>
                        <span class="text-black font-semibold">{{ $student->guardian->guardian_name ?? 'N/A' }}
                            ({{ $student->guardian->relation_with_student ?? 'N/A' }})</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Guardian Contact</span>
                        <span class="text-black font-semibold">{{ $student->guardian->guardian_contact ?? 'N/A' }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Emergency Contact</span>
                        <span class="text-black font-semibold">{{ $student->emergencyContact->contact_name ?? 'N/A' }}
                            ({{ $student->emergencyContact->relationship ?? 'N/A' }}) -
                            {{ $student->emergencyContact->contact_number ?? 'N/A' }}</span>
                    </div>
                </div>
            </div>

            <!-- Address Details Card -->
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-lg font-semibold mb-4">Address Details</h2>
                <div class="space-y-2">
                    <div class="flex justify-between">
                        <span class="text-gray-500">Current Address</span>
                        <span class="text-black font-semibold">{{ $student->current_address ?? 'N/A' }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Permanent Address</span>
                        <span class="text-black font-semibold">{{ $student->current_address ?? 'N/A' }} </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
