@extends('schoolLayout.app')
@section('content')
    <style>
        /* Increase height of the Select2 container */
        .custom-select2+.select2-container .select2-selection--single {
            height: 38px !important;
            display: flex;
            align-items: center;
            border-radius: 0.375rem;
            /* Tailwind's rounded */
            border: 1px solid #d1d5db;
            /* Tailwind gray-300 */
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        /* Optional: increase font size */
        .custom-select2+.select2-container .select2-selection__rendered {
            font-size: 16px;
            line-height: 48px;
        }
    </style>
    <!-- Header Section -->
    <div class="flex justify-between items-center">
        <div class="flex justify-between items-center">
            <!-- Tabs -->
            @include('stdFeeMgt.partialhead')
        </div>

    </div>
    <div class="flex  w-full bg-white">
        <button
            class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
            Student Dues Report
            <span class="bg-gray-200 px-4 py-1 text-gray-700 text-sm rounded-2xl"></span>
        </button>
        {{--  <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
            Total Credit
            <span class="bg-gray-200 px-4 py-1 text-gray-700 text-sm rounded-2xl"></span>
        </button>
        <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
            Total Amount
            <span class="bg-gray-200 px-4 py-1 text-red-700 text-sm rounded-2xl"></span>
        </button>
        <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
            Other
            <span class="bg-gray-200 px-4 py-1 text-red-700 text-sm rounded-2xl"></span>
        </button> --}}
    </div>
    <div class="flex items-center mt-4 space-x-4">

        <select id="student-search" name="student-search" class="border p-2 rounded-lg  select2 custom-select2">
            <option value="">Select Student</option>
            @foreach ($stdList as $s)
                <option value="{{ $s->head_code }}">
                    {{ $s->student_name }} - {{ $s->reg_no }}
                </option>
            @endforeach
        </select>
        <select id="class-filter" class="border p-2 rounded-lg select2 custom-select2">
            <option value="">Select Class</option>
            @foreach ($classes as $class)
                <option value="{{ $class->id }}">{{ $class->name }}</option>
            @endforeach
        </select>

        <a href="{{ route('student.dues.pdf') }}" target="_blank" id="pdf-download-btn"
            class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
            PDF
        </a>



    </div>
    <!-- Applications Table -->
    <div class="bg-white py-3 rounded-lg shadow mt-6 relative">
        <!-- 🔁 Container for results -->
        <div id="student-table" class="bg-white py-3 rounded-lg shadow mt-6 relative">
            @include('student.partialDuesStd', [
                'students' => $students,
                'totalDebit' => $totalDebit,
                'totalCredit' => $totalCredit,
            ])
        </div>
    </div>
    <div class="flex justify-between items-center px-4 pt-4 border-t border-gray-200 mt-8">
        <div class="flex items-center text-sm text-gray-500">
            Showing {{ $students->firstItem() }} to {{ $students->lastItem() }} of {{ $students->total() }} results

            <form method="GET" class="ml-3">
                <select name="entries" onchange="this.form.submit()"
                    class="border rounded-lg px-1 py-1 text-sm focus:outline-none focus:ring-2 focus:ring-blue-400">
                    <option value="40" {{ request('entries') == 40 ? 'selected' : '' }}>40</option>
                    <option value="80" {{ request('entries') == 80 ? 'selected' : '' }}>80</option>
                    <option value="120" {{ request('entries') == 120 ? 'selected' : '' }}>120</option>
                </select>
            </form>
        </div>

        <div class="mt-2">
            {{ $students->appends(request()->query())->onEachSide(1)->links('pagination::tailwind') }}
        </div>

    </div>
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                width: '100%' // Ensure full width
            });
        });
        // Focus on the search field when the Select2 dropdown opens
        $(document).on('select2:open', function() {
            const searchField = $('.select2-search__field');
            if (searchField.length) {
                searchField[0].focus();
            }
        });

        $(document).on('click', '.pagination a', function(event) {
            event.preventDefault();
            let url = $(this).attr('href');

            $.ajax({
                url: url,
                type: "GET",
                success: function(data) {
                    $('#student-table').html(data);
                }
            });
        });
    </script>

    <script>
        $('#student-search').on('change', function() {
            let selectedStudent = $(this).val(); // Get the selected student value

            // Only trigger the AJAX call if a valid student is selected
            if (selectedStudent) {
                $.ajax({
                    url: "{{ route('std.dues.index') }}",
                    type: "GET",
                    data: {
                        search: selectedStudent // Send the selected student value in the AJAX request
                    },
                    success: function(data) {
                        $('#student-table').html(data); // Update the student table with the new data
                    }
                });
            }
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#student-search, #class-filter').on('change', function() {
                let studentId = $('#student-search').val();
                let classId = $('#class-filter').val();
                let pdfUrl = "{{ route('student.dues.pdf') }}?";

                if (studentId) pdfUrl += 'search=' + encodeURIComponent(studentId) + '&';
                if (classId) pdfUrl += 'class_id=' + encodeURIComponent(classId);

                $('#pdf-download-btn').attr('href', pdfUrl);
            });

        });
    </script>
@endsection
