@extends('schoolLayout.app')
@section('content')
    <style>
        .show_card {
            width: calc(100% - 16rem);
            margin-left: 16rem;
            /* border: 1px solid red; */
        }
    </style>
    <div class="bg-white p-6 rounded-xl">
        <!-- Header Section -->
        <div class="flex justify-between items-center">
            <div class="flex flex-col">
                <h1 class="text-2xl font-bold text-gray-800">Student Documents</h1>
            </div>
        </div>

        <div class="flex justify-between border-t border-b border-gray-200 my-4 w-full bg-white">
            <div class="flex">
                <button
                    class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Student ID Cards
                </button>
                {{-- <button
            class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600"
            onclick="window.location.href='{{ route('student.admissionLetters') }}'"
          >
            Admission Letters
          </button>
          <button
            class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600"
          >
            Certificates
          </button> --}}
            </div>
            {{-- <button
          class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-lg"
          onclick="customizeCard()"
        >
          <span>Costomize</span>
        </button> --}}
        </div>

        <div class="grid grid-cols-3 gap-x-4">
            <!-- Parent Div for First Card -->
            <div class="border px-1 flex justify-center items-center rounded-lg">
                <!-- First Card -->
                <div class="w-[24rem] bg-white shadow-lg rounded-lg border relative overflow-hidden self-center">
                    <div class="w-[24rem] min-h-[12rem] bg-white shadow-lg rounded-lg border p-4 relative overflow-hidden">
                        <img src="{{ asset('assets/elipse-bg.png') }}" alt="card-bg"
                            class="absolute -top-8 -right-[120px] w-[18rem] h-[18rem] z-[1]" />
                        <div class="flex">
                            <div class="w-2/3 relative z-50">
                                <div class="flex gap-x-3 items-center">
                                    <div class="bg-[#ebeccd] rounded-full p-1.5">
                                        <img src="{{ $logo }}" alt="" class="w-3" />
                                    </div>
                                    <div>
                                        <h2 class="text-md font-bold uppercase text-black">
                                            {{$schoolName}}
                                        </h2>
                                        <p class="text-[#6B7280] -mt-1 font-medium text-xs">
                                            Excellence in Education
                                        </p>
                                    </div>
                                </div>

                                <div class="mt-3 space-y-2 relative z-50 text-xs">
                                    <p class="text-black font-semibold flex">
                                        <span class="text-gray-500 w-24">Student Name:</span> John
                                        Smith
                                    </p>
                                    <p class="text-black font-semibold flex">
                                        <span class="text-gray-500 w-24">Father's Name:</span>
                                        Michael Smith
                                    </p>
                                    <p class="text-black font-semibold flex">
                                        <span class="text-gray-500 w-24">Class:</span> Grade 10
                                    </p>
                                    <p class="text-black font-semibold flex">
                                        <span class="text-gray-500 w-24">Section:</span> A
                                    </p>
                                    <p class="text-black font-semibold flex">
                                        <span class="text-gray-500 w-24">Roll Number:</span>
                                        2024-0123
                                    </p>
                                    <p class="text-black font-semibold flex">
                                        <span class="text-gray-500 w-[8rem]">Address:</span> 123
                                        Education Street, Academic City
                                    </p>
                                </div>
                            </div>

                            <!-- Right Section: Profile Image & QR Code -->
                            <div class="w-1/3 relative z-50 flex flex-col items-center justify-center gap-y-1">
                                <!-- Profile Image -->
                                <div class="w-24 h-24 border-3 mt-6 border-blue-500 rounded-full overflow-hidden">
                                    <img src="{{ asset('assets/student-card.png') }}" alt="Student"
                                        class="w-full h-full" />
                                </div>

                                
                            </div>
                        </div>

                        <div
                            class="w-full mt-3 relative z-50 h-[3px] rounded-full bg-gradient-to-r from-[#52656B] via-[#1B9AF5] to-[#FACC15]">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Parent Div for Second Card -->
            <div class="border px-2 border-gray-300 flex justify-center items-center rounded-lg">
                <!-- Second Card -->
                <div class="w-[24rem] h-[15rem]  bg-[#D4EDFF] shadow-lg rounded-lg border p-3 overflow-hidden relative">
                   

                    <!-- Header Section -->
                    <div class="flex gap-x-3 items-center">
                        <div class="bg-[#ccdece] rounded-full p-1.5">
                            <img src="{{ $logo }}" alt="School Logo" class="w-3" />
                        </div>
                        <div>
                            <h2 class="text-md font-bold uppercase text-black">
                                {{$schoolName}}
                            </h2>
                            <p class="text-[#6B7280] -mt-1 font-medium text-xs">
                                Excellence in Education
                            </p>
                        </div>
                    </div>

                    <div class="flex gap-x-3 mt-4">
                        <!-- Profile Image -->
                        <div class="w-1/3 flex flex-col items-center justify-center gap-y-1">
                            <div class="w-20 h-20 border-3 border-blue-500 rounded-full overflow-hidden">
                                <img src="{{ asset('assets/student-card.png') }}" alt="Student" class="w-full h-full" />
                            </div>
                            <p class="text-[#0197FF] text-md font-semibold">
                                Sarah Johnson
                            </p>
                        </div>

                        <!-- Student Details -->
                        <div class="w-2/3">
                            <div class="mt-5 space-y-1 text-xs">
                                <p class="text-black font-semibold flex">
                                    <span class="text-gray-500 w-24">Father's Name:</span>
                                    Michael Smith
                                </p>
                                <p class="text-black font-semibold flex">
                                    <span class="text-gray-500 w-24">Class:</span> Grade 10
                                </p>
                                <p class="text-black font-semibold flex">
                                    <span class="text-gray-500 w-24">Section:</span> A
                                </p>
                                <p class="text-black font-semibold flex">
                                    <span class="text-gray-500 w-24">Roll Number:</span>
                                    2024-0123
                                </p>
                                <p class="text-black font-semibold flex">
                                    <span class="text-gray-500 w-[9rem]">Address:</span> 123
                                    Education Street, Academic City
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Gradient Line -->
                    <div
                        class="w-full mt-5 h-[3px] rounded-full bg-gradient-to-r from-[#52656B] via-[#1B9AF5] to-[#FACC15]">
                    </div>
                </div>
            </div>

            <!-- Parent Div for Third Card -->
            <div class="border border-gray-300 rounded-lg">
                <!-- Third Card (Tallest One) -->
                <div class="p-4 relative overflow-hidden">
                    <div class="rounded-lg p-4 scale-75">
                        <div class="max-w-sm h-[28rem] bg-white shadow-lg rounded-lg border p-4 relative overflow-hidden">
                            <img src="{{ asset('assets/right-traingle-card.png') }}" alt="card-bg"
                                class="absolute -top-64 -right-28 -rotate-[8deg] w-[37rem] h-[37rem] z-[1]" />
                            <img src="{{ asset('assets/left-traingle-card.png') }}" alt="card-bg"
                                class="absolute -top-[156px] -left-16 rotate-[18deg] w-[20rem] h-[20rem] z-10" />
                            <div class="flex justify-between z-50 relative items-start">
                                <!-- School Name -->
                                <div class="flex gap-x-4 mt-2 items-center">
                                    <div class="bg-[#ccdece] rounded-full p-1.5">
                                        <img src="{{ $logo }}" alt="School Logo" class="w-10" />
                                    </div>
                                    <div>
                                        <h2 class="text-md font-bold uppercase text-black">
                                            {{$schoolName}}
                                        </h2>
                                        <p class="text-[#6B7280] -mt-1 font-medium text-xs">
                                            Excellence in Education
                                        </p>
                                    </div>
                                </div>

                                <!-- Profile Image -->
                                <div class="w-20 h-20 absolute top-1 -right-2 z-50">
                                    <img src="{{ asset('assets/student-card.png') }}" alt="Profile"
                                        class="w-full h-full border-4 border-[#199af4] rounded-full border" />
                                </div>
                            </div>

                            <!-- Student Details -->
                            <div class="mt-7 px-3 z-50 relative">
                                <h3 class="text-xl font-bold text-gray-800">Sarah Johnson</h3>
                                <p class="text-[#1B9AF5] text-sm font-semibold">
                                    Student ID: 2024-0127
                                </p>
                            </div>

                            <div class="mt-4 text-sm grid grid-cols-2 border-b border-gray-200 pb-2 gap-y-1 px-3">
                                <p class="flex flex-col text-md text-black font-semibold">
                                    <span class="text-[#6B7280] text-sm">Class</span> Grade 10
                                </p>
                                <p class="flex flex-col text-md text-black font-semibold">
                                    <span class="text-[#6B7280] text-sm">Section</span> A
                                </p>
                                <p class="flex flex-col text-md text-black font-semibold">
                                    <span class="text-[#6B7280] text-sm">Date of Birth</span>
                                    15 March 2008
                                </p>
                                <p class="flex flex-col text-md text-black font-semibold">
                                    <span class="text-[#6B7280] text-sm">Roll Number</span>
                                    127
                                </p>
                                <p class="flex flex-col text-md text-black font-semibold">
                                    <span class="text-[#6B7280] text-sm">Blood Group</span> B+
                                </p>
                                <p class="flex flex-col text-md text-black font-semibold">
                                    <span class="text-[#6B7280] text-sm">Valid Through</span>
                                    2024-2025
                                </p>
                            </div>

                            <div class="mt-1 text-sm px-3">
                                <p class="flex flex-col text-md text-black font-semibold mb-2">
                                    <span class="text-[#6B7280] text-sm">Address</span> 123
                                    Education Street, Academic City
                                </p>
                                <p class="flex flex-col text-md text-black font-semibold">
                                    <span class="text-[#6B7280] text-sm">Emergency Contact</span>
                                    +1 (555) 123-4567
                                </p>
                            </div>

                           

                            <!-- Principal's Signature -->
                            <div class="mt-3 px-3">
                                <img src="{{ asset('assets/card-signature.png') }}" alt="signature" class="w-10" />
                                <p class="text-gray-600 text-xs">Principal's Signature</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-white  mt-10 rounded-xl">
        <!-- Search and Filters -->
        <div class="flex flex-col md:flex-row justify-between items-center gap-4 bg-white p-4">
            <!-- Search Input -->
            <div class="relative w-full md:w-1/3" style="opacity:0">
                <div class="border border-gray-300 rounded-md bg-white flex items-center px-4 py-2">
                    <img src="{{ asset('assets/search.png') }}" alt="Search" class="w-5 h-5 text-gray-500" />
                    <input type="text" placeholder="Search by name, admission ID, or grade..."
                        class="w-full pl-3 text-sm border-none focus:outline-none" />
                </div>
            </div>

            <!-- Filters & Print Button -->
            <form action="{{ route('student.reportsScreens') }}" method="GET">
                <div class="flex flex-wrap gap-3 w-full md:w-auto items-center">
                <select 
                    class="p-2 border border-gray-300 rounded-md text-sm focus:ring-2 focus:ring-blue-400"
                    id="select_template"
                    name="template">
                    <option value="0" {{ request('template') == 0 ? 'selected' : '' }}>Template First</option>
                    <option value="1" {{ request('template') == 1 ? 'selected' : '' }}>Template Second</option>
                    <option value="2" {{ request('template') == 2 ? 'selected' : '' }}>Template Third</option>
                </select>
                <select class="p-2 border border-gray-300 rounded-md text-sm focus:ring-2 focus:ring-blue-400" name="class">
                    <option value="">All classes</option>
                    @if ($classes)
                        @foreach ($classes as $class)
                            <option value="{{ $class->id }}" {{ request('class') == $class->id ? 'selected' : '' }}>
                                {{ $class->name }}
                            </option>
                        @endforeach
                    @endif
                </select>
                <select class="p-2 border border-gray-300 rounded-md text-sm focus:ring-2 focus:ring-blue-400" name="section">
                    <option value="">All Sections</option>
                    @if ($sections)
                        @foreach ($sections as $section)
                            <option value="{{ $section->id }}" {{ request('section') == $section->id ? 'selected' : '' }}>
                                {{ $section->name }}
                            </option>
                        @endforeach
                    @endif
                </select>
                    <button class="py-2 px-3 border border-gray-300 rounded-md flex items-center gap-2 bg-blue-600 hover:bg-white text-white hover:text-black transition"> Filter</button>
                    <!-- Print Button -->
                    <button type="button" class="p-2 border border-gray-200 rounded-md flex items-center gap-2 hover:bg-blue-600 transition">
                        <i class="fa-solid fa-print"></i>
                        Print Selected
                    </button>
                </div>
            </form>
        </div>
    </div>
    </div>
    {{-- <div class="flex flex-wrap justify-center gap-x-2 mt-4"> --}}
    {{-- <!-- First Card: Student ID Card -->
        <div class="border border-gray-200 rounded-lg p-4">
          <div
            class="flex shadow-lg rounded-lg p-4 w-[350px] h-[200px] border border-gray-200 text-white"
            style="
              background: linear-gradient(
                135deg,
                #2563eb -1%,
                #1d4ed8 50%,
                #1e40af 100%
              );
            "
          >
            <img
              src="{{ asset('assets/fourth.png') }}"
              alt="Student Pic"
              class="w-20 h-20 rounded-md"
            />
            <div class="flex-1 px-4 text-sm">
              <h2 class="text-lg font-bold">STUDENT ID CARD</h2>
              <p class="opacity-90 my-2">Modern Design</p>

              <div class="text-md">
                <p class="flex gap-x-2">Name: <span>John Smith</span></p>
                <p class="flex gap-x-2">Roll No: <span>ST2024001</span></p>
                <p class="flex gap-x-2">Grade: <span>10, Class: B</span></p>
              </div>
            </div>

            <img src="{{ asset('assets/logo.png') }}" alt="School Logo" class="w-12 h-12" />
          </div>
        </div>

        <!-- Second Card: Central High School -->
        <div class="border border-gray-200 rounded-lg p-4">
            <div
              class="flex shadow-lg rounded-lg p-4 w-[350px] h-[200px] border border-gray-200 text-white"
              style="
                background: linear-gradient(
                  135deg,
                  #2563eb -1%,
                  #1d4ed8 50%,
                  #1e40af 100%
                );
              "
            >
              <img
                src="{{ asset('assets/fourth.png') }}"
                alt="Student Pic"
                class="w-20 h-20 rounded-md"
              />
              <div class="flex-1 px-4 text-sm">
                <h2 class="text-lg font-bold">STUDENT ID CARD</h2>
                <p class="opacity-90 my-2">Modern Design</p>
  
                <div class="text-md">
                  <p class="flex gap-x-2">Name: <span>John Smith</span></p>
                  <p class="flex gap-x-2">Roll No: <span>ST2024001</span></p>
                  <p class="flex gap-x-2">Grade: <span>10, Class: B</span></p>
                </div>
              </div>
  
              <img src="{{ asset('assets/logo.png') }}" alt="School Logo" class="w-12 h-12" />
            </div>
          </div>

        <!-- Third Card: Student Identification -->
        <div class="border border-gray-200 rounded-lg p-4">
            <div
              class="flex shadow-lg rounded-lg p-4 w-[350px] h-[200px] border border-gray-200 text-white"
              style="
                background: linear-gradient(
                  135deg,
                  #2563eb -1%,
                  #1d4ed8 50%,
                  #1e40af 100%
                );
              "
            >
              <img
                src="{{ asset('assets/fifth.png') }}"
                alt="Student Pic"
                class="w-20 h-20 rounded-md"
              />
              <div class="flex-1 px-4 text-sm">
                <h2 class="text-lg font-bold">STUDENT ID CARD</h2>
                <p class="opacity-90 my-2">Modern Design</p>
  
                <div class="text-md">
                  <p class="flex gap-x-2">Name: <span>John Smith</span></p>
                  <p class="flex gap-x-2">Roll No: <span>ST2024001</span></p>
                  <p class="flex gap-x-2">Grade: <span>10, Class: B</span></p>
                </div>
              </div>
  
              <img src="{{ asset('assets/logo.png') }}" alt="School Logo" class="w-12 h-12" />
            </div>
        </div> --}}
    {{-- </div> --}}


    <!-- First Card: Student ID Card -->
    <div  class="show_card flex flex-wrap justify-center gap-x-2 mt-4 hidden border">
        @if ($students)
            @foreach ($students as $student)
                <div onclick="printCard('printable-card-{{ $student->id }}')" class="border px-1 flex justify-center items-center rounded-lg">
                    <!-- First Card -->
                    <div id="printable-card-{{ $student->id }}"  class="w-[24rem] bg-white shadow-lg rounded-lg border relative overflow-hidden self-center">
                        <div
                            class="w-[24rem] min-h-[12rem] bg-white shadow-lg rounded-lg border p-4 relative overflow-hidden">
                            <img src="{{ asset('assets/elipse-bg.png') }}" alt="card-bg"
                                class="absolute -top-8 -right-[120px] w-[18rem] h-[18rem] z-[1]" />
                            <div class="flex">
                                <div class="w-2/3 relative z-50 ">
                                    <div class="flex gap-x-3 items-center">
                                        <div class="bg-[#ebeccd] rounded-full p-1.5">
                                            <img src="{{ $logo }}" alt=""
                                                class="w-3" />
                                        </div>
                                        <div>
                                            <h2 class="text-md font-bold uppercase text-black">
                                                {{$schoolName}}
                                            </h2>
                                            <p class="text-[#6B7280] -mt-1 font-medium text-xs">
                                                Excellence in Education
                                            </p>
                                        </div>
                                    </div>

                                    <div class="mt-3 space-y-2 relative z-50 text-xs">
                                        <p class="text-black font-semibold flex">
                                            <span class="text-gray-500 w-24">Student Name:</span>
                                            {{ $student->student_name }}
                                        </p>
                                        <p class="text-black font-semibold flex">
                                            <span class="text-gray-500 w-24">Father's Name:</span>
                                            {{ $student->father_name }}
                                        </p>
                                        <p class="text-black font-semibold flex">
                                            <span class="text-gray-500 w-24">Class:</span>
                                            {{ optional($student->classes->first())->name ?? 'No Class Assigned' }}
                                        </p>
                                        <p class="text-black font-semibold flex">
                                            <span class="text-gray-500 w-24">Section:</span>
                                            {{ optional($student->sections->first())->name ?? 'No Class Assigned' }}
                                        </p>
                                        <p class="text-black font-semibold flex">
                                            <span class="text-gray-500 w-24">Roll Number:</span>
                                            {{ $student->latestAdmission->session_year }}
                                        </p>
                                        <p class="text-black font-semibold flex">
                                            <span
                                                class="text-gray-500 w-24 ">Address:</span>{{ Str::limit(ltrim($student->current_address), 20) }}
                                        </p>
                                    </div>
                                </div>

                                <!-- Right Section: Profile Image & QR Code -->
                                <div class="w-1/3 relative z-50 flex flex-col items-center justify-center gap-y-1">
                                    <!-- Profile Image -->
                                    <div class="w-24 h-24 border-3 mt-6 border-blue-500 rounded-full overflow-hidden">
                                        <img src="{{ optional($student->documents)->photo 
    ? asset('storage/' . $student->documents->photo) 
    : asset('assets/' . ($student->gender === 'Male' ? 'student.png' : ($student->gender === 'Female' ? 'student-female.png' : 'default-image.jpg'))) }}"    alt="Student" class="w-full h-full" />

                                    </div>

                                    
                                </div>
                            </div>

                            <div
                                class="w-full mt-3 relative z-50 h-[3px] rounded-full bg-gradient-to-r from-[#52656B] via-[#1B9AF5] to-[#FACC15]">
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        @endif
    </div>

    <!-- Second Card: Central High School -->
    <div class="show_card flex flex-wrap justify-center gap-x-2 mt-4 hidden">
        @if ($students)
            @foreach ($students as $student)
                <!-- Parent Div for Second Card -->
                <div   class="border px-2 border-gray-300 flex justify-center items-center rounded-lg">
                    <!-- Second Card -->
                    <div id="printable-card-{{ $student->id }}"
                        class="w-[24rem] h-[15rem]  bg-[#D4EDFF] shadow-lg rounded-lg border p-3 overflow-hidden relative">
                        
                        <!-- Header Section -->
                        <div class="flex gap-x-3 items-center">
                            <div class="bg-[#ccdece] rounded-full p-1.5">
                                <img src="{{ $logo }}" alt="School Logo" class="w-3" />
                            </div>
                            <div>
                                <h2 class="text-md font-bold uppercase text-black">
                                    {{$schoolName}}
                                </h2>
                                <p class="text-[#6B7280] -mt-1 font-medium text-xs">
                                    Excellence in Education
                                </p>
                            </div>
                        </div>

                        <div class="flex gap-x-3 mt-4">
                            <!-- Profile Image -->
                            <div class="w-1/3 flex flex-col items-center justify-center gap-y-1">
                                <div class="w-20 h-20 border-3 border-blue-500 rounded-full overflow-hidden">
                                    <img src="{{ optional($student->documents)->photo 
    ? asset('storage/' . $student->documents->photo) 
    : asset('assets/' . ($student->gender === 'Male' ? 'student.png' : ($student->gender === 'Female' ? 'student-female.png' : 'default-image.jpg'))) }}"                 alt="Student" class="w-full h-full" />

                                </div>
                                <p class="text-[#0197FF] text-md font-semibold">
                                    {{ $student->student_name }}
                                </p>
                            </div>

                            <!-- Student Details -->
                            <div class="w-2/3">
                                <div class="mt-5 space-y-1 text-xs">
                                    <p class="text-black font-semibold flex">
                                        <span class="text-gray-500 w-24">Father's Name:</span>
                                        {{ $student->father_name }}
                                    </p>
                                    <p class="text-black font-semibold flex">
                                        <span class="text-gray-500 w-24">Class:</span>
                                        {{ optional($student->classes->first())->name }}
                                    </p>
                                    <p class="text-black font-semibold flex">
                                        <span class="text-gray-500 w-24">Section:</span>
                                        {{ optional($student->sections->first())->name }}
                                    </p>
                                    <p class="text-black font-semibold flex">
                                        <span class="text-gray-500 w-24">Roll Number:</span>
                                        {{ $student->reg_no }}
                                    </p>
                                    <p class="text-black font-semibold flex">
                                        <span class="text-gray-500 w-24">Address:</span>{{ Str::limit(ltrim($student->current_address), 20) }}
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Gradient Line -->
                        <div
                            class="w-full mt-5 h-[3px] rounded-full bg-gradient-to-r from-[#52656B] via-[#1B9AF5] to-[#FACC15]">
                        </div>
                    </div>
                </div>
            @endforeach
        @endif
    </div>

    <!-- Third Card: Student Identification -->
    <div class="show_card flex flex-wrap justify-center  mt-4 hidden">
        @if ($students)
            @foreach ($students as $student)
                <!-- Parent Div for Third Card -->
                <div   class="border border-gray-300 rounded-lg " style="width:30%;">
                    <!-- Third Card (Tallest One) -->
                    <div id="printable-card-{{ $student->id }}" class=" relative overflow-hidden">
                        <div class="rounded-lg">
                            <div
                                class="max-w-sm h-[28rem] bg-white shadow-lg rounded-lg border p-4 relative overflow-hidden">
                                <img src="{{ asset('assets/right-traingle-card.png') }}" alt="card-bg"
                                    class="absolute -top-64 -right-28 -rotate-[8deg] w-[37rem] h-[37rem] z-[1]" />
                                <img src="{{ asset('assets/left-traingle-card.png') }}" alt="card-bg"
                                    class="absolute -top-[156px] -left-16 rotate-[18deg] w-[20rem] h-[20rem] z-10" />
                                <div class="flex justify-between z-50 relative items-start">
                                    <!-- School Name -->
                                    <div class="flex gap-x-4 mt-2 items-center">
                                        <img src="{{ $logo }}" alt=""
                                            class="bg-yellow-200 w-10" />
                                        <div>
                                            <h2 class="text-sm font-bold text-black">
                                                {{$schoolName}}
                                            </h2>
                                            <p class="text-[#6B7280] font-semibold text-xs">
                                                Excellence in Education
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Profile Image -->
                                    <div class="w-20 h-20 absolute top-1 -right-2 z-50">
                                        <img src="{{ optional($student->documents)->photo 
    ? asset('storage/' . $student->documents->photo) 
    : asset('assets/' . ($student->gender === 'Male' ? 'student.png' : ($student->gender === 'Female' ? 'student-female.png' : 'default-image.jpg'))) }}"        alt="Profile" class="w-full h-full border-4 border-[#199af4] rounded-full" />

                                    </div>
                                </div>

                                <!-- Student Details -->
                                <div class="mt-7 px-3 z-50 relative">
                                    <h3 class="text-xl font-bold text-gray-800">{{ $student->student_name }}</h3>
                                    <p class="text-[#1B9AF5] text-sm font-semibold">
                                        Student ID: 2024-0127
                                    </p>
                                </div>

                                <div class="mt-4 text-sm grid grid-cols-2 border-b border-gray-200 pb-2 gap-y-1 px-3">
                                    <p class="flex flex-col text-md text-black font-semibold">
                                        <span class="text-[#6B7280] text-sm">Class</span>
                                        {{ optional($student->classes->first())->name }}
                                    </p>
                                    <p class="flex flex-col text-md text-black font-semibold">
                                        <span
                                            class="text-[#6B7280] text-sm">Section</span>{{ optional($student->sections->first())->name }}
                                    </p>
                                    <p class="flex flex-col text-md text-black font-semibold">
                                        <span class="text-[#6B7280] text-sm">Date of Birth</span>
                                        {{ $student->date_of_birth }}
                                    </p>
                                    <p class="flex flex-col text-md text-black font-semibold">
                                        <span class="text-[#6B7280] text-sm">Roll Number</span>
                                        127
                                    </p>
                                    <p class="flex flex-col text-md text-black font-semibold">
                                        <span class="text-[#6B7280] text-sm">Blood Group</span>
                                        {{ $student->blood_group }}
                                    </p>
                                    <p class="flex flex-col text-md text-black font-semibold">
                                        <span class="text-[#6B7280] text-sm">Valid Through</span>
                                        2024-2025
                                    </p>
                                </div>

                                <div class="mt-1 text-sm px-3">
                                    <p class="flex flex-col text-md text-black font-semibold mb-2">
                                        <span class="text-[#6B7280] text-sm">Address</span>
                                        {{ Str::limit(ltrim($student->current_address), 20) }}
                                    </p>
                                    <p class="flex flex-col text-md text-black font-semibold">
                                        <span class="text-[#6B7280] text-sm">Emergency Contact</span>
                                        {{ $student->guardian->guardian_contact ?? null }}
                                    </p>
                                </div>

                                 
                                

                                 

                                <!-- Principal's Signature -->
                                <div class="mt-3 px-3">
                                    <img src="{{ asset('assets/card-signature.png') }}" alt="signature"
                                        class="w-10" />
                                    <p class="text-gray-600 text-xs">Principal's Signature</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        @endif
    </div>

    </div>
@endsection
@section('script')
    <script>
        var select_template = document.getElementById('select_template');
        var show_card = document.getElementsByClassName('show_card');
        showCard();
        select_template.addEventListener('change', (e) => {
            showCard();
        });

        function showCard() {
            var value = select_template.value;

            for (x in show_card) {
                if (show_card[x]) {
                    if (x == 'length') {
                        break;
                    }
                    // console.log(show_card[x]);

                    // console.log(show_card[x].classList);
                    if (!show_card[x].classList.contains('hidden')) {
                        show_card[x].classList.add('hidden');
                    }
                    // show_card[x].classList.remove('hidden');
                    // show_card[x].classList.add('hidden');
                }
            }

            show_card[value].classList.remove('hidden');
        }

  function printCard(cardId) {
        const printContents = document.getElementById(cardId).innerHTML;
        const originalContents = document.body.innerHTML;

        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;

        // Optional: Reload to rebind any JS or state
        // location.reload();
    }
 
    </script>
@endsection
