<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: DejaVu Sans, sans-serif; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h2>Student Dues Report</h2>
    <table>
        <thead>
            <tr>
                <th>Student Name</th>
                <th>Reg No</th>
                <th>HeadCode</th>
                <th>Class</th>
                <th>Status</th>
                <th style="text-align:right;">Debit</th>
                <th style="text-align:right;">Credit</th>
                <th style="text-align:right;">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($students as $student)
            <tr>
                <td>{{ $student->student_name }}</td>
                <td>{{ $student->reg_no }}</td>
                <td>{{ $student->head_code }}</td>
                <td>{{ $student->latestAdmission->class->name ?? 'N/A' }}</td>
                <td>{{ $student->status }}</td>
                <td style="text-align:right;">{{ number_format($student->studentDebit, 2) }}</td>
                <td style="text-align:right;">{{ number_format($student->studentCredit, 2) }}</td>
                <td style="text-align:right;">
                    {{ number_format($student->studentDebit - $student->studentCredit, 2) }}
                </td>
            </tr>
            @endforeach
            <tr>
                <td colspan="5"><strong>Total</strong></td>
                <td style="text-align:right;"><strong>{{ number_format($totalDebit, 2) }}</strong></td>
                <td style="text-align:right;"><strong>{{ number_format($totalCredit, 2) }}</strong></td>
                <td style="text-align:right;"><strong>{{ number_format($totalDebit - $totalCredit, 2) }}</strong></td>
            </tr>
        </tbody>
    </table>
</body>
</html>
