<div class="overflow-auto">
    <table class="w-full text-[#4B5563] table-auto text-sm text-left">
        <thead class="bg-[#f9fafc] text-[16px]">
            <tr>
                <th class="px-4 py-4 border-b">Student Name</th>
                <th class="px-4 py-4 border-b">Reg No</th>
                <th class="px-4 py-4 border-b">HeadCode</th>
                <th class="px-4 py-4 border-b">Class</th>
                <th class="px-4 py-4 border-b">Status</th>
                <th class="px-4 py-4 border-b text-right">Debit</th>
                <th class="px-4 py-4 border-b text-right">Credit</th>
                <th class="px-4 py-4 border-b text-right">Total</th>
            </tr>
        </thead>
        <tbody class="mt-3 text-[16px] border rounded-xl">
            @foreach ($students as $student)
                <tr class="bg-white py-5">
                    <td class="px-4 py-4 border-b">{{ $student->student_name }}</td>
                    <td class="px-4 py-4 border-b">{{ $student->reg_no }}</td>
                    <td class="px-4 py-4 border-b">{{ $student->head_code }}</td>
                    <td class="px-4 py-4 border-b">{{ $student->latestAdmission->class->name ?? 'N/A' }}</td>
                    <td class="px-4 py-4 border-b">{{ $student->status }}</td>
                    <td class="px-4 py-4 border-b text-right">{{ number_format($student->studentDebit, 2) }}</td>
                    <td class="px-4 py-4 border-b text-right">{{ number_format($student->studentCredit, 2) }}</td>
                    <td class="px-4 py-4 border-b text-right">
                        {{ number_format($student->studentDebit - $student->studentCredit, 2) }}
                    </td>
                </tr>
            @endforeach

            <tr class="py-5 bg-[#f9fafc]">
                <td class="px-4 py-4 font-semibold border-b" colspan="5">Total</td>

                <td class="px-4 py-4 font-semibold border-b text-right">
                    {{ number_format($totalDebit, 2) }}
                </td>
                <td class="px-4 py-4 font-semibold border-b text-right">
                    {{ number_format($totalCredit, 2) }}
                </td>
                <td class="px-4 py-4 font-semibold border-b text-right">
                    {{ number_format($totalDebit - $totalCredit, 2) }}
                </td>
            </tr>

        </tbody>
    </table>
</div>
