@extends('schoolLayout.app')
@section('content')
    <!-- Header Section -->
    <div class="flex justify-between items-center">
        <div class="flex flex-col">
            <h1 class="text-2xl font-bold text-gray-800">Manage Student Login</h1>
            <p class="text-gray-600">
                Manage and update student login credentials and access permissions
            </p>
        </div>
    </div>

    <!-- Search and Filters -->
    <div class="mt-10 flex gap-4">
        <!-- Search Bar -->
        <div class="relative w-full">
            <div class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
                <span class="text-gray-500">
                    <img src="{{ asset('assets/search.png') }}" alt="icon" />
                </span>
                <input type="text" placeholder="Search Students..."
                    class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none" />
            </div>
        </div>
        <!-- Dropdowns -->
        <select class="p-2 border rounded-lg w-full md:w-1/4">
            <option>All Classes</option>
        </select>
        <select class="p-2 border rounded-lg w-full md:w-1/4">
            <option>All Sections</option>
        </select>
        <select class="p-2 border rounded-lg w-full md:w-1/4">
            <option>Sort By</option>
        </select>
    </div>

    <!-- Applications Table -->
    <div class="bg-white py-3 rounded-lg shadow mt-6 relative">
        <table class="w-full border-collapse">
            <thead>
                <tr class="text-gray-600">
                    <th class="p-3 text-center font-medium">
                        <input type="checkbox" />
                    </th>
                    <th class="p-3 text-left font-medium">Student</th>
                    <th class="p-3 text-left font-medium">Username</th>
                    <th class="p-3 text-left font-medium">Last Login</th>
                    <th class="p-3 text-left font-medium">Status</th>
                    <th class="p-3 text-left font-medium">Actions</th>
                </tr>
            </thead>
            <tbody>
                <!-- Student Row -->
                <tr class="border-b">
                    <td class="p-3 text-center"><input type="checkbox" /></td>
                    <td class="p-3 flex items-center">
                        <img src="{{ asset('assets/sidebar/student.png') }}" alt="Student"
                            class="w-10 h-10 rounded-full" />
                        <div class="ml-3">
                            <p class="font-medium">John Doe</p>
                            <p class="text-sm text-gray-500">ID: 1234</p>
                        </div>
                    </td>
                    <td class="p-3">
                        <div class="ml-3">
                            <p class="font-medium">john.smith24</p>
                            <p class="text-sm flex items-center text-gray-500"><i class="fa-solid fa-eye-slash"></i>*******
                            </p>
                        </div>
                    </td>
                    <td class="p-3 text-gray-500">2024-01-20 09:45 AM</td>
                    <td class="p-3 text-left">
                        <div class="flex justify-start">
                            <span
                                class="inline-block w-[90px] text-center bg-green-200 text-[#166534] px-2 py-0.5 rounded-2xl text-sm">
                                Active
                            </span>
                        </div>
                    </td>

                    <td class="p-3 text-center">
                        <div class="flex gap-4 text-xl">
                            <i class="fa-solid fa-key cursor-pointer text-[#0197FF] hover:text-blue-600"></i>
                            <i class="fa-solid fa-pen-to-square cursor-pointer text-[#9CA3AF] hover:text-blue-600"></i>
                        </div>
                    </td>
                </tr>
                <tr class="border-b">
                    <td class="p-3 text-center"><input type="checkbox" /></td>
                    <td class="p-3 flex items-center">
                        <img src="{{ asset('assets/sidebar/student.png') }}" alt="Student"
                            class="w-10 h-10 rounded-full" />
                        <div class="ml-3">
                            <p class="font-medium">John Doe</p>
                            <p class="text-sm text-gray-500">ID: 1234</p>
                        </div>
                    </td>
                    <td class="p-3">
                        <div class="ml-3">
                            <p class="font-medium">john.smith24</p>
                            <p class="text-sm flex items-center text-gray-500"><i class="fa-solid fa-eye-slash"></i>*******
                            </p>
                        </div>
                    </td>
                    <td class="p-3 text-gray-500">2024-01-20 09:45 AM</td>
                    <td class="p-3 text-left">
                        <div class="flex justify-start">
                            <span
                                class="inline-block w-[90px] text-center bg-green-200 text-[#166534] px-2 py-0.5 rounded-2xl text-sm">
                                Active
                            </span>
                        </div>
                    </td>

                    <td class="p-3 text-center">
                        <div class="flex gap-4 text-xl">
                            <i class="fa-solid fa-key cursor-pointer text-[#0197FF] hover:text-blue-600"></i>
                            <i class="fa-solid fa-pen-to-square cursor-pointer text-[#9CA3AF] hover:text-blue-600"></i>
                        </div>
                    </td>
                </tr>
                <tr class="border-b">
                    <td class="p-3 text-center"><input type="checkbox" /></td>
                    <td class="p-3 flex items-center">
                        <img src="{{ asset('assets/sidebar/student.png') }}" alt="Student"
                            class="w-10 h-10 rounded-full" />
                        <div class="ml-3">
                            <p class="font-medium">John Doe</p>
                            <p class="text-sm text-gray-500">ID: 1234</p>
                        </div>
                    </td>
                    <td class="p-3">
                        <div class="ml-3">
                            <p class="font-medium">john.smith24</p>
                            <p class="text-sm flex items-center text-gray-500"><i class="fa-solid fa-eye-slash"></i>*******
                            </p>
                        </div>
                    </td>
                    <td class="p-3 text-gray-500">2024-01-20 09:45 AM</td>
                    <td class="p-3 text-left">
                        <div class="flex justify-start">
                            <span
                                class="inline-block w-[90px] text-center bg-green-200 text-[#166534] px-2 py-0.5 rounded-2xl text-sm">
                                Active
                            </span>
                        </div>
                    </td>

                    <td class="p-3 text-center">
                        <div class="flex gap-4 text-xl">
                            <i class="fa-solid fa-key cursor-pointer text-[#0197FF] hover:text-blue-600"></i>
                            <i class="fa-solid fa-pen-to-square cursor-pointer text-[#9CA3AF] hover:text-blue-600"></i>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
        <div class="flex justify-between items-center mt-4 px-4">
            <div class="flex justify-between items-center mt-4">
                <p class="text-gray-500 text-sm">Showing 1 to 2 of 50 results </p>

                <!-- Select Option for Number of Students -->
                <div class="flex items-center">
                    <select id="entries"
                        class="border rounded-lg px-1 py-1 text-sm focus:outline-none focus:ring-2 focus:ring-blue-400">
                        <option value="10">10</option>
                        <option value="20">20</option>
                        <option value="30">30</option>
                    </select>
                </div>
            </div>

            <div class="flex space-x-2">
                <button class="px-3 py-1 border border-gray-400 rounded-lg">
                    Previous
                </button>
                <button class="px-3 py-1 border border-gray-400 bg-[#0197FF] text-white rounded-lg">
                    1
                </button>
                <button class="px-3 py-1 border border-gray-400 rounded-lg">2</button>
                <button class="px-3 py-1 border border-gray-400 rounded-lg">3</button>
                <button class="px-3 py-1 border border-gray-400 rounded-lg">
                    Next
                </button>
            </div>
        </div>
    </div>
@endsection
