@extends('schoolLayout.app')
@section('content')
    <div>
        <!-- Top Section: Tabs & New Admission Button -->
        <div class="flex justify-between items-center border-b pb-4">
            <!-- Tabs: Current & Alumni -->
            <div class="flex space-x-4">
                <button class="tab-btn px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Current Students
                </button>
                <button class="tab-btn text-gray-700 font-semibold"
                    onclick="window.location.href='{{ route('student.studentAlumni') }}'">
                    Alumni Students
                </button>
            </div>
            <!-- New Admission Button -->
            <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-lg">
                <img src="{{ asset('assets/new.png') }}" alt="icon" />
                <span>New Admission</span>
            </button>
        </div>

        <!-- Filters Section -->
        <div class="mt-4 flex flex-wrap gap-4">
            <div class="relative flex-1">
                <div class="border border-gray-200 bg-white rounded-sm flex items-center px-4">
                    <span class="text-gray-500">
                        <img src="{{ asset('assets/search.png') }}" alt="icon" />
                    </span>
                    <input type="text" placeholder="Search Students..."
                        class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none" />
                </div>
            </div>
            <select name="class_filter" class="border p-2 rounded-lg">
                <option value="">All Classes</option>
                @foreach ($classes as $class)
                    <option value="{{ $class->id }}" {{ request('class_filter') == $class->id ? 'selected' : '' }}>
                        {{ $class->name }}
                    </option>
                @endforeach
            </select>

            <select name="section_filter" class="border p-2 rounded-lg">
                <option value="">All Sections</option>
                @foreach ($sections as $section)
                    <option value="{{ $section->id }}" {{ request('section_filter') == $section->id ? 'selected' : '' }}>
                        {{ $section->name }}
                    </option>
                @endforeach
            </select>

            <!-- View Toggle -->
            <div class="flex">
                <button class="view-btn px-4 py-2 ">
                    <img src="{{ asset('assets/list.png') }}" alt="icon"
                        onclick="window.location='{{ route('student.currentStudent') }}'" />
                </button>
                <button class="view-btn px-4 py-2 bg-gray-200">
                    <img src="{{ asset('assets/grid.png') }}" alt="icon" />
                </button>
            </div>
        </div>
        <div class="grid grid-cols-1 mt-4 md:grid-cols-3 gap-6">
            <!-- Student Card -->
            @foreach ($students as $student)
                <div class="bg-white shadow-md rounded-lg p-4">
                    <!-- First Row -->
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-3">
                            <img src="{{ optional($student->documents)->photo 
                                                ? asset('storage/' . $student->documents->photo) 
                                                : asset('assets/sidebar/student.png') }}"  alt="Student"
                                class="w-10 h-10 rounded-full" />
                            <div>
                                <h3 class="text-lg font-semibold">{{ $student->student_name }}</h3>
                                <p class="text-sm text-gray-500">{{ $student->email }}</p>
                            </div>
                        </div>
                        <button class="text-gray-500 text-xl hover:text-gray-700">
                            &#x22EE;
                        </button>
                    </div>

                    <!-- Second Row -->
                    <div class="mt-3 flex gap-x-36 text-lg text-gray-700">
                        <p class="flex flex-col font-semibold "><span class=" text-gray-500">Roll
                                No</span>{{ $student->id }}</p>
                        <p class="flex flex-col font-semibold "><span class=" text-gray-500">Class</span>
                            @foreach ($student->classes as $class)
                                <span>{{ $class->name }}</span><br>
                            @endforeach
                        </p>
                    </div>

                    <!-- Third Row -->
                    <div class="mt-2 flex gap-x-36 text-lg text-gray-700">

                        <p class="flex flex-col font-semibold "><span class=" text-gray-500">Section </span>
                            @foreach ($student->sections as $section)
                                <span>{{ $section->name }}</span><br>
                            @endforeach
                        </p>
                        <p class="flex flex-col font-semibold "><span class=" text-gray-500">Status</span><span
                                class="bg-gray-200 text-[#166534] text-sm py-1 rounded-xl px-2">
                                {{ $student->status }}
                            </span></p>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Pagination -->
        {{ $students->links('vendor.pagination.custom-pagination') }}
    </div>
@endsection
