@extends('schoolLayout.app')
@section('content')
    <div>
        <!-- Top Section: Tabs & New Admission Button -->
        <div class="flex justify-between items-center border-b pb-4">
            <!-- Tabs: Current & Alumni -->
            <div class="flex space-x-4">
                <button class="tab-btn text-gray-700 font-semibold"
                    onclick="window.location.href='{{ route('student.currentStudent') }}'">
                    Current Students
                </button>
                <button class="tab-btn px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Alumni Students
                </button>
            </div>
            <!-- New Admission Button -->
            <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-lg"
                onclick="window.location.href='{{ route('student.admission') }}'">
                <img src="{{ asset('assets/new.png') }}" alt="icon" />
                <span>New Admission</span>
            </button>
        </div>
        <div id="selectionBar" class="  p-3 flex gap-x-2 bg-white shadow-sm items-center rounded-lg mt-4">
            <span id="selectedCount" class="font-medium ">
                <div class="" id="selected_students"></div>
            </span>
            <div class="flex gap-2">
                <button class="bg-[#0197FF] text-white px-4 py-2 rounded-sm" onclick="markAsCurrent()">
                    Mark as Current
                </button>
            </div>
        </div>


        <!-- Filters Section -->
        <!-- Filters Section -->
        <div class="mt-4 flex flex-wrap gap-4">
            <div class="relative flex-1">
                <div class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
                    <span class="text-gray-500">
                        <img src="{{ asset('assets/search.png') }}" alt="icon" />
                    </span>
                    <input id="search" type="text" placeholder="Search Students..."
                        class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none"
                        onkeyup="fetchStudents()" />
                </div>
            </div>
            <select id="class_filter" name="class_filter" class="border p-2 rounded-lg" onchange="fetchStudents()">
                <option value="">All Classes</option>
                @foreach ($classes as $class)
                    <option value="{{ $class->id }}" {{ request('class_filter') == $class->id ? 'selected' : '' }}>
                        {{ $class->name }}
                    </option>
                @endforeach
            </select>
            <select id="section_filter" name="section_filter" class="border p-2 rounded-lg" onchange="fetchStudents()">
                <option value="">All Sections</option>
                @foreach ($sections as $section)
                    <option value="{{ $section->id }}" {{ request('section_filter') == $section->id ? 'selected' : '' }}>
                        {{ $section->name }}
                    </option>
                @endforeach
            </select>
            <!-- View Toggle -->
            <div class="flex">
                <div>
                    <button type="button" onclick="downloadAlumniPdf()"
                        class="px-4 py-2 bg-[#0197FF] hover:bg-blue-600 text-white rounded-lg">
                        Export PDF
                    </button>
                </div>

            </div>
        </div>
        <div class="bg-white py-3 rounded-lg shadow mt-6 relative">
            <form id="markAsCurrentForm" action="{{ route('mark.as.current') }}" method="POST">
                @csrf
                <span id="alumni-student-list">

                    @include('student.alumni-student-search-results', [
                        'students' => $students,
                    ])
                </span>

                {{ $students->links('vendor.pagination.custom-pagination') }}
            </form>
        </div>
    </div>
    <script>
        function downloadAlumniPdf() {
            let search = document.getElementById("search").value;
            let classFilter = document.getElementById("class_filter").value;
            let sectionFilter = document.getElementById("section_filter").value;

            let url =
                `{{ route('pdf.alumni.student') }}?search_query=${search}&class_filter=${classFilter}&section_filter=${sectionFilter}`;
            window.open(url, '_blank');
        }
        // Get the "all_check" checkbox element
        let all_check = document.getElementById('all_check');

        // Get all the "select_student" checkboxes
        let select_students = document.querySelectorAll('.select_student');

        // Add an event listener to the "all_check" checkbox
        all_check.addEventListener('click', function() {
            // Loop through all the "select_student" checkboxes
            select_students.forEach(function(studentCheckbox) {
                // Set the checked state of each "select_student" checkbox to match the "all_check" checkbox
                studentCheckbox.checked = all_check.checked;
            });
        });


        select_students.forEach(function(studentCheckbox) {
            studentCheckbox.addEventListener('click', function() {
                // Check if all "select_student" checkboxes are checked
                let allChecked = true;
                select_students.forEach(function(checkbox) {
                    if (!checkbox.checked) {
                        allChecked = false;
                    }
                });

                // Set the "all_check" checkbox state based on whether all "select_student" checkboxes are checked
                all_check.checked = allChecked;
            });
        });

        function markAsCurrent() {
            // Get all checkboxes with name "students[]"
            const checkboxes = document.querySelectorAll('input[name="students[]"]:checked');

            // Check if at least one checkbox is selected
            if (checkboxes.length > 0) {
                document.getElementById('markAsCurrentForm').submit();
            } else {
                alert('Please select at least one student.');
            }
        }

        function toggleDropdown(button) {
            // Close all dropdowns first
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            // Toggle the clicked dropdown
            const dropdown = button.nextElementSibling;
            dropdown.classList.toggle("hidden");
        }

        // Close dropdown when clicking outside
        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });

        // search Student Functionality
        function fetchStudents() {
            let search = document.getElementById("search").value;
            let classFilter = document.getElementById("class_filter").value;
            let sectionFilter = document.getElementById("section_filter").value;

            $.ajax({
                url: "{{ route('student.studentAlumni') }}",
                method: "GET",
                data: {
                    search_query: search,
                    class_filter: classFilter,
                    section_filter: sectionFilter
                },
                success: function(response) {
                    $('#alumni-student-list').html(response);
                }
            });
        }
    </script>
@endsection
