@extends('schoolLayout.app')
@section('content')
    <!-- Include Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        /* Increase height of the Select2 container */
        .custom-select2+.select2-container .select2-selection--single {
            height: 38px !important;
            display: flex;
            align-items: center;
            border-radius: 0.375rem;
            /* Tailwind's rounded */
            border: 1px solid #d1d5db;
            /* Tailwind gray-300 */
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        /* Optional: increase font size */
        .custom-select2+.select2-container .select2-selection__rendered {
            font-size: 16px;
            line-height: 48px;
        }
    </style>

    @if ($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error:</strong>
            <ul class="list-disc list-inside text-sm mt-1">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if (session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Success:</strong>
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
    @endif

    <div class="max-w-5xl mx-auto bg-white p-6 shadow-md rounded-lg">
        <h2 class="text-2xl font-bold text-gray-700 border-b border-gray-200 pb-4 mb-6">
            Fee Receipt Form
        </h2>

        <form id="fee-receipt-form" action="{{ route('fee_recipt_form.store') }}" method="POST">
            @csrf
            <div class="flex-1 items-center mt-4 space-x-4">
            <label class="block mb-1 font-medium text-gray-700">Select Student</label>
                <select id="student-search" name="student-search"
                    class="border p-2 rounded-lg select2 custom-select2 w-full">
                    <option value="">Select</option>
                    @foreach ($stdList as $s)
                        <option value="{{ $s->head_code }}">
                            {{ $s->student_name }} - {{ $s->reg_no }}
                        </option>
                    @endforeach
                </select>
            </div>

            <!-- Student Details -->
            <div id="student-details" class="space-y-4 mt-4">
                <div class="grid grid-cols-3 gap-4">
                    <div>
                        <label class="block mb-1 font-medium text-gray-700">Date</label>
                        <input type="date" class="w-full p-2 border rounded bg-gray-100" name="date"
                            value="{{ old('date', now()->format('Y-m-d')) }}" />
                    </div>
                    <div>
                        <label class="block mb-1 font-medium text-gray-700">Billing Month</label>
                        <input type="text" value="{{ old('billing_month', now()->format('F Y')) }}"
                            class="w-full p-2 border rounded bg-gray-100" readonly name="billing_month" />
                    </div>
                    <div>
                        <label class="block mb-1 font-medium text-gray-700">Reg No</label>
                        <input type="text" class="w-full p-2 border rounded bg-gray-100" readonly name="registration_no"
                            value="{{ old('registration_no') }}" />
                    </div>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block mb-1 font-medium text-gray-700">Student Name</label>
                        <input type="text" class="w-full p-2 border rounded bg-gray-100" readonly name="student_name"
                            value="{{ old('student_name') }}" />
                    </div>
                    <div>
                        <label class="block mb-1 font-medium text-gray-700">Father's Name</label>
                        <input type="text" class="w-full p-2 border rounded bg-gray-100" readonly name="father_name"
                            value="{{ old('father_name') }}" />
                    </div>
                </div>
                <div class="grid grid-cols-3 gap-4">
                    <div>
                        <label class="block mb-1 font-medium text-gray-700">Class</label>
                        <input type="text" class="w-full p-2 border rounded bg-gray-100" readonly name="class"
                            value="{{ old('class') }}" />
                    </div>
                    <div>
                        <label class="block mb-1 font-medium text-gray-700">Section</label>
                        <input type="text" class="w-full p-2 border rounded bg-gray-100" readonly name="section"
                            value="{{ old('section') }}" />
                    </div>
                    <div>
                        <label class="block mb-1 font-medium text-gray-700">Status</label>
                        <input type="text" class="w-full p-2 border rounded bg-gray-100" readonly name="status"
                            value="{{ old('status') }}" />
                    </div>
                </div>
            </div>

            <!-- Fee Breakdown -->
            <h3 class="text-xl font-semibold text-gray-700 mt-6 mb-3">
                Fee Breakdown
            </h3>
            <div class="space-y-3">
                <!-- Fee Rows -->
                @foreach (['admission_fee', 'promotion_fee', 'tuition_fee', 'lab_fee', 'exam_fee', 'board_fee', 'entertainment_fee', 'books_charges', 'annual_charges', 'second_time_fee', 'other_fee'] as $fee)
                    <div class="grid grid-cols-3 gap-4 items-center">
                        <label class="font-medium text-gray-700">{{ ucfirst(str_replace('_', ' ', $fee)) }}</label>
                        <input type="number" class="p-2 border rounded bg-gray-100" readonly name="{{ $fee }}"
                            value="{{ old($fee) }}" />
                        <input type="number" step="0.01" class="p-2 border border-gray-400 rounded"
                            placeholder="Enter Amount" name="{{ $fee }}_input"
                            value="{{ old($fee . '_input') }}" />
                    </div>
                @endforeach
            </div>

            <!-- Summary Section -->
            <div class="grid grid-cols-4 gap-4 mt-6">
                <div>
                    <label class="block mb-1 font-medium text-gray-700">Total Due Amount</label>
                    <input type="text" value="{{ old('total_due') }}" class="w-full p-2 border rounded bg-gray-100"
                        readonly name="total_due" />
                </div>
                <div>
                    <label class="block mb-1 font-medium text-gray-700">Receiving Amount</label>
                    <input type="number" class="w-full p-2 border rounded" placeholder="Receiving amount"
                        name="receiving_amount" value="{{ old('receiving_amount') }}" readonly />
                </div>
                <div>
                    {{--   <label class="block mb-1 font-medium text-gray-700">Discount</label> --}}
                    <input type="hidden" step="0.01" class="w-full p-2 border rounded"
                        placeholder="Enter discount amount" name="discount" value=0 />
                </div>
                <div>
                    <label class="block mb-1 font-medium text-gray-700">Balance</label>
                    <input type="text" value="{{ old('balance') }}" class="w-full p-2 border rounded bg-gray-100"
                        readonly name="balance" />
                </div>
            </div>

            <!-- Buttons -->
            <div class="flex justify-end space-x-4 mt-8">
                <button type="submit" class="px-4 py-2 bg-[#1B9AF5] text-white rounded flex items-center">
                    <i class="fa-solid fa-save mr-2"></i> Save Record
                </button>
                <button type="submit" class="px-4 py-2 bg-[#1B9AF5] text-white rounded flex items-center">
                    <i class="fa-solid fa-print mr-2"></i> Save & Print
                </button>
                <button type="button" class="px-4 py-2 border border-[#1B9AF5] text-[#1B9AF5] rounded flex items-center">
                    <i class="fa-solid fa-gear mr-2"></i> Fee Setup
                </button>
            </div>

            <!-- Hidden Inputs -->
            <input type="hidden" id="student_id" name="student_id" value="{{ old('student_id') }}" />
            <input type="hidden" id="class_id" name="class_id" value="{{ old('class_id') }}" />
            <input type="hidden" id="section_id" name="section_id" value="{{ old('section_id') }}" />
            <input type="hidden" id="academicYear" name="academicYear" value="{{ old('academicYear') }}" />
        </form>
    </div>

    <!-- Include jQuery & Select2 JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://kit.fontawesome.com/your-fontawesome-kit.js" crossorigin="anonymous"></script>

    <script>
        $(document).ready(function() {
            // Initialize Select2
            $('.select2').select2({
                allowClear: true,
                width: '100%'
            });
            $(document).on('select2:open', function() {
                const searchField = $('.select2-search__field');
                if (searchField.length) {
                    searchField[0].focus();
                }
            });

            // Calculate total receiving amount
            function updateTotal() {
                let total = 0;
                $("input[name$='_input']").each(function() {
                    const val = parseFloat($(this).val()) || 0;
                    total += val;
                });
                $("input[name='receiving_amount']").val(total.toFixed(2));
                updateBalance();
            }

            // Calculate balance
            function updateBalance() {
                const totalDue = parseFloat($("input[name='total_due']").val()) || 0;
                const discount = parseFloat($("input[name='discount']").val()) || 0;
                const receiving = parseFloat($("input[name='receiving_amount']").val()) || 0;
                const balance = totalDue - (receiving + discount);
                $("input[name='balance']").val(balance.toFixed(2));
            }

            // Update total when fee inputs change
            $("input[name$='_input']").on('input', updateTotal);

            // Update balance when discount changes
            $("input[name='discount']").on('input', updateBalance);

            // AJAX call when student is selected
            $('#student-search').on('change', function() {
                const s_HeadCode = $(this).val();
                if (!s_HeadCode) return;


                // Send AJAX request to backend
                $.ajax({
                    url: '{{ route('fee_recipt_form.search') }}', // Define your route
                    method: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        s_HeadCode: s_HeadCode
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#student-details').removeClass('hidden');
                            $('input[name="student_name"]').val(response.student.student_name);
                            $('input[name="father_name"]').val(response.student.father_name);
                            $('input[name="registration_no"]').val(response.student.reg_no);
                            $('input[name="class"]').val(response.class);
                            $('input[name="section"]').val(response.section);
                            $('input[name="status"]').val(response.student.status);


                            $('input[name="admission_fee"]').val(response.remainingFees
                                .admission_fee);
                            $('input[name="promotion_fee"]').val(response.remainingFees
                                .promotion_fee);
                            $('input[name="tuition_fee"]').val(response.remainingFees
                                .tuition_fee);
                            $('input[name="lab_fee"]').val(response.remainingFees.lab_fee);
                            $('input[name="exam_fee"]').val(response.remainingFees.exam_fee);
                            $('input[name="board_fee"]').val(response.remainingFees.board_fee);
                            $('input[name="entertainment_fee"]').val(response.remainingFees
                                .entertainment_fee);
                            $('input[name="books_charges"]').val(response.remainingFees
                                .books_charges);
                            $('input[name="annual_charges"]').val(response.remainingFees
                                .annual_charges);
                            $('input[name="second_time_fee"]').val(response.remainingFees
                                .second_time_fee);
                            $('input[name="other_fee"]').val(response.remainingFees.other_fee);

                            $('input[name="total_due"]').val(response.totalDue);

                            $('input[name="student_id"]').val(response.student.id);
                            $('input[name="class_id"]').val(response.classId);
                            $('input[name="section_id"]').val(response.sectionId);
                            $('input[name="academicYear"]').val(response.academicYear);


                        } else {
                            alert('Student not found.');
                        }
                    },
                    error: function(xhr, status, error) {
                        alert('Something went wrong. Please try again.');
                    }
                });

            });
        });
    </script>
@endsection
