<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Fee Receipt</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 14px;
            padding: 20px;
        }

        .header-table,
        .fee-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .header-table td {
            vertical-align: top;
            padding: 5px;
        }

        h2 {
            margin: 0 0 5px 0;
        }

        .fee-table th,
        .fee-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        .fee-table th {
            background-color: #f9fafc;
            font-weight: bold;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            font-weight: bold;
        }
    </style>
</head>

<body>

    <!-- Header Section: School & Receipt Info -->
    <table class="header-table">
        <tr>
            <!-- Left Side -->
            <td width="50%">
                <img src="{{ public_path('assets/new-logo.svg') }}" alt="Logo"
                    style="max-height: 60px; margin-bottom: 10px;">
                <h2>{{ $data['school_name'] }}</h2>
                <p>{{ $data['school_address'] }}</p>
                <p><strong>Student Name:</strong> {{ $data['student_name'] }}</p>
                <p><strong>Academic Year:</strong> {{ $data['academic_year'] }}</p>
                <p><strong>Class:</strong> {{ $data['class'] }}</p>
                <p><strong>Section:</strong> {{ $data['section'] }}</p>
            </td>

            <!-- Right Side -->
            <td width="50%" align="right">
                <p><strong>Receipt #:</strong> {{ $data['receipt_no'] }}</p>
                <p><strong>Date:</strong> {{ $data['date'] }}</p>
                <p><strong>Billing Month:</strong> {{ $data['billing_month'] }}</p>
                <p><strong>Due Date:</strong> {{ $data['due_date'] }}</p>
            </td>
        </tr>
    </table>

    <!-- Fee Breakdown Table -->
    <table class="fee-table">
        <thead>
            <tr>
                <th>Fee Type</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            @php
                $total = 0;
            @endphp
            @foreach ($data['fees'] as $feeType => $fee)
                @php
                    // Support both scalar and array-based fee
                    $amount = is_array($fee) ? $fee['amount'] ?? 0 : floatval($fee);
                    $total += $amount;
                @endphp
                @if ($amount > 0)
                    <tr>
                        <td>{{ ucwords(str_replace('_', ' ', $feeType)) }}</td>
                        <td>{{ number_format($amount, 2) }}</td>
                    </tr>
                @endif
            @endforeach
            <tr>
                <th>Total</th>
                <th>{{ number_format($total, 2) }}</th>
            </tr>
        </tbody>

    </table>

    <p class="footer">This is automated Generated Slip. If any error please contact.!</p>

</body>

</html>
