@extends('schoolLayout.app')
@section('content')
    <!-- Student Details Section -->
    <section class="bg-white p-6 rounded-lg shadow-sm mb-6">
        <div class="flex items-start">
            <!-- Student Picture -->
            <img src="{{ asset('/assets/student.png') }}" alt="Student Picture"
                class="w-32 h-32 rounded-xl border border-gray-300" />

            <!-- Student Info -->
            <div class="ml-6 flex-1">
                <h2 class="text-xl font-semibold">Michael Anderson</h2>
                <p class="text-gray-600">Student ID: 123456</p>
                <div class="flex flex-wrap max-w-md gap-x-4 gap-y-2 p-2">
                    <p class="text-gray-600">
                        Class: <span class="text-black">10th Grade</span>
                    </p>
                    <p class="text-gray-600">
                        Enrollment Date: <span class="text-black">01 Jan 2023</span>
                    </p>
                    <p class="text-gray-600">
                        Guardian: <span class="text-black">Jane Doe</span>
                    </p>
                    <p class="text-gray-600">
                        Contact: <span class="text-black">+92 300 1234567</span>
                    </p>
                </div>
            </div>

            <!-- Contact Guardian Button -->
            <button class="border border-black text-black px-4 py-2 rounded-md flex gap-x-2 items-center">
                <i class="fa-solid fa-envelope"></i> Contact Guardian
            </button>
        </div>
    </section>

    <!-- Fee Summary Section -->
    <section class="bg-white p-6 rounded-lg shadow-sm mb-6">
        <div class="grid grid-cols-4 gap-6">
            <!-- Total Fee Card -->
            <div class="p-4 rounded-lg flex justify-between">
                <div>
                    <p class="text-gray-500 font-semibold">Total Fee</p>
                    <p class="text-2xl font-semibold">$12,000</p>
                </div>
                <span class="inline-flex items-center justify-center bg-gray-200 rounded-full p-2 h-10">
                    <i class="fa-solid fa-dollar-sign text-red-500"></i>
                </span>
            </div>

            <!-- Amount Paid Card -->
            <div class="p-4 rounded-lg flex justify-between">
                <div>
                    <p class="text-gray-500 font-semibold">Amount Paid</p>
                    <p class="text-2xl font-semibold">$8,750</p>
                </div>
                <span class="inline-flex items-center justify-center bg-gray-200 rounded-full p-2 h-10">
                    <i class="fa-solid fa-check"></i>
                </span>
            </div>

            <!-- Pending Amount Card -->
            <div class="p-4 rounded-lg flex justify-between">
                <div>
                    <p class="text-gray-500 font-semibold">Pending Amount</p>
                    <p class="text-2xl font-semibold">$8,750</p>
                </div>
                <span class="inline-flex items-center justify-center bg-[#FFEDD5] rounded-full p-2 h-10">
                    <i class="fa-solid fa-clock text-red-500"></i>
                </span>
            </div>

            <!-- Next Due Date Card -->
            <div class="p-4 rounded-lg flex justify-between">
                <div>
                    <p class="text-gray-500 font-semibold">Next Due Date</p>
                    <p class="text-2xl font-semibold">15 Sep 2024</p>
                </div>
                <span class="inline-flex items-center justify-center bg-gray-200 rounded-full p-2 h-10">
                    <i class="fa-solid fa-calendar text-red-500"></i>
                </span>
            </div>
        </div>
    </section>

    <!-- Payment History Section -->
    <section class="bg-white  rounded-lg shadow-md pb-10">
        <!-- Header -->
        <div class="flex justify-between items-center mb-4 px-6 pt-3 ">
            <h3 class="text-2xl font-semibold">Payment History</h3>
            <div class="flex gap-4">
                <button class="border border-gray-600 text-gray-600 px-4 py-2 rounded-md flex gap-x-2 items-center">
                    <i class="fa-solid fa-file-export"></i> Export
                </button>
                <button class="border border-gray-600 text-gray-600 px-4 py-2 rounded-md flex gap-x-2 items-center">
                    <i class="fa-solid fa-print"></i> Print
                </button>
            </div>
        </div>

        <!-- Table -->
        <table class="w-full border-collapse border border-gray-300">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border border-gray-300 p-2 font-medium text-gray-600 text-left">Invoice</th>
                    <th class="border border-gray-300 p-2 font-medium text-gray-600 text-left">Date</th>
                    <th class="border border-gray-300 p-2 font-medium text-gray-600 text-left">Category</th>
                    <th class="border border-gray-300 p-2 font-medium text-gray-600 text-left">Amount</th>
                    <th class="border border-gray-300 p-2 font-medium text-gray-600 text-left">Status</th>
                    <th class="border border-gray-300 p-2 font-medium text-gray-600 text-left">Payment Method</th>
                </tr>
            </thead>
            <tbody>
                <tr class="border border-gray-300">
                    <td class="border border-gray-300 p-2 text-black font-semibold">INV-001</td>
                    <td class="border border-gray-300 p-2">01 Aug 2024</td>
                    <td class="border border-gray-300 p-2">Tuition Fee</td>
                    <td class="border border-gray-300 p-2">PKR 10,000</td>
                    <td class="border border-gray-300 p-2 text-green-600">Paid</td>
                    <td class="border border-gray-300 p-2">Bank Transfer</td>
                </tr>
                <tr class="border border-gray-300">
                    <td class="border border-gray-300 p-2 text-black font-semibold">INV-002</td>
                    <td class="border border-gray-300 p-2">01 Sep 2024</td>
                    <td class="border border-gray-300 p-2">Tuition Fee</td>
                    <td class="border border-gray-300 p-2">PKR 10,000</td>
                    <td class="border border-gray-300 p-2 text-yellow-600">Pending</td>
                    <td class=" p-2">Cash</td>
                </tr>
            </tbody>
        </table>
    </section>
@endsection
