<div class="overflow-x-auto">
    <table class="w-full border-collapse text-sm">
        <thead class="sticky top-0 bg-white">
            <tr class="text-gray-600">
                <th class="p-2 text-left font-medium min-w-[120px]">Student</th>
                <th class="p-2 text-center font-medium">Reg No</th>
                <th class="p-2 text-center font-medium">Narration</th>
                <th class="p-2 text-center font-medium">Status</th>
                <th class="p-2 text-left font-medium">Class</th>
                <th class="p-2 text-left font-medium">Month</th>
                <th class="p-2 text-left font-medium">Date</th>
                
                <!-- Fee Columns with abbreviated headers -->
                <th class="p-2 text-right font-medium" title="Admission Fee">Adm</th>
                <th class="p-2 text-right font-medium" title="Promotion Fee">Prom</th>
                <th class="p-2 text-right font-medium" title="Scholarship Fee">Sch</th>
                <th class="p-2 text-right font-medium" title="Sport Fee">Sport</th>
                <th class="p-2 text-right font-medium">Tution</th>
                <th class="p-2 text-right font-medium">Lab</th>
                <th class="p-2 text-right font-medium">Exam</th>
                <th class="p-2 text-right font-medium">Board</th>
                <th class="p-2 text-right font-medium" title="Entertainment Fee">Ent</th>
                <th class="p-2 text-right font-medium">Other</th>
                <th class="p-2 text-right font-medium">Book</th>
                <th class="p-2 text-right font-medium" title="Annual Charges">Annual</th>
                <th class="p-2 text-right font-medium">2nd Fee</th>
                
                <th class="p-2 text-right font-medium">Total</th>
                <th class="p-2 text-center font-medium min-w-[80px]">Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($fees as $index => $f)
                <tr class="border-b {{ $index % 2 === 0 ? 'bg-blue-200' : 'bg-white' }} ">
                    <td class="p-2 flex items-center min-w-[120px]">{{ $f->student->student_name ?? 'N/A' }}</td>
                    <td class="p-2 text-gray-500 text-center">{{ $f->reg_no ?? 'N/A' }}</td>
                    <td class="p-2 text-red-500 text-center">{{"Fee Generated" ?? 'N/A' }}</td>
                    <td class="p-2 text-gray-500 text-center">{{ $f->student->status ?? 'N/A' }}</td>
                    <td class="p-2 text-gray-500">{{ $f->class->name ?? 'N/A' }}</td>
                    <td class="p-2 text-gray-500">{{ $f->billing_month ?? 'N/A' }}</td>
                    <td class="p-2 text-center text-gray-500">{{ $f->date ?? 'N/A' }}</td>
                    
                    <!-- Fee Values -->
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->admission_fee ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->promotion_fee ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->scholarship_fee ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->sport_fee ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->tuition_fee ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->lab_fee ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->exam_fee ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->board_fee ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->entertainment_fee ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->other_fee ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->books_charges ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->annual_charges ?? '0' }}</td>
                    <td class="p-2 text-gray-500 text-right">{{ $f->Student_fee_detail->second_time_fee ?? '0' }}</td>
                    
                    <td class="p-2 text-center text-gray-500 font-medium">{{ $f->total_amount ?? '0' }}</td>
                    <td class="p-2 text-center relative">
                        <button onclick="toggleDropdown(this)" class="action-btn text-blue-700 font-semibold text-sm">
                            View
                        </button>
                        <div class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-lg border">
                            <a href="#" class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Edit</a>
                            <a href="#" class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Delete</a>
                        </div>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="23" class="text-center text-gray-500 py-4">No Data Found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
