@extends('schoolLayout.app')
@section('content')
    <div class="bg-[#f9fafc] min-h-screen px-8 py-8">
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <div class="flex space-x-4 w-full border-b border-gray-200 mb-8">
                <button class="tab-btn px-4 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Fee Records
                </button>
                <button class="tab-btn pb-3 text-gray-700 font-semibold">
                    Fines & Exam Fee
                </button>
            </div>
        </div>
        <div class="bg-white border border-gray-200 px-2 rounded-md shadow-sm">
            <div class="flex justify-between px-4 bg-white py-2 border-b border-gray-200 items-center">
                <!-- Tabs:-->
                <div class="flex space-x-4 bg-white">
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee Categories
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Student's Fees
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee Invoices
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Refund Payments
                    </button>
                    <button class=" tab-btn px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                        Fee History
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee Reminders
                    </button>
                </div>
            </div>
            <div class="rounded-lg mt-4">
                <!-- Filters Section -->
                <div class="bg-white p-3 flex justify-between rounded-lg flex-wrap gap-4">
                    <div class="relative w-[50%] rounded-lg">
                        <div class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
                            <span class="text-gray-500">
                                <img src="{{ asset('/assets/sidebar/student.png') }}" alt="icon" />
                            </span>
                            <input type="text" placeholder="Search by name, ID or class..."
                                class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none" />
                        </div>
                    </div>
                    <div class="flex gap-x-2 items-center">
                        <select class="border p-2 min-w-[100px] rounded-lg">
                            <option>All Classes</option>
                        </select>
                        <select class="border p-2 min-w-[100px] rounded-lg">
                            <option>All Sections</option>
                        </select>
                        <select class="border p-2 min-w-[100px] rounded-lg">
                            <option>All Status</option>
                        </select>
                        <button class="bg-gray-200 rounded-sm px-2 py-2 flex items-center gap-x-2">
                            <i class="fa-solid fa-rotate-right"></i>
                            Reset</button>
                    </div>
                </div>
                <div class="bg-white py-3 rounded-lg relative">
                    <table class="w-full border-collapse">
                        <thead class="bg-[#f9fafc]">
                            <tr class="text-gray-600">
                                <th class="p-3 text-center font-medium">
                                    <input type="checkbox" />
                                </th>
                                <th class="p-3 text-left font-semibold text-black">Student</th>
                                <th class="p-3 text-left font-semibold text-black">ID</th>
                                <th class="p-3 text-left font-semibold text-black">Class & Section</th>
                                <th class="p-3 text-left font-semibold text-black">Total Due</th>
                                <th class="p-3 text-left font-semibold text-black">Status</th>
                                <th class="p-3 text-center font-semibold text-black">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Student Row -->
                            <tr class="border-b">
                                <td class="p-3 text-center"><input type="checkbox" /></td>
                                <td class="p-3 flex items-center">
                                    <img src="{{ asset('/assets/sidebar/student.png') }}" alt="Student"
                                        class="w-10 h-10 rounded-full" />
                                    <div class="ml-3">
                                        <p class="font-medium">John Doe</p>
                                    </div>
                                </td>
                                <td class="p-3 text-gray-500">#STU001</td>
                                <td class="p-3 text-gray-500">Class 10A</td>
                                <td class="p-3 text-gray-700">$1,200.00</td>
                                <td class="p-3 text-left text-gray-500">
                                    <span class="bg-[#FEF9C3] text-[#854D0E] px-2 py-0.5 rounded-2xl text-sm">
                                        Pending
                                    </span>
                                </td>

                                <td class="p-3 text-center relative">
                                    <button onclick="toggleDropdown(this)" class="action-btn text-blue-700 font-semibold">
                                        View Details
                                    </button>
                                    <div
                                        class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-lg border">
                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Edit</a>

                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Delete</a>

                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Generate
                                            Invoice</a>
                                        <a href="#"
                                            class="flex gap-x-2 items-center px-3 text-black py-2 text-nowrap hover:bg-red-100">Collect
                                            Payment</a>
                                    </div>
                                </td>
                            </tr>
                            <tr class="border-b">
                                <td class="p-3 text-center"><input type="checkbox" /></td>
                                <td class="p-3 flex items-center">
                                    <img src="{{ asset('/assets/sidebar/student.png') }}" alt="Student"
                                        class="w-10 h-10 rounded-full" />
                                    <div class="ml-3">
                                        <p class="font-medium">John Doe</p>
                                    </div>
                                </td>
                                <td class="p-3 text-gray-500">STU001</td>
                                <td class="p-3 text-gray-500">Class 10A</td>
                                <td class="p-3 text-gray-700">$1,200.00</td>
                                <td class="p-3 text-left text-gray-500">
                                    <span class="bg-[#DCFCE7] text-[#166534] px-2 py-0.5 rounded-2xl text-sm">
                                        Paid
                                    </span>
                                </td>

                                <td class="p-3 text-center relative">
                                    <button onclick="toggleDropdown(this)" class="action-btn text-blue-700 font-semibold">
                                        View Details
                                    </button>
                                    <div
                                        class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-lg border">
                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Edit</a>

                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Delete</a>

                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Generate
                                            Invoice</a>
                                        <a href="#"
                                            class="flex gap-x-2 items-center px-3 text-black py-2 text-nowrap hover:bg-red-100">Collect
                                            Payment</a>
                                    </div>
                                </td>
                            </tr>

                        </tbody>
                    </table>
                    <div class="flex justify-between border-t mt-10 border-gray-200 bg-white items-center pt-4 p-4">
                        <p class="text-gray-500 text-sm">Showing 1 of 12 enteries</p>
                        <div class="flex space-x-2">
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                Previous
                            </button>
                            <button class="px-3 py-1 border border-gray-400 bg-blue-700 text-white rounded-lg">
                                1
                            </button>
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                2
                            </button>
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                3
                            </button>
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                Next
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function toggleDropdown(button) {
            // Close all dropdowns first
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            // Toggle the clicked dropdown
            const dropdown = button.nextElementSibling;
            dropdown.classList.toggle("hidden");
        }

        // Close dropdown when clicking outside
        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });
    </script>
@endsection
