@extends('schoolLayout.app')
@section('content')
    <div class="bg-[#f9fafc] min-h-screen px-8 py-8">
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <div class="flex space-x-4 w-full border-b border-gray-200 mb-8">
                <button class="tab-btn px-4 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Fee Records
                </button>
                <button class="tab-btn pb-3 text-gray-700 font-semibold">
                    Fines & Exam Fee
                </button>
            </div>
        </div>
        <div class="bg-white border border-gray-200 px-2 rounded-md shadow-sm">
            <div class="flex justify-between px-4 bg-white py-2 border-b border-gray-200 items-center">
                <!-- Tabs:-->
                <div class="flex space-x-4 bg-white">
                    <button class="tab-btn px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                        Fee Categories
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Student's Fees
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee Invoices
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Refund Payments
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee History
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee Reminders
                    </button>
                </div>

                <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-lg">
                    <span>Create Fee Category</span>
                </button>
            </div>
            <div class="rounded-lg mt-4">
                <!-- Filters Section -->
                <div class="bg-white p-3 flex justify-between rounded-lg flex-wrap gap-4">
                    <div class="relative w-[50%] rounded-lg">
                        <div class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
                            <span class="text-gray-500">
                                <img src="{{ asset('assets/search.png') }}" alt="icon" />

                            </span>
                            <input type="text" placeholder="Category"
                                class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none" />
                        </div>
                    </div>
                    <div class="flex gap-x-2 items-center">
                        <select class="border p-2 min-w-[100px] rounded-lg">
                            <option>Today</option>
                        </select>
                    </div>
                </div>
                <div class="relative bg-white">
                    <table class="w-full border-collapse">
                        <thead class="bg-[#f9fafc]">
                            <tr class="text-gray-600">
                                <th class="p-3 text-left font-medium">Category Name</th>
                                <th class="p-3 text-left font-medium">Description</th>
                                <th class="p-3 text-center font-medium">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white py-3 rounded-lg">
                            <!-- Fee Row -->
                            <tr class="border-b">
                                <td class="p-3 flex items-center font-semibold text-black">
                                    Tuition Fee
                                </td>
                                <td class="p-3 text-gray-500">
                                    Basic academic fee for regular classes
                                </td>
                                <td class="p-3 text-center flex justify-center items-center gap-x-2">
                                    <i class="fa-solid fa-pen-to-square text-black"></i>
                                    <i class="fa-solid fa-trash text-red-500"></i>
                                </td>
                            </tr>
                            <tr class="border-b">
                                <td class="p-3 flex items-center font-semibold text-black">
                                    Laboratory Fee
                                </td>
                                <td class="p-3 text-gray-500">
                                    Fee for science and computer lab facilities
                                </td>
                                <td class="p-3 text-center flex justify-center items-center gap-x-2">
                                    <i class="fa-solid fa-pen-to-square text-black"></i>
                                    <i class="fa-solid fa-trash text-red-500"></i>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <div class="flex justify-between border-t mt-10 border-gray-200 bg-white items-center pt-4 p-4">
                        <p class="text-gray-500 text-sm">Showing 1 of 12 enteries</p>
                        <div class="flex space-x-2">
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                Previous
                            </button>
                            <button class="px-3 py-1 border border-gray-400 bg-blue-700 text-white rounded-lg">
                                1
                            </button>
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                2
                            </button>
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                3
                            </button>
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                Next
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
