@extends('schoolLayout.app')
@section('content')
    <style>
        /* Increase height of the Select2 container */
        .custom-select2+.select2-container .select2-selection--single {
            height: 38px !important;
            display: flex;
            align-items: center;
            border-radius: 0.375rem;
            /* Tailwind's rounded */
            border: 1px solid #d1d5db;
            /* Tailwind gray-300 */
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        /* Optional: increase font size */
        .custom-select2+.select2-container .select2-selection__rendered {
            font-size: 16px;
            line-height: 48px;
        }
    </style>
    <!-- Header Section -->
    <div class="flex justify-between items-center">
        <div class="flex justify-between items-center">
            <!-- Tabs -->
            @include('stdFeeMgt.partialhead')
        </div>

    </div>
    <div class="flex  w-full bg-white">
        <button
            class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
            Edit Student Assign Fee
            <span class="bg-gray-200 px-4 py-1 text-gray-700 text-sm rounded-2xl"></span>
        </button>
    </div>
    <div class="flex items-center mt-4 space-x-4">
        <select id="student-search" name="student-search" class="border p-2 rounded-lg  select2 custom-select2">
            <option value="">Select Student</option>
            @foreach ($stdList as $s)
                <option value="{{ $s->head_code }}">
                    {{ $s->student_name }} - {{ $s->reg_no }}
                </option>
            @endforeach
        </select>
        <select id="class-search" name="class-search" class="border p-2 rounded-lg  select2 custom-select2">
            <option value="">Select Class</option>
            @foreach ($classList as $c)
                <option value="{{ $c->id }}">
                    {{ $c->name }}
                </option>
            @endforeach
        </select>
        <a href="#" id="downloadPdfBtn" class="ml-4 px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white rounded-lg">
            PDF
        </a>

    </div>
    @include('successError')
    <!-- Applications Table -->
    <div class="bg-white py-3 rounded-lg shadow mt-6 relative">
        <!-- 🔁 Container for results -->
        <div id="student-table" class="bg-white py-3 rounded-lg shadow mt-6 relative">
            @include('stdFeeMgt.partial-edit-student-assign-fee', ['fees' => $fees])
        </div>
    </div>
    <div class="flex justify-between items-center px-4 pt-4 border-t border-gray-200 mt-8">
        <div class="flex items-center text-sm text-gray-500">
            Showing {{ $fees->firstItem() }} to {{ $fees->lastItem() }} of {{ $fees->total() }} results

            <form method="GET" class="ml-3">
                <select name="entries" onchange="this.form.submit()"
                    class="border rounded-lg px-1 py-1 text-sm focus:outline-none focus:ring-2 focus:ring-blue-400">
                    <option value="40" {{ request('entries') == 40 ? 'selected' : '' }}>40</option>
                    <option value="80" {{ request('entries') == 80 ? 'selected' : '' }}>80</option>
                    <option value="120" {{ request('entries') == 120 ? 'selected' : '' }}>120</option>
                </select>
            </form>
        </div>

        <div class="mt-2">
            {{ $fees->appends(request()->query())->onEachSide(1)->links('pagination::tailwind') }}

        </div>

    </div>
    <!-- Edit Fee Modal -->
    <div id="editFeeModal" class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50 hidden">
        <div class="bg-white rounded-lg shadow-lg p-6 w-full max-w-4xl relative">
            <h2 class="text-xl font-semibold mb-4">Edit Student Assign Fee</h2>
            <form id="editFeeForm" method="POST" action="{{ route('student.fee.update') }}">
                @csrf
                <input type="hidden" name="id" id="edit_id">

                <div class="grid grid-cols-3 gap-4">
                    <div>
                        <label>Reg No</label>
                        <input type="text" id="edit_reg" name="reg_no" class="w-full border p-2 rounded" readonly>
                    </div>
                    <div>
                        <label>Class</label>
                        <input type="text" id="edit_class" name="class_id" class="w-full border p-2 rounded" readonly>
                    </div>
                    <div>
                        <label>Admission Fee</label>
                        <input type="number" id="edit_admission" name="admission_fee" class="w-full border p-2 rounded">
                    </div>
                    <div>
                        <label>Promotion Fee</label>
                        <input type="number" id="edit_promotion" name="promotion_fee" class="w-full border p-2 rounded">
                    </div>

                    <div>
                        <label>Tuition Fee</label>
                        <input type="number" id="edit_tuition" name="tuition_fee" class="w-full border p-2 rounded">
                    </div>
                    <div>
                        <label>Lab Fee</label>
                        <input type="number" id="edit_lab" name="lab_fee" class="w-full border p-2 rounded">
                    </div>
                    <div>
                        <label>Exam Fee</label>
                        <input type="number" id="edit_exam" name="exam_fee" class="w-full border p-2 rounded">
                    </div>
                    <div>
                        <label>Board Fee</label>
                        <input type="number" id="edit_board" name="board_fee" class="w-full border p-2 rounded">
                    </div>
                    <div>
                        <label>Entertainment Fee</label>
                        <input type="number" id="edit_entertainment" name="entertainment_fee"
                            class="w-full border p-2 rounded">
                    </div>
                    <div>
                        <label>Other Fee</label>
                        <input type="number" id="edit_other" name="other_fee" class="w-full border p-2 rounded">
                    </div>
                    <div>
                        <label>Book Charges</label>
                        <input type="number" id="edit_book" name="book_charges" class="w-full border p-2 rounded">
                    </div>
                    <div>
                        <label>Annual Charges</label>
                        <input type="number" id="edit_annual" name="annual_charges" class="w-full border p-2 rounded">
                    </div>
                    <div>
                        <label>Second Time Fee</label>
                        <input type="number" id="edit_second" name="second_time_fee" class="w-full border p-2 rounded">
                    </div>
                </div>

                <div class="mt-6 flex justify-end gap-3">
                    <button type="button" onclick="closeEditModal()" class="bg-gray-300 px-4 py-2 rounded">Cancel</button>
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded">Update</button>
                </div>
            </form>
        </div>
    </div>
<script>
    $('#downloadPdfBtn').on('click', function (e) {
        e.preventDefault();

        let student = $('#student-search').val();
        let classId = $('#class-search').val();

        let url = "{{ route('student.assign.fee.pdf') }}";
        let queryParams = [];

        if (student) queryParams.push('search=' + student);
        if (classId) queryParams.push('class_search=' + classId);

        if (queryParams.length > 0) {
            url += '?' + queryParams.join('&');
        }

        window.open(url, '_blank'); // open PDF in new tab
    });
</script>

    <script>
        function closeEditModal() {
            document.getElementById("editFeeModal").classList.add("hidden");
        }

        $(document).on('click', '.openEditModalBtn', function() {
            const modal = $('#editFeeModal');
            modal.removeClass('hidden');

            $('#edit_id').val($(this).data('id'));
            $('#edit_reg').val($(this).data('reg'));
            $('#edit_class').val($(this).data('class'));
            $('#edit_admission').val($(this).data('admission'));
            $('#edit_promotion').val($(this).data('promotion'));
            $('#edit_tuition').val($(this).data('tuition'));
            $('#edit_lab').val($(this).data('lab'));
            $('#edit_exam').val($(this).data('exam'));
            $('#edit_board').val($(this).data('board'));
            $('#edit_entertainment').val($(this).data('ent'));
            $('#edit_other').val($(this).data('other'));
            $('#edit_book').val($(this).data('book'));
            $('#edit_annual').val($(this).data('annual'));
            $('#edit_second').val($(this).data('second'));
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.select2').select2({
                width: '100%' // Ensure full width
            });
        });
        // Focus on the search field when the Select2 dropdown opens
        $(document).on('select2:open', function() {
            const searchField = $('.select2-search__field');
            if (searchField.length) {
                searchField[0].focus();
            }
        });

        $(document).on('click', '.pagination a', function(event) {
            event.preventDefault();
            let url = $(this).attr('href');

            $.ajax({
                url: url,
                type: "GET",
                success: function(data) {
                    $('#student-table').html(data);
                }
            });
        });
    </script>

    <script>
        $('#student-search').on('change', function() {
            let selectedStudent = $(this).val(); // Get the selected student value

            // Only trigger the AJAX call if a valid student is selected
            if (selectedStudent) {
                $.ajax({
                    url: "{{ route('student.assign.fee.edit') }}",
                    type: "GET",
                    data: {
                        search: selectedStudent // Send the selected student value in the AJAX request
                    },
                    success: function(data) {
                        $('#student-table').html(data); // Update the student table with the new data
                    }
                });
            }
        });

        $('#class-search').on('change', function() {
            let selectedClass = $(this).val(); // Get the selected student value

            // Only trigger the AJAX call if a valid student is selected
            if (selectedClass) {
                $.ajax({
                    url: "{{ route('student.assign.fee.edit') }}",
                    type: "GET",
                    data: {
                        class_search: selectedClass // Send the selected student value in the AJAX request
                    },
                    success: function(data) {
                        $('#student-table').html(data); // Update the student table with the new data
                    }
                });
            }
        });
    </script>
@endsection
