<table class="w-full border-collapse">
    <thead>
        <tr class="text-gray-700 bg-gray-50 text-sm">
            <th class="p-3 text-left font-semibold">Student</th>
            <th class="p-3 text-left font-semibold">Class</th>
            <th class="p-3 text-left font-semibold">Guardian Contact</th>
            <th class="p-3 text-left font-semibold">Date Of Birth</th>
            <th class="p-3 text-left font-semibold">Apply Type</th>
            <th class="p-3 text-center font-semibold">Status</th>
            <th class="p-3 text-center font-semibold">Actions</th>
        </tr>
    </thead>
    <tbody class="bg-white rounded-lg shadow">
        @forelse ($students as $student)
            <tr class="border-b hover:bg-blue-50 transition">
                <!-- Student Name & CNIC -->
                <td class="p-3 flex items-center gap-3">
                    <img src="{{ asset('assets/sidebar/student.png') }}" alt="Student"
                        class="w-10 h-10 rounded-full border border-gray-200 shadow-sm" />
                    <div>
                        <div class="font-semibold text-gray-800">{{ $student->full_name }}</div>
                        <div class="text-xs text-gray-500">{{ $student->cnic }}</div>
                    </div>
                </td>
                <!-- Class -->
                <td class="p-3 text-gray-700">{{ optional($student->classes)->name ?? '-' }}</td>
                <!-- Guardian Contact -->
                <td class="p-3 text-gray-700">
                    {{ $student->NewStudentApplicationGuardian->primary_contact ?? 'N/A' }}
                </td>
                <!-- Date Of Birth -->
                <td class="p-3 text-gray-700">{{ $student->dob }}</td>
                <!-- Apply Type -->
                <td class="p-3">
                    <span class="inline-block bg-blue-100 text-blue-700 px-2 py-0.5 rounded text-xs font-medium">
                        Online
                    </span>
                </td>
                <!-- Status -->
                <td class="p-3 text-center">
                    @if ($student->status == '1')
                        <span
                            class="bg-yellow-100 text-yellow-700 px-3 py-1 rounded-2xl text-xs font-semibold">Pending</span>
                    @elseif ($student->status == '2')
                        <span
                            class="bg-green-100 text-green-700 px-3 py-1 rounded-2xl text-xs font-semibold">Accepted</span>
                    @elseif ($student->status == '3')
                        <span
                            class="bg-red-100 text-red-700 px-3 py-1 rounded-2xl text-xs font-semibold">Rejected</span>
                    @else
                        <span
                            class="bg-gray-200 text-gray-700 px-3 py-1 rounded-2xl text-xs font-semibold">{{ $student->status }}</span>
                    @endif
                </td>
                <!-- Actions -->
                <td class="p-3 text-center relative">
                    <button onclick="toggleDropdown(this)"
                        class="action-btn px-2 py-1 rounded hover:bg-gray-100 focus:outline-none" title="Actions">
                        <img src="{{ asset('assets/actions.png') }}" alt="icons" class="w-5 h-5" />
                    </button>
                    <div
                        class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 shadow-lg rounded-lg border">
                        <a href="javascript:void(0)" onclick="updateStatus({{ $student->id }}, '2')"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-green-50 text-gray-700 text-sm">
                            <i class="fa-solid fa-check text-green-600"></i> Mark Accepted
                        </a>
                        <a href="javascript:void(0)" onclick="updateStatus({{ $student->id }}, '3')"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-red-50 text-gray-700 text-sm">
                            <i class="fa-solid fa-xmark text-red-600"></i> Mark Rejected
                        </a>
                        <a href="javascript:void(0)" onclick="updateStatus({{ $student->id }}, '1')"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-yellow-50 text-gray-700 text-sm">
                            <i class="fa-solid fa-clock text-yellow-600"></i> Mark Pending
                        </a>
                        <a href="{{ route('std.app.profile', $student->id) }}"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-blue-50 text-gray-700 text-sm">
                            <i class="fa-solid fa-eye text-blue-600"></i> View Details
                        </a>
                        <a href="{{ route('std.app.pass', $student->id) }}"
                            class="flex gap-x-2 items-center px-3 py-2 hover:bg-indigo-50 text-gray-700 text-sm">
                            <i class="fa-solid fa-user-check text-indigo-600"></i> Admit
                        </a>
                    </div>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="7" class="text-center text-gray-500 py-4">No student applications found.</td>
            </tr>
        @endforelse
    </tbody>
</table>
