@extends('schoolLayout.app')
@section('content')
    <style>
        label.error {
            color: red;
            font-size: 14px;
            display: inline-block;
            margin-left: 10px;
        }

        input.error {
            border: 1px solid red;
        }
    </style>

    <div class="w-full mx-auto bg-[#f9fafc] mt-10 bg-white p-8 rounded-lg shadow-md">
        <h2 class="text-2xl mb-6">New Student Admission Form</h2>

        <form action="{{ route('student.register') }}" method="POST" id="admForm" enctype="multipart/form-data">
            @csrf

            @include('successError')
            <!-- Student Details -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block mb-1">Session From<span class="text-red-600">*</span></label>
                    <input type="text" name="session_start"
                        class="w-full p-2 border rounded @error('session_start') border-red-500 @enderror"
                        value="{{ old('session_start', $start_year ?? date('Y', strtotime('-1 year'))) }}">
                    @error('session_start')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block mb-1">Session To<span class="text-red-600"></span></label>
                    <input type="text" name="session_end"
                        class="w-full p-2 border rounded @error('session_end') border-red-500 @enderror"
                        value="{{ old('session_end', $end_year ?? date('Y')) }}">
                    @error('session_end')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block mb-1">Student Name <span class="text-red-600">*</span></label>
                    <input type="text" id="student_name" name="student_name"
                        class="w-full p-2 border rounded @error('student_name') border-red-500 @enderror"
                        value="{{ old('student_name') }}">
                    @error('student_name')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Father's Name <span class="text-red-600">*</span></label>
                    <input type="text" name="father_name"
                        class="w-full p-2 border rounded @error('father_name') border-red-500 @enderror"
                        value="{{ old('father_name') }}">
                    @error('father_name')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Father CNIC <span class="text-red-600">*</span></label>
                    <input type="text" name="father_cnic"
                        class="w-full p-2 border rounded @error('father_cnic') border-red-500 @enderror"
                        value="{{ old('father_cnic') }}">
                    @error('father_cnic')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Email <span class="text-red-600">*</span></label>
                    <input type="email" id="email" name="email"
                        class="w-full p-2 border rounded @error('email') border-red-500 @enderror"
                        value="{{ old('email') }}">
                    @error('email')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Religion</label>
                    <select name="religion" class="w-full p-2 border rounded">
                        <option value="Islam" {{ old('religion') == 'Islam' ? 'selected' : '' }}>Islam</option>
                        <option value="Christianity" {{ old('religion') == 'Christianity' ? 'selected' : '' }}>Christianity
                        </option>
                        <option value="Hinduism" {{ old('religion') == 'Hinduism' ? 'selected' : '' }}>Hinduism</option>
                        <option value="Other" {{ old('religion') == 'Other' ? 'selected' : '' }}>Other</option>
                    </select>

                    @error('religion')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Mother's Name</label>
                    <input type="text" name="mother_name" class="w-full p-2 border rounded"
                        value="{{ old('mother_name') }}" />

                    @error('mother_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Gender <span class="text-red-600">*</span></label>
                    <select name="gender" class="w-full p-2 border rounded @error('gender') border-red-500 @enderror">
                        <option value="">Select Gender</option>
                        <option value="Male" {{ old('gender') == 'Male' ? 'selected' : '' }}>Male</option>
                        <option value="Female" {{ old('gender') == 'Female' ? 'selected' : '' }}>Female</option>
                        <option value="Other" {{ old('gender') == 'Other' ? 'selected' : '' }}>Other</option>
                    </select>
                    @error('gender')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>
                <!-- Place of Birth -->
                <div class=" ">
                    <label class="block mb-1">Place of Birth</label>
                    <input type="text" name="place_of_birth" class="w-full p-2 border rounded"
                        value="{{ old('place_of_birth') }}" />

                    @error('place_of_birth')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Date of Birth (Required) -->
                <div class=" ">
                    <label class="block mb-1">Date of Birth <span class="text-red-600">*</span></label>
                    <input type="date" name="date_of_birth" class="w-full p-2 border rounded"
                        value="{{ old('date_of_birth') }}" />

                    @error('date_of_birth')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Class Section -->
                <div>
                    <label class="block mb-1">Class</label>
                    <select name="class" class="w-full p-2 border rounded" id="class">
                        <option value="" disabled {{ old('class') == '' ? 'selected' : '' }}>Select Class</option>
                        @foreach ($classes as $index => $class)
                            <option value="{{ $class->id }}"
                                {{ old('class', $classes->first()->id) == $class->id ? 'selected' : '' }}>
                                {{ $class->name }}
                            </option>
                        @endforeach
                    </select>


                    @error('class')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Class Section -->
                <div>
                    <label class="block mb-1">Class Section</label>
                    <select name="class_section" class="w-full p-2 border rounded">
                        <option value="" disabled {{ old('class_section') == '' ? 'selected' : '' }}>Select Section
                        </option>
                        @foreach ($sections as $section)
                            <option value="{{ $section->id }}"
                                {{ old('class_section') == $section->id ? 'selected' : '' }}>
                                Section {{ $section->name }}
                            </option>
                        @endforeach
                    </select>

                    @error('class_section')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- <div>
                                                                                                                                                                                                        <label class="block mb-1">Monthly Fee</label>
                                                                                                                                                                                                        <input type="text" name="monthly_fee" class="w-full p-2 border rounded" value="{{ old('monthly_fee') }}" />

                                                                                                                                                                                                        @error('guardian_contact')
        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
    @enderror
                                                                                                                                                                                                    </div> -->

            </div>

            <div class="grid grid-cols-2 gap-x-2">
                <!-- Permanent Address -->
                <div class="mt-4">
                    <label class="block mb-1">Permanent Address<span class="text-red-600">*</span></label>
                    <textarea name="permanent_address" class="w-full p-2 border rounded">{{ old('permanent_address') }}</textarea>

                    @error('permanent_address')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <!-- Current Address -->
                <div class="mt-4">
                    <label class="block mb-1">Current Address</label>
                    <textarea name="current_address" class="w-full p-2 border rounded">{{ old('current_address') }}</textarea>
                </div>
            </div>

            <!-- Guardian Details -->
            <h3 class="text-xl mt-6 mb-3 font-semibold">Guardian Details</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <!-- Guardian Name (Required) -->
                <div>
                    <label class="block mb-1">Guardian Name <span class="text-red-600">*</span></label>
                    <input type="text" name="guardian_name" class="w-full p-2 border rounded"
                        value="{{ old('guardian_name') }}" />

                    @error('guardian_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Guardian Contact (Required) -->
                <div>
                    <label class="block mb-1">Guardian Contact <span class="text-red-600">*</span></label>
                    <input type="text" name="guardian_contact" class="w-full p-2 border rounded"
                        value="{{ old('guardian_contact') }}" />

                    @error('guardian_contact')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Student Relation with Guardian (Optional) -->
                <div>
                    <label class="block mb-1">Student Relation with Guardian</label>
                    <select name="guardian_relation" class="w-full p-2 border rounded">
                        <option value="" disabled {{ old('guardian_relation') == '' ? 'selected' : '' }}>Select
                            Relation</option>
                        <option value="Father" {{ old('guardian_relation') == 'Father' ? 'selected' : '' }}>Father
                        </option>
                        <option value="Mother" {{ old('guardian_relation') == 'Mother' ? 'selected' : '' }}>Mother
                        </option>
                        <option value="Brother" {{ old('guardian_relation') == 'Brother' ? 'selected' : '' }}>Brother
                        </option>
                        <option value="Sister" {{ old('guardian_relation') == 'Sister' ? 'selected' : '' }}>Sister
                        </option>
                        <option value="Uncle" {{ old('guardian_relation') == 'Uncle' ? 'selected' : '' }}>Uncle</option>
                        <option value="Aunt" {{ old('guardian_relation') == 'Aunt' ? 'selected' : '' }}>Aunt</option>
                        <option value="Grandfather" {{ old('guardian_relation') == 'Grandfather' ? 'selected' : '' }}>
                            Grandfather</option>
                        <option value="Grandmother" {{ old('guardian_relation') == 'Grandmother' ? 'selected' : '' }}>
                            Grandmother</option>
                        <option value="Other" {{ old('guardian_relation') == 'Other' ? 'selected' : '' }}>Other</option>
                    </select>

                    @error('guardian_relation')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Previous Education -->
            <!-- Toggle Button -->
            <div class="flex items-center space-x-3 mt-6 mb-3">
                <h3 class="text-xl font-semibold">Previous Education Details</h3>
                <button id="toggleBtn" type="button"
                    class="relative w-14 h-7 bg-gray-300 rounded-full transition-colors duration-300 focus:outline-none">
                    <span id="toggleCircle"
                        class="absolute left-1 top-1 w-5 h-5 bg-white rounded-full transition-transform duration-300"></span>
                </button>
            </div>

            <!-- Previous Education Fields -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 hidden" id="previous-education">
                <!-- Previous School Name (Required) -->
                <div>
                    <label class="block mb-1">Previous School Name <span class="text-red-600">*</span></label>
                    <input type="text" name="previous_education[school_name]" class="w-full p-2 border rounded"
                        value="{{ old('previous_education.school_name') }}" />
                    @error('previous_education.school_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Last Class Passed (Required) -->
                <div>
                    <label class="block mb-1">Last Class Passed <span class="text-red-600">*</span></label>
                    <select name="previous_education[last_class_passed]" class="w-full p-2 border rounded">
                        <option value="" disabled
                            {{ old('previous_education.last_class_passed') == '' ? 'selected' : '' }}>Select Last Class
                        </option>
                        @foreach (['Nursery', 'KG', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'] as $class)
                            <option value="{{ $class }}"
                                {{ old('previous_education.last_class_passed') == $class ? 'selected' : '' }}>Class
                                {{ $class }}</option>
                        @endforeach
                    </select>
                    @error('previous_education.last_class_passed')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Class to Apply (Required) -->
                <div>
                    <label class="block mb-1">Class to Apply <span class="text-red-600">*</span></label>
                    <select name="previous_education[class_to_apply]" class="w-full p-2 border rounded">
                        <option value="" disabled
                            {{ old('previous_education.class_to_apply') == '' ? 'selected' : '' }}>Select Class</option>
                        @foreach (['Nursery', 'KG', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'] as $class)
                            <option value="{{ $class }}"
                                {{ old('previous_education.class_to_apply') == $class ? 'selected' : '' }}>Class
                                {{ $class }}</option>
                        @endforeach
                    </select>
                    @error('previous_education.class_to_apply')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>



                <!-- Last Result Grade/Percentage -->
                <div>
                    <label class="block mb-1">Last Result Grade/Percentage</label>
                    <input type="text" name="previous_education[last_result]" class="w-full p-2 border rounded"
                        value="{{ old('previous_education.last_result') }}" />
                    @error('previous_education.last_result')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Passing Year (Required) -->
                <div>
                    <label class="block mb-1">Passing Year <span class="text-red-600">*</span></label>
                    <input type="text" name="previous_education[passing_year]" class="w-full p-2 border rounded"
                        value="{{ old('previous_education.passing_year') }}" />
                    @error('previous_education.passing_year')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>


            <!-- Emergency Contact -->
            <h3 class="text-xl font-semibold mt-6 mb-3">Emergency Contact</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block mb-1">Emergency Contact Name<span class="text-red-600">*</span></label>
                    <input type="text" name="emergency_contact_name" value="{{ old('emergency_contact_name') }}"
                        class="w-full p-2 border rounded" />
                    @error('emergency_contact_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Emergency Contact Number<span class="text-red-600">*</span></label>
                    <input name="emergency_contact_number" value="{{ old('emergency_contact_number') }}" type="text"
                        class="w-full p-2 border rounded" />
                    @error('emergency_contact_number')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Relationship<span class="text-red-600">*</span></label>
                    <input name="relationship" value="{{ old('relationship') }}" type="text"
                        class="w-full p-2 border rounded" />
                    @error('relationship')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Medical Information -->
            <h3 class="text-xl font-semibold mb-3 mt-6">Medical Information</h3>
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block mb-1">Existing Medical Conditions</label>
                    <textarea name="medical_conditions" class="w-full p-2 border rounded h-20">{{ old('medical_conditions') }}</textarea>

                    @error('medical_conditions')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Blood Group</label>
                    <select name="blood_group" class="w-full p-2 border rounded">
                        <option value="" disabled {{ old('blood_group') == '' ? 'selected' : '' }}>Select Blood
                            Group</option>
                        <option value="A+" {{ old('blood_group') == 'A+' ? 'selected' : '' }}>A+</option>
                        <option value="A-" {{ old('blood_group') == 'A-' ? 'selected' : '' }}>A-</option>
                        <option value="B+" {{ old('blood_group') == 'B+' ? 'selected' : '' }}>B+</option>
                        <option value="B-" {{ old('blood_group') == 'B-' ? 'selected' : '' }}>B-</option>
                        <option value="O+" {{ old('blood_group') == 'O+' ? 'selected' : '' }}>O+</option>
                        <option value="O-" {{ old('blood_group') == 'O-' ? 'selected' : '' }}>O-</option>
                        <option value="AB+" {{ old('blood_group') == 'AB+' ? 'selected' : '' }}>AB+</option>
                        <option value="AB-" {{ old('blood_group') == 'AB-' ? 'selected' : '' }}>AB-</option>
                    </select>

                    @error('blood_group')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

            </div>

            <!-- Fee Assign -->
            <h3 class="text-xl font-semibold mt-6 mb-3 hidden" id="fee_assign_txt">Fee Assign</h3>
            <div id="fee_checkbox" class="flex flex-wrap gap-x-6 text-xl gap-y-8 ">

            </div>
            <h3 class="text-xl font-semibold mt-6 mb-3">Payments</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">

                <div>
                    <label name="discount" class="block mb-1">Total Amount</label>
                    <span id="payable_amount" class="text-blue-700 font-semibold text-sm">0.00</span>
                </div>
                <div>
                    <label name="discount" class="block mb-1">Discount</label>
                    <input onkeyup="calculate_discounted(this.value)" type="number" id="discount" name="discount"
                        class="w-full p-2 border rounded" value="{{ old('discount') }}" />
                    @error('discount')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block mb-1">Net Amount</label>
                    <input type="number" id="net_amount" readonly name="net_amount" class="w-full p-2 border rounded"
                        value="{{ old('net_amount') }}" />
                    @error('net_amount')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

            </div>
            <!-- Document Uploads -->
            <h3 class="text-xl font-semibold mt-6 mb-3">Documents Required</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <!-- Student Photo Upload -->
                <div>
                    <label class="block mb-1">Student Photo</label>
                    <label
                        class="w-full flex flex-col h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500"
                        id="uploadContainer">
                        <!-- Default upload icon (hidden when image is selected) -->
                        <div id="uploadIcon">
                            <img src="{{ asset('assets/upload.png') }}" alt="icon" />
                            <span class="text-sm text-gray-500 mt-2">
                                Drag and drop your photo here, or <span class="text-black">browse</span>
                            </span>
                            <span class="text-xs text-gray-400 mt-1">Supported formats: JPG, PNG (Max: 5MB)</span>
                        </div>

                        <!-- Preview image (hidden by default) -->
                        <img id="imagePreview" class="hidden h-full object-cover rounded" />

                        <input type="file" name="student_photo" id="studentPhoto" class="hidden"
                            accept="image/png, image/jpeg" />
                    </label>
                    @error('student_photo')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>


                <!-- Birth Certificate Upload with Preview -->
                <div>
                    <label class="block mb-1">Birth Certificate OR Form-B</label>
                    <label
                        class="w-full flex flex-col h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500"
                        id="birthCertContainer">
                        <!-- Default upload UI -->
                        <div id="birthCertUploadIcon">
                            <img src="{{ asset('assets/upload.png') }}" alt="icon" />
                            <span class="text-sm text-gray-500 mt-2">
                                Upload Birth Certificate, or <span class="text-black">browse</span>
                            </span>
                            <span class="text-xs text-gray-400 mt-1">Supported formats: PDF, JPG, PNG (Max: 10MB)</span>
                        </div>

                        <!-- Preview container -->
                        <div id="birthCertPreview" class="hidden w-full h-full flex-col items-center justify-center">
                            <div id="pdfPreview" class="hidden flex-col items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-red-500" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                </svg>
                                <span id="pdfFileName"
                                    class="mt-2 text-sm font-medium text-gray-700 truncate w-full px-4 text-center"></span>
                            </div>
                            <img id="birthCertImagePreview" class="hidden h-full object-contain rounded" />
                        </div>

                        <input type="file" name="birth_certificate" id="birthCertificate" class="hidden"
                            accept="image/png, image/jpeg, application/pdf" />
                    </label>
                    @error('birth_certificate')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>


                <!-- Previous School Leaving Certificate Upload with Preview -->
                <div>
                    <label class="block mb-1">Previous School Leaving Certificate</label>
                    <label
                        class="w-full flex flex-col h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500"
                        id="leavingCertContainer">
                        <!-- Default upload UI -->
                        <div id="leavingCertUploadIcon">
                            <img src="{{ asset('assets/upload.png') }}" alt="icon" />
                            <span class="text-sm text-gray-500 mt-2">
                                Upload Leaving Certificate, or <span class="text-black">browse</span>
                            </span>
                            <span class="text-xs text-gray-400 mt-1">Supported formats: PDF, JPG, PNG (Max: 10MB)</span>
                        </div>

                        <!-- Preview container -->
                        <div id="leavingCertPreview" class="hidden w-full h-full flex-col items-center justify-center">
                            <div id="leavingCertPdfPreview" class="hidden flex-col items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-red-500" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                </svg>
                                <span id="leavingCertPdfFileName"
                                    class="mt-2 text-sm font-medium text-gray-700 truncate w-full px-4 text-center"></span>
                            </div>
                            <img id="leavingCertImagePreview" class="hidden h-full object-contain rounded" />
                        </div>

                        <input type="file" name="leaving_certificate" id="leavingCertificate" class="hidden"
                            accept="image/png, image/jpeg, application/pdf" />
                    </label>
                    @error('leaving_certificate')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>


                <div class="flex justify-end gap-x-4 items-center">
                    <div class="text-center mt-6">
                        <a class="border border-gray-400 text-black px-6 py-2 rounded-lg hover:bg-blue-700"
                            href="{{ route('student.currentStudent') }}">
                            Cancel
                        </a>
                    </div>
                    <div class="text-center mt-6">
                        <button id="submitBtn" type="submit"
                            class="bg-[#0197FF] text-white px-6 py-2 rounded-lg hover:bg-blue-700 disabled:bg-gray-400 disabled:cursor-not-allowed">
                            Submit Application
                        </button>
                    </div>
                </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {
            // Custom validation methods
            $.validator.addMethod("pakPhone", function(value, element) {
                return this.optional(element) || /^03\d{9}$/.test(value);
            }, "Must be 11 digits starting with 03");

            $.validator.addMethod("validCNIC", function(value, element) {
                return this.optional(element) || /^\d{13}$/.test(value);
            }, "CNIC must be 13 digits (no dashes)");

            $("#admForm").validate({
                rules: {
                    session_start: {
                        required: true,
                        minlength: 4
                    },
                    session_end: {
                        required: true,
                        minlength: 4
                    },
                    student_name: {
                        required: true,
                        minlength: 3
                    },
                    father_name: {
                        required: true,
                        minlength: 3
                    },
                    father_cnic: {
                        required: true,
                        validCNIC: true
                    },
                    email: {
                        required: true,
                        email: true
                    },
                    religion: {
                        required: true
                    },

                    gender: {
                        required: true
                    },

                    date_of_birth: {
                        required: true
                    },
                    class: {
                        required: true
                    },
                    class_section: {
                        required: true
                    },
                    permanent_address: {
                        required: true,
                        minlength: 3
                    },

                    guardian_name: {
                        required: true,
                        minlength: 3
                    },
                    guardian_contact: {
                        required: true,
                        pakPhone: true,
                        minlength: 11,
                        maxlength: 11
                    },
                    guardian_relation: {
                        required: true
                    },
                    emergency_contact_name: {
                        required: true,
                        minlength: 3
                    },
                    emergency_contact_number: {
                        required: true,
                        pakPhone: true,
                        minlength: 11,
                        maxlength: 11
                    },
                    relationship: {
                        required: true
                    },

                },
                messages: {
                    session_start: {
                        required: "Enter Start Session",
                        minlength: "Must be at least 4 characters"
                    },
                    session_end: {
                        required: "Enter End Session",
                        minlength: "Must be at least 4 characters"
                    },
                    student_name: {
                        required: "Enter Student Name",
                        minlength: "At least 3 characters required"
                    },
                    father_name: {
                        required: "Enter Father Name",
                        minlength: "At least 3 characters required"
                    },
                    father_cnic: {
                        required: "Enter Father CNIC",
                        validCNIC: "Must be 13 digits (no dashes)"
                    },
                    email: {
                        required: "Enter Email",
                        email: "Enter a valid email address"
                    },
                    religion: {
                        required: "Select Religion"
                    },

                    gender: {
                        required: "Select Gender"
                    },

                    date_of_birth: {
                        required: "Enter Date of Birth"
                    },
                    class: {
                        required: "Select Class"
                    },
                    class_section: {
                        required: "Select Section"
                    },
                    permanent_address: {
                        required: "Enter Permanent Address",
                        minlength: "At least 3 characters required"
                    },

                    guardian_name: {
                        required: "Enter Guardian Name",
                        minlength: "At least 3 characters required"
                    },
                    guardian_contact: {
                        required: "Enter Guardian Contact",
                        minlength: "Must be 11 digits",
                        maxlength: "Must be 11 digits",
                        pakPhone: "Must start with 03 and be 11 digits"
                    },
                    guardian_relation: {
                        required: "Select Guardian Relation"
                    },
                    emergency_contact_name: {
                        required: "Enter Emergency Contact Name",
                        minlength: "At least 3 characters required"
                    },
                    emergency_contact_number: {
                        required: "Enter Emergency Contact",
                        minlength: "Must be 11 digits",
                        maxlength: "Must be 11 digits",
                        pakPhone: "Must start with 03 and be 11 digits"
                    },
                    relationship: {
                        required: "Select Relationship"
                    },

                },
                errorPlacement: function(error, element) {
                    error.insertAfter(element);
                },
                highlight: function(element) {
                    $(element).addClass('error');
                },
                unhighlight: function(element) {
                    $(element).removeClass('error');
                }
            });
        });
    </script>
    <script>
        document.getElementById('studentPhoto').addEventListener('change', function(e) {
            const file = e.target.files[0];
            const preview = document.getElementById('imagePreview');
            const uploadIcon = document.getElementById('uploadIcon');
            const container = document.getElementById('uploadContainer');

            if (file) {
                // Validate file type
                const validTypes = ['image/jpeg', 'image/png'];
                if (!validTypes.includes(file.type)) {
                    alert('Only JPG/PNG files are allowed!');
                    return;
                }

                // Validate file size (5MB max)
                if (file.size > 5 * 1024 * 1024) {
                    alert('File size must be less than 5MB!');
                    return;
                }

                // Create preview
                const reader = new FileReader();
                reader.onload = function(event) {
                    preview.src = event.target.result;
                    preview.classList.remove('hidden');
                    uploadIcon.classList.add('hidden');
                    container.classList.remove('h-28'); // Adjust container height
                    container.classList.add('h-64'); // Larger container for image
                }
                reader.readAsDataURL(file);
            } else {
                preview.classList.add('hidden');
                uploadIcon.classList.remove('hidden');
                container.classList.remove('h-64');
                container.classList.add('h-28');
            }
        });
    </script>

    <script>
        document.getElementById('birthCertificate').addEventListener('change', function(e) {
            const file = e.target.files[0];
            const container = document.getElementById('birthCertContainer');
            const uploadIcon = document.getElementById('birthCertUploadIcon');
            const previewContainer = document.getElementById('birthCertPreview');
            const pdfPreview = document.getElementById('pdfPreview');
            const pdfFileName = document.getElementById('pdfFileName');
            const imagePreview = document.getElementById('birthCertImagePreview');

            if (file) {
                // Validate file type
                const validTypes = ['image/jpeg', 'image/png', 'application/pdf'];
                if (!validTypes.includes(file.type)) {
                    alert('Only PDF, JPG, and PNG files are allowed!');
                    this.value = ''; // Clear the file input
                    return;
                }

                // Validate file size (10MB max)
                if (file.size > 10 * 1024 * 1024) {
                    alert('File size must be less than 10MB!');
                    this.value = ''; // Clear the file input
                    return;
                }

                // Show preview
                uploadIcon.classList.add('hidden');
                previewContainer.classList.remove('hidden');
                container.classList.remove('h-28');
                container.classList.add('h-64');

                if (file.type === 'application/pdf') {
                    // Handle PDF preview
                    pdfPreview.classList.remove('hidden');
                    imagePreview.classList.add('hidden');
                    pdfFileName.textContent = file.name;
                } else {
                    // Handle image preview
                    pdfPreview.classList.add('hidden');
                    imagePreview.classList.remove('hidden');

                    const reader = new FileReader();
                    reader.onload = function(event) {
                        imagePreview.src = event.target.result;
                    }
                    reader.readAsDataURL(file);
                }
            } else {
                // Reset to default state
                uploadIcon.classList.remove('hidden');
                previewContainer.classList.add('hidden');
                container.classList.remove('h-64');
                container.classList.add('h-28');
            }
        });
    </script>

    <script>
        document.getElementById('leavingCertificate').addEventListener('change', function(e) {
            const file = e.target.files[0];
            const container = document.getElementById('leavingCertContainer');
            const uploadIcon = document.getElementById('leavingCertUploadIcon');
            const previewContainer = document.getElementById('leavingCertPreview');
            const pdfPreview = document.getElementById('leavingCertPdfPreview');
            const pdfFileName = document.getElementById('leavingCertPdfFileName');
            const imagePreview = document.getElementById('leavingCertImagePreview');

            if (file) {
                // Validate file type
                const validTypes = ['image/jpeg', 'image/png', 'application/pdf'];
                if (!validTypes.includes(file.type)) {
                    alert('Only PDF, JPG, and PNG files are allowed!');
                    this.value = ''; // Clear the file input
                    return;
                }

                // Validate file size (10MB max)
                if (file.size > 10 * 1024 * 1024) {
                    alert('File size must be less than 10MB!');
                    this.value = ''; // Clear the file input
                    return;
                }

                // Show preview
                uploadIcon.classList.add('hidden');
                previewContainer.classList.remove('hidden');
                container.classList.remove('h-28');
                container.classList.add('h-64');

                if (file.type === 'application/pdf') {
                    // Handle PDF preview
                    pdfPreview.classList.remove('hidden');
                    imagePreview.classList.add('hidden');
                    pdfFileName.textContent = file.name;
                } else {
                    // Handle image preview
                    pdfPreview.classList.add('hidden');
                    imagePreview.classList.remove('hidden');

                    const reader = new FileReader();
                    reader.onload = function(event) {
                        imagePreview.src = event.target.result;
                    }
                    reader.readAsDataURL(file);
                }
            } else {
                // Reset to default state
                uploadIcon.classList.remove('hidden');
                previewContainer.classList.add('hidden');
                container.classList.remove('h-64');
                container.classList.add('h-28');
            }
        });
    </script>
@endsection
@section('script')
    <script>
        const toggleBtn = document.getElementById("toggleBtn");
        const toggleCircle = document.getElementById("toggleCircle");
        const previous_education = document.getElementById('previous-education');
        previous_education.classList.add('hidden')
        toggleBtn.addEventListener("click", () => {
            toggleBtn.classList.toggle("bg-green-500");
            toggleCircle.classList.toggle("translate-x-7");
            previous_education.classList.toggle('hidden');
        });

        const classSelect = document.getElementById('class');
        const feeCheckbox = document.getElementById('fee_checkbox');
        const feeStructures = @json($fee_structures);
        window.onload = () => {
            showCheckbox(feeStructures, classSelect.value);
        };
        classSelect.addEventListener('change', (e) => {
            totalAmount = 0; // Reset total amount
            document.getElementById("payable_amount").innerText = "0.00";
            document.getElementById("net_amount").value = "0.00";
            document.getElementById("discount").value = 0;

            showCheckbox(feeStructures, e.target.value);

        });

        function showCheckbox(feeStructures, classId) {
            let html = '';

            feeStructures.forEach(fee => {
                document.querySelector('button[type="submit"]').disabled = true;
                if (fee.class_id == classId) {
                    let formattedFeeType = formatFeeType(fee.fee_type); // Format the fee type
                    html += `
                <label class="flex items-center space-x-4">
                    <input type="checkbox" onclick="calculate(this)" name="fee_assign[]" value="${fee.id}" class="w-5 h-5 text-blue-600 border-gray-300 rounded ">
                    <div class="text-md flex items-center gap-2">
                        <p>${formattedFeeType}</p>
                        <input type="number" name="fee_amount[${fee.id}]" value="${fee.amount}" min="0" step="0.01"
                            class="w-24 p-1 border rounded text-blue-700 font-semibold text-sm fee-amount-input" onchange="calculate(null, this)" />
                    </div>
                </label>
            `;


                }
            });

            if (html) {
                document.getElementById('fee_assign_txt').classList.remove('hidden');
                feeCheckbox.innerHTML = html;
            } else {
                document.getElementById('fee_assign_txt').classList.add('hidden');
                feeCheckbox.innerHTML =
                    '<p class="text-red-500">No fee structure available. Add fees before admitting students.</p>';
            }
        }

        // Function to format fee type (replace underscores and capitalize first word)
         function formatFeeType(feeType) {
            let words = feeType.replace(/_/g, ' ').split(' ');
            words[0] = words[0].charAt(0).toUpperCase() + words[0].slice(1);
        
            let formatted = words.join(' ');
        
            if (words[0] === 'Tuition' && words[1]?.toLowerCase() === 'fee') {
                formatted += ' (monthly fee)';
            }
        
            return formatted;
        }

        let totalAmount = 0; // Initialize total amount
        function calculate(checkbox = null, amountInput = null) {
            let totalAmount = 0;
            const checkboxes = document.querySelectorAll('input[name="fee_assign[]"]');
            checkboxes.forEach(cb => {
                if (cb.checked) {
                    const feeId = cb.value;
                    const amountElem = document.querySelector(`input[name="fee_amount[${feeId}]"]`);
                    let amount = parseFloat(amountElem.value) || 0;
                    totalAmount += amount;
                }
            });
            // Show total before discount
            document.getElementById("payable_amount").innerText = totalAmount.toFixed(2);

            // Apply discount for net amount
            let discount = parseFloat(document.getElementById("discount").value) || 0;
            let netAmount = totalAmount - discount;
            if (netAmount < 0) netAmount = 0;
            document.getElementById("net_amount").value = netAmount.toFixed(2);

            // Enable/disable submit button
            let atLeastOneChecked = Array.from(checkboxes).some(cb => cb.checked);
            document.getElementById("submitBtn").disabled = !atLeastOneChecked;
        }

        function calculate_discounted(discount) {
            calculate();
        }
    </script>
@endsection
