@extends('schoolLayout.app')
@section('content')
@include('successError')
<div class="bg-[#f9fafc] min-h-screen px-8 py-8">
      <div class="flex justify-between items-center">
        <!-- Tabs:-->
        <div class="flex space-x-4 w-full border-b border-gray-200 mb-8">
          <button
          onclick="window.location.href='{{ route('show.attendance') }}'"
            class="tab-btn px-4 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500"
          >
            Staff Attendance
          </button>
          <!-- <button 
          onclick="window.location.href='{{ route('attendance.report') }}'"
          class="tab-btn pb-3 text-gray-700 font-semibold">
            Attendance Report
          </button> -->
        </div>
      </div>
      <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-5 gap-4">
        <!-- Total Students -->
        <div
          class="flex items-center p-4 border border-[#E5E7EB] rounded-lg shadow-sm bg-white"
        >
          <div
            class="w-12 h-12 flex items-center justify-center bg-[#DBEAFE] text-white rounded-xl"
          >
            <i class="fas fa-users text-xl text-[#1B9AF5]"></i>
          </div>
          <div class="ml-4">
            <h4 class="text-sm font-semibold text-[#6B7280]">Total Staff</h4>
            <p class="text-gray-700 text-xl font-bold">{{$total}}</p>
          </div>
        </div>

        <!-- Present -->
        <div
          class="flex items-center p-4 border border-[#BBF7D0] rounded-lg shadow-sm bg-[#f0fdf4]"
        >
          <div
            class="w-12 h-12 flex items-center justify-center bg-[#DCFCE7] text-[#16A34A] rounded-xl"
          >
            <i class="fa-solid fa-check text-xl"></i>
          </div>
          <div class="ml-4">
            <h4 class="text-sm font-semibold text-[#16A34A]">Present</h4>
            <p class="text-gray-700 text-xl font-bold">{{$presentCount}}</p>
          </div>
        </div>

        <!-- Absent -->
        <div
          class="flex items-center p-4 border border-[#FECACA] rounded-lg shadow-sm bg-[#fef2f2]"
        >
          <div
            class="w-12 h-12 flex items-center justify-center bg-[#FEE2E2] text-[#DC2626] rounded-xl"
          >
            <i class="fa-solid fa-xmark text-xl"></i>
          </div>
          <div class="ml-4">
            <h4 class="text-sm font-semibold text-[#DC2626]">Absent</h4>
            <p class="text-gray-700 text-xl font-bold">{{$absentCount}}</p>
          </div>
        </div>

        <div
          class="flex items-center p-4 border border-[#FEF08A] rounded-lg shadow-sm bg-[#fefbe8]"
        >
          <div
            class="w-12 h-12 flex items-center justify-center bg-[#FEF9C3] text-[#CA8A04] rounded-xl"
          >
            <i class="fa-solid fa-right-from-bracket text-xl"></i>
          </div>
          <div class="ml-4">
            <h4 class="text-sm font-semibold text-[#CA8A04]">Checked In</h4>
            <p class="text-gray-700 text-xl font-bold">{{$checkInCount}}</p>
          </div>
        </div>
        <div
          class="flex items-center p-4 border border-[#D0ACF8] rounded-lg shadow-sm bg-[#fbf5ff]"
        >
          <div
            class="w-12 h-12 flex items-center justify-center bg-[#F3E8FF] text-[#9333EA] rounded-xl"
          >
            <i class="fa-solid fa-right-from-bracket text-xl"></i>
          </div>
          <div class="ml-4">
            <h4 class="text-sm font-semibold text-[#9333EA]">Checked Out</h4>
            <p class="text-gray-700 text-xl font-bold">{{$checkOutCount}}</p>
          </div>
        </div>
      </div>

      <div class="bg-white my-8 rounded-lg">
      <form method="GET" action="{{ route('staff.attend.get') }}">
        <div class="flex p-3 justify-between items-center gap-4">
          <div class="relative w-[40%] rounded-lg">
            <div
              class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
              <span class="text-gray-500">
                <img src="{{ asset('assets/search.png') }}" alt="icon" />
              </span>
              <input type="text" name="search" id="search-input" value="{{ request('search') }}"
                  placeholder="Search Student..."
                  class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none" />
            </div>
          </div>
           
        </div>
      </form>
        <div class="mt-4 relative">
          <table class="w-full bg-white border-gray-300">
            <thead class="bg-[#f9fafc]">
              <tr class="text-left text-gray-500 font-medium">
                <th class="p-3 text-gray-500 font-medium">Staff</th>
                <th class="p-3 text-gray-500 font-medium">Staff ID</th>
                <th class="p-3 text-gray-500 font-medium">Check-in Time</th>
                <th class="p-3 text-gray-500 font-medium">Check-out Time</th>
                <th class="p-3 text-gray-500 font-medium">Attendance</th>
                <th class="p-3 text-gray-500 font-medium">Status</th>
                 <th class="p-3 text-gray-500 font-medium">Action</th>
              </tr>
            </thead>
            <tbody>
              <!-- Row 1 -->
              <form method="POST" action="{{ route('staff.attend.store') }}">
              @csrf
              @if($staffAttend->isEmpty())
              <tr class="border-b">
                <td colspan="8" class="p-3 text-center text-gray-500">No students found.</td>
              </tr>
              @else 
              @foreach ($staffAttend as $staff)
              <tr class="border-b">
                <td class="p-3 flex items-center space-x-3">
                  <img
                    src="{{ $staff->profile_photo && $staff->profile_photo ? asset('storage/' . $staff->profile_photo) : asset('assets/sidebar/student.png') }}"

                    alt="Student"
                    class="w-10 h-10 rounded-full"
                  />
                  <div>
                    <p class="font-medium">{{$staff->full_name}}</p>
                   </div>
                </td>
                <td class="p-3 text-gray-600">{{$staff->registration_no}}</td>
                <td class="p-3 text-gray-600">
                  <input type="time" name="check_in[{{ $staff->id }}]" class="form-control"  value="{{ $formData['check_in'][$staff->id] ?? '' }}">
                </td>
                <td class="p-3 text-gray-600">
                  <input type="time" name="check_out[{{ $staff->id }}]" class="form-control"  value="{{ $formData['check_out'][$staff->id] ?? '' }}">
                </td>
                <td class="p-3">
                  <div class="flex flex-wrap gap-x-4">
                  @foreach (['Present', 'Absent', 'Leave', 'Half Day'] as $status)
                      <label class="flex text-gray-700 items-center space-x-1">
                          <input type="radio" name="attendance[{{ $staff->id }}]"
                              value="{{ $status }}" class="w-4 h-4"
                              {{ isset($attendances[$staff->id]) && strtolower(str_replace(' ', '_', $attendances[$staff->id]->status)) === strtolower(str_replace(' ', '_', $status)) ? 'checked' : ($status === 'Present' ? 'checked' : '') }} />
                          <span>{{ $status }}</span>
                      </label>
                  @endforeach
                  </div>
                </td>
                <td class="p-3 text-gray-600">
                  <span
                    class="bg-[#DCFCE7] font-semibold text-[#166534] px-2 py-0.5 rounded-2xl text-sm"
                  >
                    Present
                  </span>
                </td>
                <td class="p-3 text-center relative">
                  <!-- <div class="flex gap-x-5 items-center"> -->
                  <button onclick="event.preventDefault();toggleDropdown(this)" class="action-btn">
                      <img src="{{ asset('assets/actions.png') }}" alt="icons" />
                  </button>
                  <!-- </div> -->
                  <div
                      class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 shadow-lg rounded-lg border">
                      <a href="{{ route('staff.attend.show', $staff->id) }}"
                          class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Attendance
                          History</a>
                      <!-- <a href="#" class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Struck off</a> -->
                      <a href=""
                          class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">View
                          Profile</a>
                  </div>
                </td>
              </tr>
              @endforeach   
             
              @endif
            </tbody>
          </table>
          <div class="flex bg-white border-t border-gray-200 justify-between items-center p-4">
                    <div></div> <!-- Empty left side -->

                    <div class="flex space-x-2">

                        <input type="submit" name="submit" value="Submit Attendance"
                            class="bg-[#0197FF] text-white min-w-[80px] text-md rounded-lg px-2 py-2 text-nowrap mt-4 cursor-pointer" />
                    </div>
                </div>
                </form>
        </div>
      </div>
    </div>
@endsection
