<!DOCTYPE html>
<html>
<head>
    <title>Staff Ledger PDF</title>
    <style>
        body { font-family: sans-serif; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: left; font-size: 12px; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h2>Staff Ledger</h2>
    <p><strong>Reg No:</strong> {{ $regNo }}</p>
    <p><strong>Staff Name:</strong> {{ $staffName }}</p>
    <p><strong>Father Name:</strong> {{ $fthName }}</p>
    <p><strong>CNIC:</strong> {{ $cnic }}</p>
    <p><strong>Date Range:</strong> {{ $start_date }} to {{ $end_date }}</p>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Type</th>
                <th>Description</th>
                <th>Debit</th>
                <th>Credit</th>
                <th>Balance</th>
            </tr>
        </thead>
        <tbody>
            @php
                $total = $staffOpenBalance;
                $totalDebit = 0;
                $totalCredit = 0;
            @endphp
            <tr>
                <td colspan="5"><strong>Opening Balance</strong></td>
                <td><strong>{{ number_format($staffOpenBalance, 2) }}</strong></td>
            </tr>
            @foreach($staffLedger as $item)
                @php
                    $total += $item->debit - $item->credit;
                    $totalDebit += $item->debit;
                    $totalCredit += $item->credit;
                @endphp
                <tr>
                    <td>{{ \Carbon\Carbon::parse($item->created_at)->format('Y-m-d') }}</td>
                    <td>{{ $item->transaction_type ?? '-' }}</td>
                    <td>{{ $item->remarks ?? '-' }}</td>
                    <td>{{ $item->debit > 0 ? number_format($item->debit, 2) : '' }}</td>
                    <td>{{ $item->credit > 0 ? number_format($item->credit, 2) : '' }}</td>
                    <td>{{ number_format($total, 2) }}</td>
                </tr>
            @endforeach
            <tr>
                <td colspan="3"><strong>Total</strong></td>
                <td><strong>{{ number_format($totalDebit, 2) }}</strong></td>
                <td><strong>{{ number_format($totalCredit, 2) }}</strong></td>
                <td><strong>{{ number_format($total, 2) }}</strong></td>
            </tr>
        </tbody>
    </table>
</body>
</html>
