@extends('schoolLayout.app')
@section('content')
    <div class="bg-[#f9fafc] min-h-screen px-8 py-4">
        @include('successError')
        <div class="flex justify-between items-center">
            <div class="flex space-x-4 border-b border-gray-200 w-[50%]">
                <button class="tab-btn pb-3 text-gray-700 font-semibold"
                    onclick="window.location.href='{{ route('staff') }}'">
                    Current Staffs
                </button>
                <button class="tab-btn px-4 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Past Staffs
                </button>
            </div>
            <div class="flex gap-x-4">
                <button class="bg-[#0197FF] px-4 py-2 hover:bg-blue-600 text-white rounded-lg"
                    onclick="window.location.href = '{{ route('staff.past.pdf') }}'">
                    <span>PDF</span>
                </button>
                <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-lg"
                    onclick="window.location.href = '{{ route('staff.create') }}'">
                    <img src="{{ asset('assets/new.png') }}" alt="icon" />
                    <span>New Staff</span>
                </button>
            </div>
        </div>

        <div class="border border-gray-200 rounded-lg mt-4">
            <!-- Filters Section -->
            <div class="bg-white p-3 flex justify-between rounded-lg flex-wrap gap-4">
                <div class="relative  w-[50%] rounded-lg">
                    <div class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
                        <span class="text-gray-500">
                            <img src="{{ asset('assets/search.png') }}" alt="icon" />
                        </span>
                        <input type="text" name="search_query" id="search" placeholder="Search Staff..."
                            onkeyup="fetchStaffData()"
                            class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none" />
                    </div>
                </div>
                <div class="flex gap-x-2 items-center">

                </div>
            </div>
            <div class=" relative ">
                <span id="staff-members">
                    @include('staff.partialPastStaff', [
                        'staff' => $staff,
                    ])
                </span>
                @if (isset($staff) && $staff->count())
                    {{ $staff->links('vendor.pagination.custom-pagination') }}
                @endif

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        function toggleDropdown(button) {
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            button.nextElementSibling.classList.toggle("hidden");
        }

        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });

        // search Student Functionality
        function fetchStaffData() {

            let search = document.getElementById("search").value;

            $.ajax({
                url: "{{ route('staff.past') }}",
                method: "GET",
                data: {
                    search_query: search,
                },
                success: function(response) {
                    $('#staff-members').html(response);
                }
            });
        }


        function updateStatus(staffId, el) {
            if (!confirm('Change status from resigned to active?')) return;
            $.ajax({
                url: '{{ url('/staff/update-status') }}/' + staffId,
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    // Update the status badge in the same row
                    var row = $(el).closest('tr');
                    var statusCell = row.find('td').eq(3);
                    if (response.status === 'active') {
                        statusCell.html(
                            '<span class="bg-green-200 text-green-800 px-2 py-1 rounded-2xl text-sm">active</span>'
                        );
                    }
                },
                error: function() {
                    alert('Failed to update status.');
                }
            });
        }
    </script>
@endsection
