<table class="w-full border-collapse">
    <thead>
        <tr class="text-gray-700 bg-gray-50 text-sm">
            <th class="p-3 text-left font-semibold">Employee</th>
            <th class="p-3 text-left font-semibold">Job Category</th>
            <th class="p-3 text-left font-semibold">Qualification</th>
            <th class="p-3 text-left font-semibold">Status</th>
            <th class="p-3 text-center font-semibold">Actions</th>
        </tr>
    </thead>
    <tbody class="bg-white rounded-lg shadow">
        @foreach ($staff as $member)
            <tr class="border-b hover:bg-blue-50 transition">
                <!-- Employee Name & Email -->
                <td class="p-3 flex items-center gap-3">
                    <img src="{{ $member && $member->profile_photo ? url('/staff-members/' . $member->profile_photo) : asset('assets/sidebar/student.png') }}"
                        class="w-10 h-10 rounded-full border border-gray-200 shadow-sm" />
                    <div>
                        <div class="font-semibold text-gray-800">{{ $member->full_name }}</div>
                        <div class="text-xs text-gray-500">{{ $member->email }}</div>
                        <div class="text-xs text-gray-500">{{ $member->cnic }}</div>
                         <div class="text-xs text-gray-500">{{ $member->registration_no }}</div>
                    </div>
                </td>
                <!-- Job Category -->
                <td class="p-3 text-gray-700">{{ Str::ucfirst($member->job_position->category) }}</td>
                <!-- Qualification -->
                <td class="p-3 text-gray-700">{{ $member->qualifications }}</td>
                <!-- Status -->
                <td class="p-3">
                    <span class="bg-yellow-100 text-yellow-700 px-3 py-1 rounded-2xl text-xs font-semibold">
                        {{ Str::ucfirst($member->status) }}
                    </span>
                </td>
                <!-- Actions -->
                <td class="p-3 text-center relative">
                    <button onclick="toggleDropdown(this)"
                        class="action-btn px-2 py-1 rounded hover:bg-gray-100 focus:outline-none" title="Actions">
                        <img src="{{ asset('assets/actions.png') }}" alt="icons" class="w-5 h-5" />
                    </button>
                    <div
                        class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 shadow-lg rounded-lg border">
                        <a href="{{ route('staff.profile', $member->id) }}"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm">
                            <i class="fa-solid fa-eye text-blue-600"></i> View Profile
                        </a>
                        <a href="{{ route('staff.edit', $member->id) }}"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm">
                            <i class="fa-solid fa-pen-to-square text-green-600"></i> Edit Profile
                        </a>
                        <a href="#"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm"
                            onclick="updateStatus({{ $member->id }}, this); return false;">
                            <i class="fa-solid fa-key text-yellow-600"></i> Update Status
                        </a>
                    </div>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
