@extends('schoolLayout.app')
@section('content')
@include('successError')
    <header class="bg-white w-[96%] mx-auto shadow-sm px-4 py-2 flex justify-between items-center mb-1 mx-auto rounded-sm">
        <!-- Left: Heading -->
        <h1 class="text-2xl font-semibold text-gray-800">
            Edit Staff
        </h1>

        <!-- Right: Image -->
        <img src="{{ asset('assets/hrProfile.png') }}" alt="Header Image" class="w-8 rounded-full object-cover" />
    </header>
    <div class="bg-[#f9fafc] rounded-lg p-6 w-[96%] mx-auto">
        <div class="bg-white p-4 rounded-lg">
            <form action="{{ route('staff.update', $staff->id) }}" method="POST" enctype="multipart/form-data"
                class="w-full">
                @csrf
                <div class="bg-white rounded-lg p-4 my-4">
                    <h3 class="text-lg font-semibold text-gray-600 mb-1">1. Personal Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Full Name</label>
                            <input type="text" name="name" class="p-2 border rounded-md w-full"
                                placeholder="Enter your name" value="{{ $staff->full_name }}" />
                            @error('name')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Father Name</label>
                            <input type="text" name="fth_name" class="p-2 border rounded-md w-full"
                                placeholder="Enter father's name" value="{{ $staff->father_name }}" />
                            @error('fth_name')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Email</label>
                            <input type="email" name="email" class="p-2 border rounded-md w-full"
                                placeholder="Enter email" value="{{ $staff->email }}" />
                            @error('email')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="block mb-1">Gender <span class="text-red-600">*</span></label>
                            <select name="gender"
                                class="w-full p-2 border rounded @error('gender') border-red-500 @enderror">
                                <option value="">Select Gender</option>
                                <option value="Male" {{ $staff->gender == 'male' ? 'selected' : '' }}>Male
                                </option>
                                <option value="Female" {{ $staff->gender == 'female' ? 'selected' : '' }}>Female
                                </option>
                                <option value="Other" {{ $staff->gender == 'other' ? 'selected' : '' }}>Other
                                </option>
                            </select>
                            @error('gender')
                                <p class="text-red-500 text-sm">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="block mb-1">CNIC <span class="text-red-600">*</span></label>
                            <input type="text" name="cnic"
                                class="w-full p-2 border rounded @error('cnic') border-red-500 @enderror"
                                value="{{ $staff->cnic }}">
                            @error('cnic')
                                <p class="text-red-500 text-sm">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Date of Birth</label>
                            <input type="date" name="dob" class="p-2 border rounded-md w-full"
                                value="{{ $staff->date_of_birth }}" />
                            @error('dob')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Contact Information -->
                <div class="bg-white rounded-lg p-4 my-4">
                    <h3 class="text-lg font-semibold text-gray-600 mb-1">2. Contact Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Primary Contact No.</label>
                            <input type="tel" name="primary_cont" class="p-2 border rounded-md w-full"
                                placeholder="Enter primary contact number" value="{{ $staff->primary_contact_no }}" />
                            @error('primary_cont')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Secondary Contact No</label>
                            <input type="tel" name="secondary_cont" class="p-2 border rounded-md w-full"
                                placeholder="Enter secondary contact number" value="{{ $staff->secondary_contact_no }}" />
                            @error('secondary_cont')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div>
                        <label class="mb-1 block font-semibold text-gray-700">Complete Address</label>
                        <textarea name="address" class="p-2 border rounded-md w-full h-24 resize-none"
                            placeholder="Enter complete address">{{ $staff->address }}</textarea>
                        @error('address')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <!-- Professional Details -->
                <div class="bg-white rounded-lg p-4 my-4">
                    <h3 class="text-lg font-semibold text-gray-600 mb-1">3. Professional Details</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Position Category</label>
                            <select name="position" class="p-2 border rounded-md w-full bg-white">
                                <option value="" disabled selected>Select Category</option>

                                @if ($positions)
                                    @foreach ($positions as $position)
                                        <option value="{{ $position->id }}"
                                            {{ $staff->position == $position->id ? 'selected' : '' }}>
                                            {{ $position->category }}</option>
                                    @endforeach
                                @endif
                            </select>
                            @error('position')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Employment Type</label>
                            <select name="emp_type" class="p-2 border rounded-md w-full">
                                {{-- <option value="" disabled selected>Select Type</option> --}}
                                <!-- Add options dynamically if needed -->
                                <option value="Full time" {{ $staff->employment_type == 'Full time' ? 'selected' : '' }}>
                                    Full time</option>
                                <option value="half time" {{ $staff->employment_type == 'half time' ? 'selected' : '' }}>
                                    Half time</option>
                            </select>
                            @error('emp_type')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Salary</label>
                            <input type="number" name="salary" class="p-2 border rounded-md w-full"
                                placeholder="Enter salary" value="{{ $staff->salary }}" />
                            @error('salary')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Previous Experience (Years)</label>
                            <input type="number" name="prev_exp" class="p-2 border rounded-md w-full"
                                placeholder="Enter experience years" value="{{ $staff->previous_experience }}" />
                            @error('prev_exp')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="md:col-span-2">
                            <label class="mb-1 block font-semibold text-gray-700">Qualifications</label>
                            <textarea name="qualif" class="p-2 border rounded-md w-full h-24 resize-none"
                                placeholder="Enter qualifications">{{ $staff->qualifications }}</textarea>
                            @error('qualif')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Additional Information -->
                <div class="bg-white rounded-lg p-4 my-4">
                    <h3 class="text-lg font-semibold text-gray-600 mb-1">5. Additional Information</h3>
                    <div class="mb-4">
                        <label class="mb-1 block font-semibold text-gray-700">Additional Notes</label>
                        <textarea name="notes" class="p-2 border rounded-md w-full h-20"
                            placeholder="Enter any additional information">{{ $staff->additional_notes }}</textarea>
                        @error('notes')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="flex justify-end gap-x-4">
                    <button type="button" class="border px-2 rounded-md border-gray-400"
                        onclick="window.location.href='{{ route('staff') }}'">Cancel</button>
                    <button type="submit" class="bg-[#0197FF] text-white p-2 rounded-md hover:bg-blue-700 transition">
                        Update
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
