@extends('schoolLayout.app')

@section('content')
    <div class="max-w-7xl mx-auto">
        <!-- Header Section -->
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-semibold text-gray-800">
                Role and Permission
            </h1>
            <button id="openModal" class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-2 text-white rounded-sm">
                <i class="fa-solid fa-plus"></i>
                <span>Add New Role</span>
            </button>
        </div>
        <div class="overflow-x-auto bg-white border border-gray-300 rounded-md shadow-sm">
            <!-- Permissions Form -->
            <form method="POST" action="{{ route('settings.update-role-permissions') }}">
                @csrf
                @method('PUT') <!-- Use PUT method for updates -->

                <table class="w-full rounded-md">
                    <thead>
                        <tr class="bg-[#f9fafc]">
                            <th class="text-gray-500 font-medium px-4 py-5 text-left rounded-tl-md">Feature/Modules</th>
                            @foreach ($roles as $role)
                                <th class="text-gray-500 font-medium px-4 py-5 text-center">
                                    {{ ucwords(str_replace('_', ' ', $role->name)) }}</th>
                            @endforeach
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($permissions as $permission)
                            <tr class="hover:bg-gray-50 font-semibold">
                                <td class="border-y border-gray-300 px-4 py-5 px-4 py-2">
                                    {{ ucwords(str_replace('_', ' ', $permission->name)) }}</td>

                                @foreach ($roles as $role)
                                    <td class="border-y border-gray-300 px-4 py-5 text-center px-4 py-2">
                                        <input type="checkbox" class="w-4 h-4" name="permissions[{{ $role->id }}][]"
                                            value="{{ $permission->name }}"
                                            {{ $role->hasPermissionTo($permission->name) ? 'checked' : '' }} />
                                    </td>
                                @endforeach
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="flex justify-end my-4">
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Update
                    </button>
                </div>
            </form>
        </div>

        <div id="modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
            <!-- Modal Content -->
            <div class="bg-white w-full max-w-xl rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
                <!-- Modal Header -->
                <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                    <h2 class="text-xl font-semibold">Add New Role</h2>
                    <button id="closeModal" class="text-gray-600 hover:text-gray-900">
                        <i class="fa-solid fa-xmark"></i>
                    </button>
                </div>

                <!-- Form Starts Here -->
                <form action="{{ route('settings.create-role') }}" method="POST">
                    @csrf
                    <input type="hidden" name="action" value="create_role">
                    <!-- Modal Body -->
                    <div class="bg-white px-4 py-3">
                        <!-- Role Name and Description -->
                        <div class="mb-6">
                            <label class="block text-gray-700 font-semibold mb-1" for="roleName">Role Name<span
                                    class="text-red-500">*</span></label>
                            <input id="roleName" name="roleName" type="text" placeholder="Enter role name"
                                class="w-full p-2 border border-gray-300 rounded-sm focus:outline-blue-500" required />
                        </div>
                    </div>

                    <!-- Modal Footer -->
                    <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                        <button id="closeModalBtn" type="button"
                            class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                            Cancel
                        </button>
                        <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                            Save Role
                        </button>
                    </div>
                </form>
            </div>
        </div>

    </div>
@endsection
@section('script')
    <script>
        // Modal functionality
        const modal = document.getElementById("modal");
        const openModalBtn = document.getElementById("openModal");
        const closeModalBtns = [
            document.getElementById("closeModal"),
            document.getElementById("closeModalBtn"),
        ];

        openModalBtn.addEventListener("click", () => {
            modal.classList.remove("hidden");
        });

        closeModalBtns.forEach((btn) => {
            btn.addEventListener("click", () => {
                modal.classList.add("hidden");
            });
        });
    </script>
@endsection
