@extends('schoolLayout.app')
@section('content')

    @include('successError')
    <div class="flex justify-between mb-4 items-center">
        <div class="flex space-x-2 w-[50%]">
            {{-- <div class="flex space-x-2 w-[50%]"> --}}
            <button class="tab-btn px-8 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500"
                {{-- onclick=" window.location.href = '{{ route('school-sessions') }}'" --}}>
                Sessions
            </button>
            <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                onclick="window.location.href = '{{ route('sections') }}'">
                Sections
            </button>
            <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                onclick="window.location.href = '{{ route('classes') }}'">
                Classes
            </button>
            <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                onclick="window.location.href = '{{ route('subjects') }}'">
                Subjects
            </button>
        </div>
        <button id="openModal" class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-2 text-white rounded-lg">
            <i class="fa-solid fa-plus"></i> Add New Session </button>

    </div>

    <div class="border p-3 bg-white border-gray-200 rounded-lg mt-4">
        <!-- Filters Section -->
        <!-- <div
                      class="bg-white  flex justify-between rounded-lg flex-wrap gap-4"
                    >
                       <div class="relative w-[50%] rounded-lg">
                        <div
                          class="border border-gray-200 rounded-sm bg-white flex items-center px-4"
                        >
                          <span class="text-gray-500">
                          <img src="{{ asset('assets/search.png') }}" alt="icon" />
                          </span>
                          <input
                            type="text"
                            placeholder="Search Sessions..."
                            class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none"
                          />
                        </div>
                      </div>
                      <div class="flex gap-x-2 items-center">
                        <select class="border min-w-[120px] p-2  rounded-lg">
                          <option>All Status</option>
                        </select>
                      </div>
                    </div>-->
        <div class="flex items-center my-4 bg-[#FEFCE8] border-l-4 border-[#FACC15] text-[#A16207] p-4">
            <i class="fa-solid fa-circle-info text-[#FACC15] text-xl mr-3"></i>

            <p class="">Current Active Session: <span
                    class="font-semibold">{{ $active_session->session_year ?? 'First Create Session' }}</span></p>
        </div>

        <div class="relative bg-white">
            <table class="w-full border-collapse">
                <thead class="bg-[#f9fafc]">
                    <tr class="text-gray-600">
                        <th class="p-3 text-left text-gray-500 font-medium">
                            Session Name
                        </th>
                        <th class="p-3 text-left text-gray-500 font-medium">
                            Start Date
                        </th>
                        <th class="p-3 text-left text-gray-500 font-medium">
                            End Date
                        </th>
                        <th class="p-3 text-left text-gray-500 font-medium">Status</th>
                        <th class="p-3 text-center text-gray-500 font-medium">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white py-3 rounded-lg">
                    @if ($school_sessions)
                        @foreach ($school_sessions as $single_session)
                            <tr class="border-b">
                                <td class="p-3 flex items-center font-semibold text-black">
                                    {{ $single_session->session_year }}
                                </td>
                                <td class="p-3 text-gray-500">
                                    {{ \Carbon\Carbon::parse($single_session->start_date)->format('d M Y') }}</td>
                                <td class="p-3 text-gray-500">
                                    {{ \Carbon\Carbon::parse($single_session->end_date)->format('d M Y') }}</td>
                                <td class="p-3 text-gray-500">
                                    @if ($single_session->status == 'inactive')
                                        <span
                                            class="bg-[#FEE2E2] font-semibold text-[#B91C1C] px-2 py-0.5 rounded-2xl text-sm">
                                            Inactive
                                        </span>
                                    @else
                                        <span
                                            class="bg-[#DCFCE7] font-semibold text-[#166534] px-2 py-0.5 rounded-2xl text-sm">
                                            Active
                                        </span>
                                    @endif
                                </td>
                                <td class="p-3 text-center flex justify-center items-center gap-x-4">
                                    <i class="fa-solid fa-pen-to-square text-blue-500 cursor-pointer"
                                        onclick="openEditModal({{ $single_session->id }})"></i>
                                    <i class="fa-solid fa-trash text-red-500" data-id="{{ $single_session->id }}"
                                        onclick="deleteSession(this)"></i>
                                </td>
                            </tr>
                        @endforeach
                    @endif
                </tbody>
            </table>
            <div class="flex justify-between border-t mt-10 border-gray-200 bg-white items-center pt-4 p-4">
                <p class="text-gray-500 text-sm"> </p>
                {{ $school_sessions->links('vendor.pagination.custom-pagination') }}
            </div>
        </div>
    </div>
    </div>
    <div id="modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <!-- Modal Content -->
        <div class="bg-white w-full max-w-md rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <!-- Modal Header -->
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Session Year</h2>
                <button id="closeModal" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <!-- Modal Body -->
            <div class="bg-white px-6 py-3">
                <form method="post" action="{{ route('school-sessions-store') }}">
                    @csrf

                    <!-- Session Year -->
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">
                            Session Year <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="session_year"
                            value="{{ old('session_year', date('Y') . '-' . (date('Y') + 1)) }}"
                            class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            placeholder="2024-2025" />
                        @error('session_year')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Start Date -->
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">
                            Start Date <span class="text-red-500">*</span>
                        </label>
                        <input type="date" name="start_date" value="{{ old('start_date') }}"
                            class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        @error('start_date')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- End Date -->
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">
                            End Date <span class="text-red-500">*</span>
                        </label>
                        <input type="date" name="end_date" value="{{ old('end_date') }}"
                            class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        @error('end_date')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Status -->
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">
                            Status <span class="text-red-500">*</span>
                        </label>
                        <select name="status"
                            class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Status</option>
                            <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                        @error('status')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Modal Footer -->
                    <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                        <button type="button" id="closeModalBtn"
                            class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                            Cancel
                        </button>
                        <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                            Create Session
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <!-- Modal Content -->
        <div class="bg-white w-full max-w-md rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <!-- Modal Header -->
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Edit Session Year</h2>
                <button id="closeEditModal" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <!-- Modal Body -->
            <div class="bg-white px-6 py-3">
                <form method="post" action="{{ route('school-sessions.update') }}">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="id" id="edit_session_id">

                    <!-- Session Year -->
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">
                            Session Year <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="session_year" id="edit_session_year"
                            class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            placeholder="2024-2025" />
                    </div>

                    <!-- Start Date -->
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">
                            Start Date <span class="text-red-500">*</span>
                        </label>
                        <input type="date" name="start_date" id="edit_start_date"
                            class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" />
                    </div>

                    <!-- End Date -->
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">
                            End Date <span class="text-red-500">*</span>
                        </label>
                        <input type="date" name="end_date" id="edit_end_date"
                            class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" />
                    </div>

                    <!-- Status -->
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">
                            Status <span class="text-red-500">*</span>
                        </label>
                        <select name="status" id="edit_status"
                            class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>

                    <!-- Modal Footer -->
                    <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                        <button type="button" id="closeEditModalBtn"
                            class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                            Cancel
                        </button>
                        <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                            Update Session
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>



@endsection

@section('script')
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Modal functionality
            const modal = document.getElementById("modal");
            const openModalBtn = document.getElementById("openModal");
            const closeModalBtns = [
                document.getElementById("closeModal"),
                document.getElementById("closeModalBtn"),
            ];

            if (openModalBtn && modal) {
                openModalBtn.addEventListener("click", () => {
                    modal.classList.remove("hidden");
                });
            }

            closeModalBtns.forEach((btn) => {
                if (btn) {
                    btn.addEventListener("click", () => {
                        modal.classList.add("hidden");
                    });
                }
            });
        });


        function openEditModal(id) {
            fetch(`/school/sessions/${id}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('edit_session_id').value = data.id;
                    document.getElementById('edit_session_year').value = data.session_year;
                    document.getElementById('edit_start_date').value = data.start_date;
                    document.getElementById('edit_end_date').value = data.end_date;
                    document.getElementById('edit_status').value = data.status;
                    document.getElementById('editModal').classList.remove('hidden');
                });
        }

        document.getElementById('closeEditModal').addEventListener('click', function() {
            document.getElementById('editModal').classList.add('hidden');
        });

        document.getElementById('closeEditModalBtn').addEventListener('click', function() {
            document.getElementById('editModal').classList.add('hidden');
        });

        function deleteSession(element) {
            const id = element.getAttribute('data-id');
            if (confirm('Are you sure you want to delete this Session?')) {
                window.location.href = '/school/sessions/delete/' + id;
            }
        }
    </script>
@endsection
