<!DOCTYPE html>
<html>
<head>
    <title>Staff Salary Pay Report</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: center; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>

<h2 style="text-align: center;">Staff Salary Pay Report</h2>

<table>
    <thead>
        <tr>
            <th>Staff</th>
            <th>Reg No</th>
            <th>Narration</th>
            <th>Status</th>
            <th>Date</th>
            <th>Amount</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($staffs as $f)
            <tr>
                <td>{{ $f->staff_member->full_name ?? 'N/A' }}</td>
                <td>{{ $f->reg_no ?? 'N/A' }}</td>
                <td>{{ 'Pay Salary' }}</td>
                <td>{{ $f->staff_member->status ?? 'N/A' }}</td>
                <td>{{ $f->date ?? 'N/A' }}</td>
                <td>{{ $f->amount ?? '0' }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="6">No Data Found.</td>
            </tr>
        @endforelse
    </tbody>
</table>

</body>
</html>
