<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Salary List PDF</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #000; padding: 5px; text-align: left; }
        th { background: #f2f2f2; }
    </style>
</head>
<body>
    <h2>Salary List</h2>
    <table>
        <thead>
            <tr>
                <th>Employee Name</th>
                <th>B1</th>
                <th>B2</th>
                <th>B3</th>
                <th>B4</th>
                <th>B5</th>
                <th>Total Bonus</th>
                <th>Salary</th>
                <th>Net Salary</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($staffList as $staff)
                <tr>
                    <td>{{ $staff->full_name }} - {{ $staff->registration_no }}</td>
                    <td>{{ $staff->salaryStruct->b1 ?? 0 }}</td>
                    <td>{{ $staff->salaryStruct->b2 ?? 0 }}</td>
                    <td>{{ $staff->salaryStruct->b3 ?? 0 }}</td>
                    <td>{{ $staff->salaryStruct->b4 ?? 0 }}</td>
                    <td>{{ $staff->salaryStruct->b5 ?? 0 }}</td>
                    <td>
                        {{
                            ($staff->salaryStruct->b1 ?? 0) +
                            ($staff->salaryStruct->b2 ?? 0) +
                            ($staff->salaryStruct->b3 ?? 0) +
                            ($staff->salaryStruct->b4 ?? 0) +
                            ($staff->salaryStruct->b5 ?? 0)
                        }}
                    </td>
                    <td>{{ $staff->salary }}</td>
                    <td>
                        {{
                            ($staff->salaryStruct->b1 ?? 0) +
                            ($staff->salaryStruct->b2 ?? 0) +
                            ($staff->salaryStruct->b3 ?? 0) +
                            ($staff->salaryStruct->b4 ?? 0) +
                            ($staff->salaryStruct->b5 ?? 0) +
                            ($staff->salary ?? 0)
                        }}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
