@extends('schoolLayout.app')
@section('content')
    <style>
        /* Increase height of the Select2 container */
        .custom-select2+.select2-container .select2-selection--single {
            height: 38px !important;
            display: flex;
            align-items: center;
            border-radius: 0.375rem;
            /* Tailwind's rounded */
            border: 1px solid #d1d5db;
            /* Tailwind gray-300 */
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        /* Optional: increase font size */
        .custom-select2+.select2-container .select2-selection__rendered {
            font-size: 16px;
            line-height: 48px;
        }
    </style>
    @include('successError')
    <div class="flex justify-between items-center  pb-4">
        @include('salary.partialHead')
    </div>
    <div class="flex items-center mt-4 space-x-4">

        <select id="staff-search" name="staff-search" class="border p-2 rounded-lg  select2 custom-select2">
            <option value="">Select Staff</option>
            @foreach ($staffList as $s)
                <option value="{{ $s->head_code }}">
                    {{ $s->full_name }} - {{ $s->registration_no }}
                </option>
            @endforeach
        </select>
        <a href="{{ route('pdf.staff.salary.pay.report') }}"
            class="bg-[#0197FF] hover:bg-blue-600 text-white px-4 py-2 rounded">
            PDF
        </a>

    </div>
    <!-- Applications Table -->
    <div class="bg-white py-3 rounded-lg shadow mt-6 relative">
        <!-- 🔁 Container for results -->
        <div id="staff-table" class="bg-white py-3 rounded-lg shadow mt-6 relative">
            @include('salary.partialPayReport', ['staffs' => $staffs])
        </div>
    </div>
    <div class="flex justify-between items-center px-4 pt-4 border-t border-gray-200 mt-8">
        <div class="flex items-center text-sm text-gray-500">
            Showing {{ $staffs->firstItem() }} to {{ $staffs->lastItem() }} of {{ $staffs->total() }} results

            <form method="GET" class="ml-3">
                <select name="entries" onchange="this.form.submit()"
                    class="border rounded-lg px-1 py-1 text-sm focus:outline-none focus:ring-2 focus:ring-blue-400">
                    <option value="40" {{ request('entries') == 40 ? 'selected' : '' }}>40</option>
                    <option value="80" {{ request('entries') == 80 ? 'selected' : '' }}>80</option>
                    <option value="120" {{ request('entries') == 120 ? 'selected' : '' }}>120</option>
                </select>
            </form>
        </div>

        <div class="mt-2">
            {{ $staffs->appends(request()->query())->onEachSide(1)->links('pagination::tailwind') }}

        </div>

    </div>

    @include('salary.component', ['staffs' => $staffList])
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                width: '100%' // Ensure full width
            });
        });
        // Focus on the search field when the Select2 dropdown opens
        $(document).on('select2:open', function() {
            const searchField = $('.select2-search__field');
            if (searchField.length) {
                searchField[0].focus();
            }
        });

        $(document).on('click', '.pagination a', function(event) {
            event.preventDefault();
            let url = $(this).attr('href');

            $.ajax({
                url: url,
                type: "GET",
                success: function(data) {
                    $('#staff-table').html(data);
                }
            });
        });
    </script>

    <script>
        $('#staff-search').on('change', function() {
            let selectedStaff = $(this).val(); // Get the selected student value

            // Only trigger the AJAX call if a valid student is selected
            if (selectedStaff) {
                $.ajax({
                    url: "{{ route('staff.pay.indexR') }}",
                    type: "GET",
                    data: {
                        search: selectedStaff // Send the selected student value in the AJAX request
                    },
                    success: function(data) {
                        $('#staff-table').html(data); // Update the student table with the new data
                    }
                });
            }
        });

        function toggleDropdown(button) {
            // Close all dropdowns first
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            // Toggle the clicked dropdown
            const dropdown = button.nextElementSibling;
            dropdown.classList.toggle("hidden");
        }

        // Close dropdown when clicking outside
        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });
    </script>
@endsection
