<table class="w-full border-collapse border border-gray-200 rounded-lg">
    <thead class="bg-gray-100">
        <tr class="text-gray-600">
            <th class="p-3 text-left font-medium">Employee Name</th>
            <th class="p-3 text-left font-medium">Role</th>
            <th class="p-3 text-left font-medium">B 1</th>
            <th class="p-3 text-left font-medium">B 2</th>
            <th class="p-3 text-left font-medium">B 3</th>
            <th class="p-3 text-left font-medium">B 4</th>
            <th class="p-3 text-left font-medium">B 5</th>
            <th class="p-3 text-left font-medium">Total Bonus</th>
            <th class="p-3 text-left font-medium">Salary</th>
            <th class="p-3 text-left font-medium">Net Salary</th>
            <th class="p-3 text-center font-medium">Status</th>
            <th class="p-3 text-center font-medium">Actions</th>
        </tr>
    </thead>
    <tbody class="bg-white">
        @forelse ($staffList as $staff)
            <tr class="border-b {{ $loop->even ? 'bg-blue-50' : 'bg-white' }} hover:bg-gray-50" data-id="{{ $staff->id }}" data-head_code="{{ $staff->head_code }}" data-reg_no="{{ $staff->registration_no }}">
                <td class="p-3">{{ $staff->full_name }} - {{ $staff->registration_no }}</td>
                <td class="p-3">Teacher</td>
                <td class="p-3">{{ $staff->salaryStruct->b1 ?? 0 }}</td>
                <td class="p-3">{{ $staff->salaryStruct->b2 ?? 0 }}</td>
                <td class="p-3">{{ $staff->salaryStruct->b3 ?? 0 }}</td>
                <td class="p-3">{{ $staff->salaryStruct->b4 ?? 0 }}</td>
                <td class="p-3">{{ $staff->salaryStruct->b5 ?? 0 }}</td>
                <td class="p-3">
                    {{ ($staff->salaryStruct->b1 ?? 0) +
                        ($staff->salaryStruct->b2 ?? 0) +
                        ($staff->salaryStruct->b3 ?? 0) +
                        ($staff->salaryStruct->b4 ?? 0) +
                        ($staff->salaryStruct->b5 ?? 0) }}
                </td>
                <td class="p-3">{{ $staff->salary }}</td>
                <td class="p-3">
                    {{ ($staff->salaryStruct->b1 ?? 0) +
                        ($staff->salaryStruct->b2 ?? 0) +
                        ($staff->salaryStruct->b3 ?? 0) +
                        ($staff->salaryStruct->b4 ?? 0) +
                        ($staff->salaryStruct->b5 ?? 0) +
                        ($staff->salary ?? 0) }}
                </td>
                <td class="p-3 text-center">
                    <span class="bg-green-200 text-green-800 px-2 py-0.5 rounded-full text-sm">
                        Active
                    </span>
                </td>
                <td class="p-3 text-center">
                    <button onclick="toggleDropdown(this)" class="action-btn text-blue-700 font-semibold text-sm">
                        View
                    </button>
                    <div
                        class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-lg border">
                        <button class="tab-btn px-4 pb-4 bg-white font-semibold text-black"
                            onclick="updateSalaryRow(this)">
                            Update Salary
                        </button>


                    </div>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="12" class="text-center text-gray-500 py-4">No Data Found.</td>
            </tr>
        @endforelse
    </tbody>
</table>
