<div class="overflow-x-auto">
    <table class="w-full border-collapse text-sm border border-gray-200 rounded-lg">
        <thead class="sticky top-0 bg-gray-100">
            <tr class="text-gray-600">
                <th class="p-3 text-left font-medium min-w-[120px]">Staff</th>
                <th class="p-3 text-center font-medium">Reg No</th>
                <th class="p-3 text-center font-medium">Narration</th>
                <th class="p-3 text-center font-medium">Status</th>
                <th class="p-3 text-center font-medium">Date</th>
                <th class="p-3 text-center font-medium">Amount</th>
                <th class="p-3 text-center font-medium min-w-[80px]">Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($staffs as $index => $f)
                <tr class="border-b {{ $index % 2 === 0 ? 'bg-blue-50' : 'bg-white' }} hover:bg-gray-50">
                    <td class="p-3 flex items-center min-w-[120px] text-gray-700">
                        {{ $f->staff_member->full_name ?? 'N/A' }}
                    </td>
                    <td class="p-3 text-gray-500 text-center">
                        {{ $f->reg_no ?? 'N/A' }}
                    </td>
                    <td class="p-3 text-red-500 text-center">
                        {{ 'Pay Salary' ?? 'N/A' }}
                    </td>
                    <td class="p-3 text-gray-500 text-center">
                        {{ $f->staff_member->status ?? 'N/A' }}
                    </td>
                    <td class="p-3 text-center text-gray-500">
                        {{ $f->date ?? 'N/A' }}
                    </td>
                    <td class="p-3 text-center text-gray-700 font-medium">
                        {{ $f->amount ?? '0' }}
                    </td>
                    <td class="p-3 text-center relative">
                        <button onclick="toggleDropdown(this)" class="action-btn text-blue-700 font-semibold text-sm">
                            View
                        </button>
                        <div
                            class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-lg border">
                            <a href="#" class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Edit</a>
                            <a href="#" class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Delete</a>
                        </div>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="7" class="text-center text-gray-500 py-4">
                        No Data Found.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
