@extends('schoolLayout.app')
@section('content')
    @include('successError')
    <div class=" mb-4">
        @include('jobPosition.partialHeadPosition')
    </div>

    <div class="border rounded-lg border-gray-200">
        <!-- Search and Filters -->
        <div class="pt-4 flex rounded-lg justify-between bg-white px-4 gap-4">
            <div class="relative w-[50%]">
                <div class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
                    <span class="text-gray-500">
                        <img src="{{ asset('assets/search.png') }}" alt="icon" />
                    </span>
                    <input type="text" name="search_query" id="search" placeholder="Enter Subject or Status"
                        onkeyup="fetchStaffData()"
                        class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none" />
                    <a href="{{ route('close.job.positions.pdf') }}"
                        class="bg-[#0197FF] text-white px-4 py-2 rounded hover:bg-blue-600">
                        PDF
                    </a>
                </div>
            </div>
            <div class="flex items-center gap-x-2">
                <select id="category" name="category" onchange="fetchStaffData()" class="p-2 border rounded-lg w-full">
                    <option value="">Job Category</option>
                    @foreach ($job_openings as $job)
                        <option value="{{ $job->category }}">{{ $job->category }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <!-- Applications Table -->
        <div id="staff-members" name="staff-members" class="bg-white py-3 rounded-lg pt-3 relative">

            @include('jobPosition.partialPosition')

            <div class="flex justify-between border-t border-gray-200 items-center mt-14 px-4 pt-3">
                <div class="flex justify-between items-center">
                    <!-- Select Option for Number of Students -->
                </div>
                {{ $job_openings->links('vendor.pagination.custom-pagination') }}
            </div>
        </div>
    </div>

    <!-- Edit Job Modal -->
    <div id="editJobModal" class="fixed inset-0 z-50 hidden overflow-y-auto">
        <div class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <!-- Background overlay -->
            <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
            </div>

            <!-- Modal content -->
            <div
                class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                <form id="editJobForm" method="POST" action="{{ route('job_position.update') }}">
                    {{-- CSRF token for security --}}
                    @csrf
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <h3 class="text-lg font-medium leading-6 text-gray-900 mb-4">Edit Job Opening</h3>

                        <div class="grid grid-cols-1 gap-4">
                            <input type="hidden" name="id" id="id">
                            <!-- Title -->
                            <div>
                                <label for="edit_title" class="block text-sm font-medium text-gray-700">Job Title</label>
                                <select name="title" id="edit_title"
                                    class="w-full p-2 border rounded-md focus:ring-2 focus:ring-blue-500">
                                    <option value="">Select Job Title</option>
                                    <option value="teacher" {{ old('title') == 'teacher' ? 'selected' : '' }}>Teacher
                                    </option>
                                    <option value="security guard" {{ old('title') == 'security guard' ? 'selected' : '' }}>
                                        Security Guard</option>
                                    <option value="cook" {{ old('title') == 'cook' ? 'selected' : '' }}>Cook</option>
                                </select>
                            </div>

                            <!-- Category -->
                            <div>
                                <label for="edit_category" class="block text-sm font-medium text-gray-700">Category</label>
                                <input type="text" name="category" id="edit_category"
                                    class="mt-1 p-2 border rounded-md w-full">
                            </div>

                            <!-- Qualification -->
                            <div>
                                <label for="edit_qualification"
                                    class="block text-sm font-medium text-gray-700">Qualification Required</label>
                                <input type="text" name="qualification_required" id="edit_qualification"
                                    class="mt-1 p-2 border rounded-md w-full">
                            </div>

                            <!-- Experience -->
                            <div>
                                <label for="edit_experience" class="block text-sm font-medium text-gray-700">Experience
                                    Required</label>
                                <input type="text" name="experience_required" id="edit_experience"
                                    class="mt-1 p-2 border rounded-md w-full">
                            </div>

                            <!-- description -->
                            <div>
                                <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                                <textarea name="description" id="edit_description" cols="60" rows="3" class="border p-2"></textarea>
                            </div>
                            <div>
                                <label for="salary" class="block text-sm font-medium text-gray-700">Salary</label>
                                <input type="number" name="salary" id="edit_salary" class="border p-2">
                            </div>


                            <!-- Status -->
                            <div>
                                <label for="edit_status" class="block text-sm font-medium text-gray-700">Status</label>
                                <select name="status" id="edit_status" class="mt-1 p-2 border rounded-md w-full">
                                    <option value='open'>Open</option>
                                    <option value='closed'>Closed</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="submit"
                            class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-blue-600 text-base font-medium text-white hover:bg-blue-700 sm:ml-3 sm:w-auto sm:text-sm">
                            Update
                        </button>
                        <button type="button" onclick="closeModal()"
                            class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            Cancel
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function fetchStaffData() {
            let search = document.getElementById("search").value;
            let category = document.getElementById("category").value;

            $.ajax({
                url: "{{ route('job.close.positions') }}",
                method: "GET",
                data: {
                    search_query: search,
                    category: category,
                },
                success: function(response) {
                    $('#staff-members').html(response);
                }
            });
        }

        function openEditModal(job) {
            document.getElementById('edit_title').value = job.title;
            document.getElementById('edit_category').value = job.category;
            document.getElementById('edit_qualification').value = job.qualification_required;
            document.getElementById('edit_experience').value = job.experience_required;
            document.getElementById('edit_status').value = job.status;
            document.getElementById('edit_description').value = job.description;
            document.getElementById('edit_salary').value = job.salary;
            document.getElementById('id').value = job.id;
            document.getElementById('editJobModal').classList.remove('hidden');
        }

        function closeModal() {
            document.getElementById('editJobModal').classList.add('hidden');
        }

        // Initialize event listeners after DOM loads
        document.addEventListener('DOMContentLoaded', function() {
            window.onclick = function(event) {
                const modal = document.getElementById('editJobModal');
                if (event.target === modal) {
                    closeModal();
                }
            }
        });

        function deleteJob(element) {
            const id = element.getAttribute('data-id');
            if (confirm('Are you sure you want to delete this job?')) {
                window.location.href = '/job_position_delete/' + id;
            }
        }
    </script>
@endsection
