@extends('schoolLayout.app')
@section('content')
    @include('successError')
    <!-- Header Section -->
    @include('jobApplication.partialHeadJobApp')
    <!-- Search and Filters -->
    <div class="pt-4 flex justify-between bg-white px-4 gap-4">
        <div class="relative w-[50%]">
            <div class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
                <span class="text-gray-500">
                    <img src="{{ asset('assets/search.png') }}" alt="icon" />
                </span>
                <input type="text" name="search_query" id="search" placeholder="Enter Subject or Status"
                    onkeyup="fetchStaffData()"
                    class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none" />
            </div>
        </div>
        <div class="flex items-center gap-x-2">

        </div>
    </div>
    <!-- Applications Table -->
    <div id="staff-members" name="staff-members" class="bg-white py-3 rounded-lg pt-6 relative">
          <!-- PDF Download Button -->
    <div class="flex justify-end px-4 mb-4">
        <a href="{{ route('pdf.pending.job.app') }}"
           class="px-4 py-2 bg-[#0197FF] text-white rounded-lg flex items-center gap-x-2 hover:bg-blue-600 transition">
            <span>Download PDF</span>
        </a>
    </div>
        @include('jobApplication.partialJobApp')

        {{ $applications->links('vendor.pagination.custom-pagination') }}

    </div>
@endsection
@section('script')
    <!-- Modal or Popup for File Viewer -->
    <div id="file-viewer-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 z-50 p-8">
        <div class="bg-white w-full h-full rounded-lg">
            <div class="flex justify-between items-center p-4 border-b">
                <h3 class="text-lg font-semibold">View File</h3>
                <button onclick="closeFile()" class="text-gray-500 hover:text-gray-700">
                    &times;
                </button>
            </div>
            <iframe id="file-viewer-iframe" class="w-full h-full" frameborder="0"></iframe>
        </div>
    </div>

    <script>
        function fetchStaffData() {
            let search = document.getElementById("search").value;

            $.ajax({
                url: "{{ route('job.pending.app') }}",
                method: "GET",
                data: {
                    search_query: search,
                },
                success: function(response) {
                    $('#staff-members').html(response);
                }
            });
        }

        function openFile(url) {
            document.getElementById('file-viewer-iframe').src = url;
            document.getElementById('file-viewer-modal').classList.remove('hidden');
        }

        function closeFile() {
            document.getElementById('file-viewer-iframe').src = '';
            document.getElementById('file-viewer-modal').classList.add('hidden');
        }


        function toggleDropdown(button) {
            // Close any open dropdowns
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            // Toggle the clicked dropdown
            const dropdown = button.nextElementSibling;
            dropdown.classList.toggle("hidden");
        }

        // Close dropdown when clicking outside
        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });
    </script>
@endsection
