<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Job Applications</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 11px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #666; padding: 6px; }
        th { background: #f0f0f0; }
    </style>
</head>
<body>
    <h2>Job Applications</h2>
    <table>
        <thead>
            <tr>
                <th>Name & Email</th>
                <th>Father Name</th>
                <th>Qualification</th>
                <th>Phone</th>
                <th>Applied Date</th>
                <th>Apply Type</th>
                <th>Applied Position</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($applications as $app)
                <tr>
                    <td>
                        {{ $app->applicant_name }}<br>
                        <small>{{ $app->email }}</small>
                    </td>
                    <td>{{ $app->father_name }}</td>
                    <td>{{ $app->qualification }}</td>
                    <td>{{ $app->phone }}</td>
                    <td>{{ $app->applied_date }}</td>
                    <td>{{ ucfirst($app->apply_type) }}</td>
                    <td>{{ $app->applied_position }}</td>
                    <td>{{ ucfirst($app->application_status) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
