<table class="w-full border-collapse">
    <thead class="border-b border-gray-200 bg-gray-50">
        <tr class="text-gray-700 text-sm">
            <th class="p-3 text-left font-semibold">Name & Email</th>
            <th class="p-3 text-left font-semibold">Father Name</th>
            <th class="p-3 text-left font-semibold">Qualification</th>
            <th class="p-3 text-left font-semibold">Contact</th>
            <th class="p-3 text-left font-semibold">Date</th>
            <th class="p-3 text-left font-semibold">Apply Type</th>
            <th class="p-3 text-left font-semibold">Applied Position</th>
            <th class="p-3 text-center font-semibold">Status</th>
            <th class="p-3 text-center font-semibold">Actions</th>
        </tr>
    </thead>
    <tbody>
        @if ($applications)
            @foreach ($applications as $application)
                <tr class="border-b hover:bg-blue-50 transition">
                    <!-- Name & Email -->
                    <td class="p-3 flex items-center gap-3">
                        <img src="{{ asset('assets/sidebar/student.png') }}" alt="Student"
                            class="w-10 h-10 rounded-full border border-gray-200 shadow-sm" />
                        <div>
                            <div class="font-semibold text-gray-800">{{ $application->applicant_name }}</div>
                            <div class="text-xs text-gray-500">{{ $application->email }}</div>
                        </div>
                    </td>
                    <!-- Father Name -->
                    <td class="p-3 text-gray-700">{{ $application->father_name }}</td>
                    <!-- Qualification -->
                    <td class="p-3 text-gray-700">{{ $application->qualification }}</td>
                    <!-- Contact -->
                    <td class="p-3 text-gray-700">{{ $application->phone }}</td>
                    <!-- Date -->
                    <td class="p-3 text-gray-700">{{ $application->applied_date }}</td>
                    <!-- Apply Type -->
                    <td class="p-3">
                        <span class="inline-block bg-blue-100 text-blue-700 px-2 py-0.5 rounded text-xs font-medium">
                            {{ $application->apply_type }}
                        </span>
                    </td>
                    <!-- Applied Position -->
                    <td class="p-3 text-gray-700">{{ $application->applied_position }}</td>
                    <!-- Status -->
                    <td class="p-3 text-center">
                        @if ($application->application_status == 'accepted')
                            <span
                                class="bg-green-100 text-green-700 px-3 py-1 rounded-2xl text-xs font-semibold">Accepted</span>
                        @elseif ($application->application_status == 'pending')
                            <span
                                class="bg-yellow-100 text-yellow-700 px-3 py-1 rounded-2xl text-xs font-semibold">Pending</span>
                        @elseif ($application->application_status == 'rejected')
                            <span
                                class="bg-red-100 text-red-700 px-3 py-1 rounded-2xl text-xs font-semibold">Rejected</span>
                        @endif
                    </td>
                    <!-- Actions -->
                    <td class="p-3 text-center relative">
                        <button onclick="toggleDropdown(this)"
                            class="action-btn px-2 py-1 rounded hover:bg-gray-100 focus:outline-none" title="Actions">
                            <img src="{{ asset('assets/actions.png') }}" alt="icons" class="w-5 h-5" />
                        </button>
                        <div
                            class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-48 shadow-lg rounded-lg border">
                            @if ($application->application_status != 'pending')
                                <a href="{{ route('job_application_status', ['id' => $application->id, 'status' => 'pending']) }}"
                                    class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm"
                                    title="Mark as Pending">
                                    <i class="fa-solid fa-clock text-yellow-600"></i> Pending
                                </a>
                            @endif
                            @if ($application->application_status != 'accepted')
                                <a href="{{ route('job_application_status', ['id' => $application->id, 'status' => 'accepted']) }}"
                                    class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm"
                                    title="Accept">
                                    <i class="fa-solid fa-check text-green-600"></i> Accept
                                </a>
                            @endif
                            @if ($application->application_status != 'rejected')
                                <a href="{{ route('job_application_status', ['id' => $application->id, 'status' => 'rejected']) }}"
                                    class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm"
                                    title="Reject">
                                    <i class="fa-solid fa-xmark text-red-600"></i> Reject
                                </a>
                            @endif
                            <a href="{{ asset('storage/' . $application->resume) }}" target="_blank"
                                class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm"
                                title="View CV">
                                <i class="fa-solid fa-file-lines text-blue-600"></i> View CV
                            </a>
                        </div>
                    </td>
                </tr>
            @endforeach
        @else
            <tr>
                <td colspan="9" class="text-center text-gray-400 py-6">No applications found.</td>
            </tr>
        @endif
    </tbody>
</table>
