@extends('schoolLayout.app')
@section('content')
@include('successError')
    <div class="px-8 py-3">
        <h1 class="font-bold text-3xl">Job Application Form</h1>
    </div>
    <div class="bg-[#f9fafc] rounded-lg px-6">
        <!-- Personal Information -->
        <div class="bg-white p-4 rounded-lg">
            <h3 class="text-lg font-semibold text-gray-600 mb-1">
                1. Personal Information
            </h3>
            <!-- Form Starts Here -->
            <form action="{{ route('job_application_store') }}" method="POST" id="form" enctype="multipart/form-data">
                @csrf <!-- CSRF Token for Security -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <!-- Full Name -->
                    <div>
                        <label class="mb-1 block font-semibold text-gray-700">Job Position or Job Category</label>
                        <select name="job_position" class="p-2 border rounded-md w-full">
                            <option value="" disabled {{ old('job_position') == '' ? 'selected' : '' }}>Select Job
                                Position or Job Category</option>
                            @foreach ($jobPositions as $job)
                                <option value="{{ $job->id }}" {{ old('job_position') == $job->id ? 'selected' : '' }}>
                                    {{ $job->category }}
                                </option>
                            @endforeach
                        </select>
                        @error('job_position')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Full Name -->
                    <div>
                        <label class="mb-1 block font-semibold text-gray-700">Full Name</label>
                        <input type="text" name="full_name" class="p-2 border rounded-md w-full"
                            placeholder="Enter your name" value="{{ old('full_name') }}" />
                        @error('full_name')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Father's Name -->
                    <div>
                        <label class="mb-1 block font-semibold text-gray-700">Father Name</label>
                        <input type="text" name="father_name" class="p-2 border rounded-md w-full"
                            placeholder="Enter father's name" value="{{ old('father_name') }}" />
                        @error('father_name')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Qualification -->
                    <div>
                        <label class="mb-1 block font-semibold text-gray-700">Qualification</label>
                        <input type="text" name="qualification" class="p-2 border rounded-md w-full"
                            placeholder="Enter Qualification" value="{{ old('qualification') }}" />
                        @error('qualification')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>
                    <!-- Expereince -->
                    <div>
                        <label class="mb-1 block font-semibold text-gray-700">experience</label>
                        <input type="number" name="experience" class="p-2 border rounded-md w-full"
                            placeholder="Enter Experience" value="{{ old('experience') }}" />
                        @error('experience')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>
                    <!-- Applied For -->
                    <div>
                        <label class="mb-1 block font-semibold text-gray-700">Apply for Position</label>
                        <input type="text" name="applied_position" class="p-2 border rounded-md w-full"
                            placeholder="Enter if apply for different position" value="{{ old('applied_position') }}" />
                        @error('applied_position')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Email -->
                    <div>
                        <label class="mb-1 block font-semibold text-gray-700">Email</label>
                        <input type="email" name="email" class="p-2 border rounded-md w-full"
                            placeholder="Enter email address" value="{{ old('email') }}" />
                        @error('email')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Primary Contact No -->
                    <div>
                        <label class="mb-1 block font-semibold text-gray-700">Primary Contact No</label>
                        <input type="text" name="primary_contact_no" class="p-2 border rounded-md w-full"
                            placeholder="Enter Primary Contact Number" value="{{ old('primary_contact_no') }}" />
                        @error('primary_contact_no')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Complete Address -->
                    <div>
                        <label class="mb-1 mt-2 block font-semibold text-gray-700">Complete Address</label>
                        <textarea name="complete_address" class="p-2 border rounded-md w-full h-24 resize-none"
                            placeholder="Enter complete address">{{ old('complete_address') }}</textarea>
                        @error('complete_address')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- CV/Resume -->
                    <div>
                        <p class="block font-semibold mb-1">CV/Resume</p>
                        <!-- Preview appears above the input -->
                        <div id="cvPreview" class="mb-2"></div>
                        <label
                            class="w-full flex gap-x-3 h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500">
                            <img src="{{ asset('assets/upload.png') }}" alt="icon" />
                            <div class="flex flex-col items-center">
                                <span class="text-sm text-gray-500 mt-2">
                                    <span class="text-[#0197FF]">Upload a file </span>or Drag and drop
                                </span>
                                <span class="text-xs text-gray-400 mt-1">PDF, DOC up to 10MB</span>
                                <input type="file" name="cv_resume" class="hidden" accept=".pdf, .doc, .docx" />
                            </div>
                        </label>
                        @error('cv_resume')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <div>
                        <label class="mb-1 mt-2 block font-semibold text-gray-700">Cover Letter</label>
                        <textarea name="cover_letter" class="p-2 border rounded-md w-full h-24 resize-none"
                            placeholder="Enter Cover letter if any">{{ old('cover_letter') }}</textarea>
                        @error('cover_letter')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                </div>

                <!-- Submit Button -->
                <div class="flex justify-end gap-x-4">
                    <button type="button" class="border px-2 rounded-md border-gray-700"
                        onclick="window.location.href='{{ route('job_application') }}'">Cancel</button>
                    <button type="submit" class="bg-[#0197FF] text-white p-2 rounded-md hover:bg-blue-700 transition">
                        Submit Application
                    </button>
                </div>
            </form>
            <!-- Form Ends Here -->
        </div>
    </div>
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/jquery.validation/1.19.5/jquery.validate.min.js"></script>
<script>
$(document).ready(function () {
    // Custom file size validation (max 10MB)
    $.validator.addMethod('filesize', function (value, element, param) {
        return this.optional(element) || (element.files[0].size <= param);
    }, 'File size must be less than 10MB');

    // jQuery Validation
    $("#form").validate({
        rules: {
            job_position: { required: true },
            full_name: { required: true },
            father_name: { required: true },
            qualification: { required: true },
            experience: { required: true, number: true, min: 0 },
            email: { required: true, email: true },
            primary_contact_no: { required: true },
            complete_address: { required: true },
            cv_resume: { required: true, extension: "pdf|doc|docx", filesize: 10 * 1024 * 1024 }
        },
        messages: {
            job_position: "Please select a job position",
            full_name: "Please enter your full name",
            father_name: "Please enter your father's name",
            qualification: "Please enter your qualification",
            experience: {
                required: "Please enter your experience",
                number: "Please enter a valid number",
                min: "Experience cannot be negative"
            },
            email: {
                required: "Please enter your email",
                email: "Please enter a valid email"
            },
            primary_contact_no: "Please enter your primary contact number",
            complete_address: "Please enter your complete address",
            cv_resume: {
                required: "Please upload your CV/Resume",
                extension: "Only PDF, DOC, DOCX files are allowed",
                filesize: "File must be less than 10MB"
            }
        },
        errorClass: "text-red-500 text-sm",
        errorElement: "span",
        highlight: function(element) {
            $(element).addClass('border-red-500');
        },
        unhighlight: function(element) {
            $(element).removeClass('border-red-500');
        }
    });

    // CV/Resume Preview
    $("input[name='cv_resume']").on("change", function () {
        var file = this.files[0];
        var preview = $("#cvPreview");
        preview.html(""); // Clear previous preview

        if (file) {
            var ext = file.name.split('.').pop().toLowerCase();
            if (ext === "pdf") {
                var url = URL.createObjectURL(file);
                preview.html('<embed src="' + url + '" type="application/pdf" width="100%" height="200px" />');
            } else if (ext === "doc" || ext === "docx") {
                preview.html('<span class="text-gray-700">Selected file: ' + file.name + '</span>');
            } else {
                preview.html('<span class="text-red-500">Unsupported file type</span>');
            }
        }
    });

    // Prevent form submission if CV/Resume is not uploaded
    $("#form").on("submit", function(e) {
        if ($("input[name='cv_resume']").get(0).files.length === 0) {
            e.preventDefault();
            $("#cvPreview").html('<span class="text-red-500">Please upload your CV/Resume.</span>');
        }
    });
});
</script>
