<div class="relative bg-white mt-4">
    <table class="w-full border-collapse">
        <thead class="bg-[#f9fafc]">
            <tr class="text-gray-600">
                <th class="p-3 text-left font-medium">HeadCode</th>
                <th class="p-3 text-left font-medium">Name</th>
                <th class="p-3 text-left font-medium">Date</th>
                <th class="p-3 text-left font-medium">Amount</th>
                <th class="p-3 text-center font-medium">Attachment</th>
                <th class="p-3 text-left font-medium">Description</th>
            </tr>
        </thead>
        <tbody class="bg-white py-3 rounded-lg">
            @forelse($incomeDetails as $income)
                <tr class="border-b">
                    <td class="p-3 font-semibold text-black">{{ $income->income_account_id ?? 'N/A' }}</td>
                    <td class="p-3 font-semibold text-black">{{ $income->income_category->name ?? 'N/A' }}</td>
                    <td class="p-3 text-gray-500">{{ \Carbon\Carbon::parse($income->date)->format('Y-m-d') }}</td>
                    <td class="p-3 text-gray-500">{{ number_format($income->amount ?? 0, 2) }}</td>
                    <td class="p-3 text-center">
                        @if ($income->attachment)
                            <a href="{{ asset('storage/' . $income->receipt_file) }}" target="_blank">
                                <i class="fa-solid fa-file text-blue-600"></i>
                            </a>
                        @else
                            <span class="text-gray-400">-</span>
                        @endif
                    </td>
                    <td class="p-3 text-gray-500">{{ $income->description ?? 'N/A' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="p-4 text-center text-gray-400">No records found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="p-4 flex justify-between items-center">
        <div class="text-gray-500 text-sm">
            Showing {{ $incomeDetails->firstItem() ?? 0 }} to {{ $incomeDetails->lastItem() ?? 0 }} of {{ $incomeDetails->total() }} entries
        </div>
        <div>
            {{ $incomeDetails->links() }}
        </div>
    </div>
</div>
