@extends('schoolLayout.app')

@section('content')
@include('successError')

<div class="bg-[#f9fafc] px-8 py-8 min-h-screen">
    <!-- Tabs -->
    <div class="flex justify-between items-center pb-4">
       @include('income.head')
    </div>

    <!-- Create New Button -->
    <div class="flex justify-end mb-4">
        <button onclick="openModal()"
            class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
            + Create New Income Category
        </button>
    </div>

    <!-- Main Section -->
    <div class="bg-white p-4 rounded-lg shadow-md">
        <!-- Search Bar -->
        <div class="py-4 flex justify-between items-center px-4 gap-4">
            <div class="relative w-[50%]">
                <div class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
                    <span class="text-gray-500">
                        <img src="{{ asset('assets/search.png') }}" alt="icon" />
                    </span>
                    <input type="text" id="searchInput" placeholder="Search category..."
                        class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none"
                        onkeyup="filterTable()" />
                </div>
            </div>
        </div>

        <!-- Table -->
        <div class="rounded-lg relative">
            <table class="w-full border-collapse" id="categoryTable">
                <thead class="border-b border-gray-200">
                    <tr class="text-gray-600">
                        <th class="p-3 text-left font-medium">Category Name</th>
                        <th class="p-3 text-left font-medium">Description</th>
                    </tr>
                </thead>
                <tbody class="bg-white">
                    @forelse ($categories as $category)
                        <tr class="border-b table-row">
                            <td class="p-3 font-semibold text-black">{{ $category->name }}</td>
                            <td class="p-3 text-gray-500">{{ $category->description }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center py-4 text-gray-500">
                                No income categories found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>

            <!-- Pagination -->
            <div class="flex pt-4 border-t border-gray-200 mt-8 bg-white justify-between items-center rounded-lg">
                <div>
                    <p class="text-gray-500 text-sm">
                        Showing {{ $categories->firstItem() ?? 0 }} to {{ $categories->lastItem() ?? 0 }} of {{ $categories->total() }} entries
                    </p>
                </div>
                <div>
                    {{ $categories->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div id="incomeCategoryModal"
    class="fixed inset-0 bg-black bg-opacity-40 flex justify-center items-center hidden z-50">
    <div class="bg-white w-[90%] md:w-[500px] p-6 rounded-lg relative shadow-xl">
        <button onclick="closeModal()"
            class="absolute top-2 right-2 text-gray-500 hover:text-black text-xl">&times;</button>

        <h2 class="text-lg font-semibold mb-4">Create New Income Category</h2>

        <form action="{{ route('income.catg.store') }}" method="POST">
            @csrf
            <div class="mb-4">
                <label for="name" class="block text-sm font-medium text-gray-700">
                    Category Name <span class="text-red-500">*</span>
                </label>
                <input type="text" name="name" id="name" value="{{ old('name') }}"
                    class="w-full mt-1 p-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('name') border-red-500 @enderror"
                    placeholder="Enter category name" />
                @error('name')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="description" class="block text-sm font-medium text-gray-700">
                    Description
                </label>
                <textarea name="description" id="description"
                    class="w-full mt-1 p-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('description') border-red-500 @enderror"
                    rows="3" placeholder="Enter category description">{{ old('description') }}</textarea>
                @error('description')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex justify-end">
                <button type="submit"
                    class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                    Save
                </button>
            </div>
        </form>
    </div>
</div>

<!-- JavaScript -->
<script>
    // Modal Control
    function openModal() {
        document.getElementById('incomeCategoryModal').classList.remove('hidden');
    }

    function closeModal() {
        document.getElementById('incomeCategoryModal').classList.add('hidden');
    }

    // Auto open modal on error
    @if ($errors->any())
        window.onload = function () {
            openModal();
        };
    @endif

    // Table Search
    function filterTable() {
        const input = document.getElementById("searchInput").value.toLowerCase();
        const rows = document.querySelectorAll("#categoryTable tbody tr");

        rows.forEach(row => {
            const cells = row.querySelectorAll("td");
            const match = Array.from(cells).some(cell => 
                cell.textContent.toLowerCase().includes(input)
            );

            row.style.display = match ? "" : "none";
        });
    }
</script>
@endsection
