@extends('schoolLayout.app')
@section('content')
@include('successError')

    <div class="bg-[#f9fafc] px-8 py-8 min-h-screen">
        <div class="flex justify-between items-center pb-4">
            <!-- Tabs: -->
            <div class="flex space-x-4 w-full">
                <button class="tab-btn px-4 pb-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Expense Categories
                </button>
                <button class="tab-btn pb-4 text-gray-700 font-semibold"
                    onclick="window.location.href='{{ route('show.expenses') }}'">
                    All Expenses
                </button>
            </div>
        </div>
        <div class="flex justify-between gap-x-4">
            <div class="w-[30%] bg-white p-4 rounded-lg shadow-md">
                <h2 class="text-lg font-semibold mb-4">Create New Expense Category</h2>
                <form action="{{ route('expense.categories.store') }}" method="POST">
                    @csrf
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Category Name</label>
                        <input type="text" name="category_name"
                            class="w-full mt-1 p-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            placeholder="Enter category name" />
                    </div>
                    <div class="mb-12">
                        <label class="block text-sm font-medium text-gray-700">Category type</label>
                        <select name="category_type"
                            class="w-full mt-1 p-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="shortTerm">Short term</option>
                            <option value="longTerm">Long term</option>
                        </select>
                    </div>
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Description</label>
                        <textarea name="description"
                            class="w-full mt-1 p-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            rows="3" placeholder="Enter category description"></textarea>
                    </div>
                    <button type="submit"
                        class="mx-auto px-4 flex items-center gap-x-1 bg-blue-500 text-white py-2 rounded-md hover:bg-blue-600 transition">
                        <i class="fa-solid fa-plus"></i>
                        Generate Category
                    </button>
                </form>
            </div>

            <div class="w-[70%] bg-white p-4 rounded-lg shadow-md">

                <div class="rounded-lg relative">
                    <table class="w-full border-collapse">
                        <thead class="border-b border-gray-200">
                            <tr class="text-gray-600">
                                <th class="p-3 text-left font-medium">Category Name</th>
                                <th class="p-3 text-left font-medium">Category Type</th>
                                <th class="p-3 text-left font-medium">Description</th>
                                <th class="p-3 text-center font-medium">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white">
                            @if ($categories)
                                @foreach ($categories as $category)
                                    <tr class="border-b">
                                        <td class="p-3 font-semibold text-black">{{ $category->name }}</td>
                                        <td class="p-3 text-gray-500">{{ $category->account_type }}</td>
                                        <td class="p-3 text-gray-500">{{ $category->description }}</td>
                                        <td class="p-3 text-center flex justify-center items-center gap-x-4">
                                            <i class="fa-solid fa-pen-to-square text-black edit-btn cursor-pointer"
                                                data-id="{{ $category->id }}" data-name="{{ $category->name }}"
                                                data-type="{{ $category->account_type }}"
                                                data-description="{{ $category->description }}"
                                                onclick="openModal(this)"></i>
                                            {{--  <i class="fa-solid fa-trash text-red-500 cursor-pointer delete-btn" data-id="{{ $category->id }}" onclick="deleteCategory(this)"></i>
 --}}
                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                    {{ $categories->links('vendor.pagination.custom-pagination') }}
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Category Modal -->
    <div id="editCategoryModal"
        class="hidden fixed inset-0 z-50 overflow-auto bg-black bg-opacity-50 flex items-center justify-center">
        <div class="bg-white rounded-lg shadow-lg w-11/12 md:w-1/2 lg:w-1/3 p-6">
            <div class="flex justify-between items-center pb-4">
                <h5 class="text-lg font-semibold">Edit Expense Category</h5>
                <button type="button" class="text-gray-500 hover:text-gray-700" onclick="closeModal()">
                    <span class="text-2xl">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="editCategoryForm" action="{{ route('expense.categories.update', ['id' => ':id']) }}"
                    method="POST">
                    @csrf
                    @method('PUT')
                    <div class="mb-4">
                        <label for="editCategoryName" class="block text-sm font-medium text-gray-700">Category Name</label>
                        <input type="text"
                            class="w-full mt-1 p-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            id="editCategoryName" name="category_name" required>
                    </div>
                    <div class="mb-4">
                        <label for="editCategoryType" class="block text-sm font-medium text-gray-700">Category Type</label>
                        <select
                            class="w-full mt-1 p-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            id="editCategoryType" name="category_type" required>
                            <option value="shortTerm">Short term</option>
                            <option value="longTerm">Long term</option>
                        </select>
                    </div>
                    <div class="mb-4">
                        <label for="editCategoryDescription"
                            class="block text-sm font-medium text-gray-700">Description</label>
                        <textarea class="w-full mt-1 p-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            id="editCategoryDescription" name="description"></textarea>
                    </div>
                    <div class="flex justify-end">
                        <button type="button" class="px-4 py-2 bg-gray-500 text-white rounded-md hover:bg-gray-600"
                            onclick="closeModal()">Close</button>
                        <button type="submit"
                            class="ml-2 px-4 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600">Save
                            changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        // Function to open the modal and populate the form
        function openModal(button) {
            const id = button.getAttribute('data-id');
            const name = button.getAttribute('data-name');
            const type = button.getAttribute('data-type');
            const description = button.getAttribute('data-description');

            // Set the form action URL with the correct ID
            const formAction = document.getElementById('editCategoryForm').action.replace(':id', id);
            document.getElementById('editCategoryForm').action = formAction;

            // Populate the form fields with the data
            document.getElementById('editCategoryName').value = name;
            document.getElementById('editCategoryType').value = type;
            document.getElementById('editCategoryDescription').value = description;

            // Show the modal
            document.getElementById('editCategoryModal').classList.remove('hidden');
        }

        // Function to close the modal
        function closeModal() {
            document.getElementById('editCategoryModal').classList.add('hidden');
        }

        function deleteCategory(element) {
            const id = element.getAttribute('data-id');
            if (confirm('Are you sure you want to delete this category?')) {
                window.location.href = '/account/expense-categories-delete/' + id;
            }
        }
    </script>
@endsection
