@extends('schoolLayout.app')
@section('content')

    @if (session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error:</strong>
            <span class="block sm:inline">{{ session('error') }}</span>
        </div>
    @endif

    @if (session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Success:</strong>
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
    @endif

    <div class="bg-[#f9fafc] min-h-screen px-8 py-4">
        <!-- Top Section: Tabs & Button -->
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-md" id="openModal">
                <i class="fa-solid fa-plus"></i>
                <span>Add New Exam</span>
            </button>
        </div>

        <div class="border p-3 bg-white border-gray-200 rounded-lg my-4">

            <div class="relative bg-white">
                <table class="w-full border-collapse">
                    <thead class="bg-[#f9fafc]">
                        <tr class="text-gray-600">
                            <th class="p-3 text-left text-gray-500 font-medium">Exam Title</th>
                             <th class="p-3 text-left text-gray-500 font-medium">Exam Type</th>
                             <th class="p-3 text-left text-gray-500 font-medium">Notes</th>
                              <th class="p-3 text-left text-gray-500 font-medium">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white py-3 rounded-lg">
                        @if ($all_exams)
                            @foreach ($all_exams as $exam)
                                <tr class="border-b">
                                   
                                     <td class="p-3 text-gray-700">{{ $exam->title }}</td>
                                    <td class="p-3 text-gray-700">{{ $exam->type }}</td>
                                    <td class="p-3 text-gray-700">
                                        {{ Str::limit($exam->notes, 30) }}
                                    </td>
                                    <td class="p-3 flex items-center gap-x-4">
                                        <i class="fa-solid fa-pen-to-square text-blue-500 cursor-pointer"
                                            onclick="openEditModal({
                                        id: '{{ $exam->id }}',
                                        name: '{{ $exam->title }}',
                                        type: '{{ $exam->type }}',
                                        code: '{{ $exam->notes }}'
                                    })"></i>
                                        <i class="fa-solid fa-trash text-red-500 cursor-pointer"
                                            data-id="{{ $exam->id }}" onclick="deleteClass(this)"></i>
                                    </td>
                                </tr>
                            @endforeach
                        @endif


                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal Background (Initially Hidden) -->
    <div id="modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <!-- Modal Content -->
        <div class="bg-white w-full max-w-lg rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <!-- Modal Header -->
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Create New Exam</h2>
                <button type="button" id="closeModal" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <!-- Modal Body -->
            <form class="bg-white px-6 py-3" action="{{ route('exam.store') }}" method="post">
                @csrf
                <!-- Class Name -->
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Exam Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" placeholder="First Term, Mid Term" name="name"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" />
                </div>

                <!-- Class Code -->
                 <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Exam Type <span class="text-red-500">*</span>
                    </label>
                    <select name="exam_type" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">Select exam type</option>
                        <option value="Mid">Mid Term</option>
                        <option value="Final">Final Term</option>
                        <option value="Others">Others</option>
                    </select>
                </div>

                <!-- Description Code -->
                 <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Description <span class="text-red-500">*</span>
                    </label>
                    <textarea name="notes" rows="4" placeholder="Description"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" required></textarea>
                </div>


                <!-- Modal Footer -->
                <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button id="closeModalBtn" type="button"
                        class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Create Exam
                    </button>
                </div>
            </form>
        </div>
    </div>

  {{-- Edit modal  --}}
    <div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <div class="bg-white w-full max-w-lg rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Edit Exam</h2>
                <button onclick="closeModal()" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <form id="editExamForm" method="POST" class="bg-white px-6 py-3">
                @csrf
                <input type="hidden" name="_method" value="PUT">
                <input type="hidden" id="editExamId" name="id">

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Exam Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="editExamName" name="name"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                        required>
                </div>
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Exam Type <span class="text-red-500">*</span>
                    </label>
                    <select id="editExamType" name="exam_type" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="Mid">Mid Term</option>
                        <option value="Final">Final Term</option>
                        <option value="Others">Others</option>
                    </select>
                </div>
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Description <span class="text-red-500">*</span>
                    </label>
                    <textarea id="editExamDescription" name="notes" rows="4" placeholder="Description"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                        required></textarea>
                </div>

                <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button type="button" onclick="closeModal()"
                        class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Update Exam
                    </button>
                </div>
            </form>
        </div>
    </div>




    <script>
        // Modal functionality
        const modal = document.getElementById("modal");
        const openModalBtn = document.getElementById("openModal");
        const closeModalBtns = [
            document.getElementById("closeModal"),
            document.getElementById("closeModalBtn"),
        ];

        openModalBtn.addEventListener("click", () => {
            modal.classList.remove("hidden");
        });

        closeModalBtns.forEach((btn) => {
            btn.addEventListener("click", () => {
                modal.classList.add("hidden");
            });
        });


        function openEditModal(classData) {
            document.getElementById('editExamName').value = classData.name;
            document.getElementById('editExamType').value = classData.type; // Fixed ID
            document.getElementById('editExamDescription').value = classData.code;
            document.getElementById('editExamForm').action = `/exam/update/${classData.id}`;
            document.getElementById('editModal').classList.remove('hidden');
        }

        function closeModal() {
            document.getElementById('editModal').classList.add('hidden');
        }

        function deleteClass(element) {
            if (confirm('Are you sure you want to delete this Exam?')) {
                let a = document.createElement('a');
                a.href = `/exam/delete/${element.dataset.id}`;
                a.click();
            }
        }

        // Close modal when clicking outside
        document.addEventListener('DOMContentLoaded', function() {
            window.onclick = function(event) {
                const modal = document.getElementById('editModal');
                if (event.target === modal) {
                    closeModal();
                }
            }
        });
    </script>



@endsection
