@extends('schoolLayout.app')
@section('content')
  @include('successError')

    <div class="flex justify-between items-center pb-4">
      <h1 class="text-2xl font-bold mb-6">Exam Timetable Managment</h1>
      <button
        onclick="window.location.href='{{ route('exam.timetable.create') }}'"
        class="flex items-center bg-[#1B9AF5] p-2 rounded-md text-white px-4 gap-x-2"
      >
        <i class="fa-solid fa-plus"></i>
        <span>Create New Exam Timetable</span>
      </button>
    </div>
    <div class="border border-gray-200 rounded-lg">
      <div class="rounded-lg relative">
        <table class="w-full border-collapse">
          <thead>
            <tr class="text-gray-600">
              <th class="p-3 text-left font-medium">Exam Name</th>
              <th class="p-3 text-left font-medium">Session</th>
              <th class="p-3 text-left font-medium">Classes</th>
              <th class="p-3 text-left font-medium">Start Date</th>
              <th class="p-3 text-center font-medium">End Date</th>
              <th class="p-3 text-center font-medium">Type</th>
              <th class="p-3 text-center font-medium">Time Table</th>
              <th class="p-3 text-center font-medium">Actions</th>
            </tr>
          </thead>
          <tbody class="bg-white">
            @if($exam_time_table)
                @foreach($exam_time_table as $exam_id => $examTimetable)
                    @php
                        $first = $examTimetable->first(); // get first record to access exam/session
                        $class_names = $examTimetable->pluck('class.name')->unique();
                        $start_date = $examTimetable->min('exam_date');
                        $end_date = $examTimetable->max('exam_date');
                    @endphp
                    <tr class="border-b">
                        <td class="p-3 font-semibold">{{ $first->exam->title }}</td>
                        <td class="p-3 text-gray-500">{{ $first->academic_session }}</td>
                        <td class="p-3 text-gray-500">{{ implode(', ', $class_names->toArray()) }}</td>
                        <td class="p-3 text-gray-500">{{ $start_date}}</td>
                        <td class="p-3 text-gray-500">{{$end_date}}</td>
                        <td class="p-3 text-center text-gray-500">
                            <span class="bg-[#DCFCE7] text-[#166534] font-semibold px-2 py-0.5 rounded-2xl text-sm">
                            {{ $first->exam->type }}
                            </span>
                        </td>
                        <td class="p-3 text-center ">
                            <i onclick="showExamTimetableModal('{{ $exam_id }}')" class="fa-solid fa-eye text-[#1B9AF5] cursor-pointer"></i>
                        </td>
                        <td class="p-3 text-center flex justify-center items-end gap-x-4">
                           <a href="{{route('exam.timetable.edit',$exam_id) }} " > <i class="fa-solid fa-pen-to-square text-[#4B5563] cursor-pointer"></i> </a>
<!--                             <i class="fa-solid fa-trash text-red-500 cursor-pointer"></i>
 -->                        </td> 
                    </tr>
                @endforeach
            @endif
          </tbody>
        </table>
      </div>
    </div>

<!-- Modal -->
<div id="modal" class="fixed inset-0 bg-black bg-opacity-40 flex items-center justify-center z-50 hidden">
    <div class="bg-white rounded-xl shadow-lg max-w-6xl w-full relative max-h-[90vh] overflow-y-auto">
        <!-- Close button -->
        <div class="flex border-b border-gray-200 mb-4 justify-between items-center w-full px-6 py-4 sticky top-0 bg-white z-10">
            <h2 class="text-2xl" id="modal-title">Exam Timetable</h2>
            <button onclick="document.getElementById('modal').classList.add('hidden')" class="text-gray-600 hover:text-black text-xl">
                <i class="fa-solid fa-xmark text-xl"></i>
            </button>
        </div>
        <div class="overflow-x-auto px-6 pb-6">
            <div id="modal-content">
                <!-- Content will be loaded here dynamically -->
            </div>
        </div>
    </div>
</div>

<script>
    function showExamTimetableModal(examId) {
        // Fetch the exam timetable data for the specific exam
        fetch(`/exam-timetable-details/${examId}`)
            .then(response => response.json())
            .then(data => {
                // Set the modal title
                document.getElementById('modal-title').textContent = `${data.examTitle} Timetable`;
                
                // Build the table HTML
                let html = `
                    <div
      id="modal"
      class="fixed inset-0 bg-black bg-opacity-40 flex items-center justify-center   z-50"
    >
      <div class="bg-white rounded-xl shadow-lg max-w-6xl w-full relative">
        <!-- Close button -->
        <div class="flex border-b border-gray-200 mb-4 justify-between items-center w-full px-6 py-4">
          <h2 class="text-2xl">Exam Timetable</h2>
          <button
            onclick="document.getElementById('modal').classList.add('hidden')"
            class="text-gray-600 hover:text-black text-xl"
          >
            <i class="fa-solid fa-xmark text-xl"></i>
          </button>
        </div>
        <div class="overflow-x-auto px-6">
          <table class="min-w-full text-sm text-center border border-gray-300">
            <thead class="bg-[#f9fafc]">
              <tr>
                <th class="border font-medium text-gray-700 px-4 py-2">Date</th>
                <th class="border font-medium text-gray-700 px-4 py-2">Day</th>
              
                `;
                
                // Add class columns
                data.classes.forEach(classItem => {
                    html += `<th class="border font-medium text-gray-700 px-4 py-2">${classItem}</th>`;
                });
                
                html += `</tr></thead><tbody>`;
                
                // Add rows for each date
                data.schedule.forEach(dateItem => {
                    html += `<tr class="bg-white">
                        <td class="border px-4 py-2">${dateItem.date}</td>
                        <td class="border px-4 py-2">${dateItem.day}</td>`;
                    
                    // Add subject for each class
                    data.classes.forEach(classItem => {
                        const scheduleItem = dateItem.classes.find(c => c.className === classItem);
                        console.log(scheduleItem);
                        // Check if scheduleItem exists and has subject property
                        const subject = scheduleItem?.subject?.name ?? '-';
                        console.log(subject);
                        html += `<td class="border px-4 py-2">${subject}</td>`;
                    });
                    
                    html += `</tr>`;
                });
                
                html += `</tbody></table></div><div class="flex px-4 py-3 bg-[#f9fafc] justify-end items-center mt-6 space-x-4">
            
           
          
            <button
             onclick="window.location.href='/exam-timetable-pdf/${examId}'"
              class="bg-[#1B9AF5] text-white rounded-md hover:bg-blue-700 flex items-center gap-2 justify-center w-36 h-10"
            >
              <i class="fas fa-download"></i> Download
            </button>
          </div>
          
      </div>
    </div>`;
                
                // Set the modal content
                document.getElementById('modal-content').innerHTML = html;
                
                // Show the modal
                document.getElementById('modal').classList.remove('hidden');
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Failed to load exam timetable details');
            });
    }
</script>

@endsection