@extends('schoolLayout.app')
@section('content')
<div class="px-6 py-6 bg-[#f9fafc] min-h-screen">

    <!-- Search Bar -->
    <form method="GET" class="mb-6">
        <div class="flex items-center space-x-2">
            <input type="text" name="search" value="{{ $search ?? '' }}" placeholder="Search Student by name , email father name or reg no"
                class="px-4 py-2 border rounded-md w-64" />
            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                Search
            </button>
        </div>
    </form>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @forelse ($student as $person)
            <a href="{{ route('doc.students.documents', $person->id) }}" class="block hover:shadow-lg transition duration-200">
            <div class="bg-white p-4 rounded-lg shadow-md">
                <div class="mb-3 space-y-1">
                    <h3 class="text-lg font-bold text-gray-800">{{ $person->student_name }}</h3>
                    <p class="text-sm text-gray-600">Father Name: {{ $person->father_name }}</p>
                    <p class="text-sm text-gray-600">Email: {{ $person->email }}</p>
                    <p class="text-sm text-gray-600">CNIC: {{ $person->email }}</p>
                    <p class="text-sm text-gray-600">Reg. No: {{ $person->reg_no }}</p>
                </div>
            </div>
        </a>

        @empty
            <p class="text-gray-600 col-span-3">No matching staff found.</p>
        @endforelse
    </div>
    
    
</div>
@endsection
